# Berlin Business Setup Guide

## Business Structures

### Freiberufler (Freelancer)
**Best for**: Consultants, developers, designers, writers

- No registration required (just tax office)
- No minimum capital
- Simple accounting
- Taxed on personal income
- Ideal for starting out

**Qualifying professions**:
- IT/Software development
- Consulting
- Design (UX, graphic)
- Writing, translation
- Teaching, coaching
- Artists

### Einzelunternehmen (Sole Proprietorship)
**Best for**: Small traders, service providers

- Register at Gewerbeamt (trade office)
- No minimum capital
- Personal liability
- Simple but not Freiberufler-eligible activities

### GmbH (Limited Liability Company)
**Best for**: Scaling startups, investor-ready

- **Minimum capital**: €25,000 (€12,500 deposited initially)
- Limited liability
- Notary required
- Complex accounting
- Professional image
- Setup cost: €2,000-5,000

### UG (Mini-GmbH)
**Best for**: Starting with limited funds

- **Minimum capital**: €1
- Limited liability
- Must retain 25% of profits until €25,000
- Same structure as GmbH
- Stepping stone to GmbH
- Setup cost: €500-1,500

## Registration Process

### For Freiberufler
1. **Fragebogen zur steuerlichen Erfassung**: Tax questionnaire
2. Submit to Finanzamt (tax office)
3. Receive Steuernummer (tax ID)
4. Can invoice immediately
5. No trade license needed

### For Gewerbe (Trade)
1. Register at Gewerbeamt (€20-30)
2. Receive Gewerbeschein
3. Register with Finanzamt
4. Register with IHK (Chamber of Commerce)
5. Possible: Handwerkskammer (trades)

### For GmbH/UG
1. Draft articles of association (Satzung)
2. Notary appointment (Gesellschaftsvertrag)
3. Open business bank account
4. Deposit share capital
5. Register at Handelsregister (commercial register)
6. Register with Finanzamt
7. Register with IHK
8. Processing: 2-6 weeks

## Taxes

### Freiberufler Taxes
| Tax | Rate | When |
|-----|------|------|
| Income tax (Einkommensteuer) | 14-45% | Annual |
| VAT (Umsatzsteuer) | 19% | Monthly/Quarterly |
| Solidarity surcharge | 5.5% of income tax | Annual |

### VAT (Umsatzsteuer)
- **Standard rate**: 19%
- **Reduced rate**: 7% (food, books, etc.)
- **Kleinunternehmer**: Exempt if <€22,000/year revenue
- **B2B to EU**: Often reverse-charge (no VAT)

### GmbH Taxes
| Tax | Rate |
|-----|------|
| Corporate tax | 15% |
| Trade tax | ~14% (Berlin) |
| Solidarity surcharge | 5.5% of corp tax |
| **Effective rate** | ~30% |

## Accounting Requirements

### Freiberufler
- Income-expense accounting (EÜR)
- Keep receipts (10 years)
- Annual tax return (by July 31)
- Quarterly VAT if applicable

### GmbH/UG
- Double-entry bookkeeping
- Annual financial statements
- Publication in Bundesanzeiger
- Auditor required if >€6M revenue

## Banking for Business

| Bank | Best For | Notes |
|------|----------|-------|
| N26 Business | Freelancers | Free, limited features |
| Kontist | Freelancers | Tax automation |
| Holvi | Small business | EU focus |
| Penta/Qonto | GmbH/UG | Full business banking |
| Commerzbank | Traditional | Physical branches |
| Deutsche Bank | Large business | Corporate banking |

## Hiring

### Employment Types
- **Full-time (Vollzeit)**: Standard, all benefits
- **Part-time (Teilzeit)**: Prorated benefits
- **Mini-job**: €520/month max, limited taxes
- **Contractor**: Careful - Scheinselbständigkeit rules

### Employer Costs
On top of gross salary:
- Pension: ~9.3%
- Health: ~7.3%
- Unemployment: ~1.2%
- Long-term care: ~1.7%
- **Total**: ~20% on top of gross

### Hiring Process
1. Job posting
2. Interview
3. Contract (template available)
4. Register with Sozialversicherung
5. Payroll setup

## Support Resources

### Government
- **IHK Berlin**: Chamber of Commerce, advice
- **Gründerservice**: Startup support
- **Berlin Partner**: Economic development

### Startup Ecosystem
- **Factory Berlin**: Hub, community
- **German Accelerator**: International scaling
- **Berlin Startup Stipendium**: €1,500/month for 6 months

### Funding
- **KfW**: Government loans
- **EXIST**: Research spinoff grant
- **Berlin VC scene**: Strong for tech

## Common Mistakes

1. **Scheinselbständigkeit**: Disguised employment
   - One main client = risky
   - Fixed hours = risky
   - Solution: Multiple clients, flexible work

2. **VAT registration delay**: Register early, claim input VAT

3. **Ignoring Anmeldung**: Need address for everything

4. **Wrong business structure**: Start simple, scale up

5. **No accountant**: Get one early, German tax is complex
