---
name: Berlin
slug: berlin
version: 1.0.0
homepage: https://clawic.com/skills/berlin
description: Navigate Berlin as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"🐻","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Berlin for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Mitte, Prenzlauer Berg | `neighborhoods-central.md` |
| Kreuzberg, Neukölln | `neighborhoods-east.md` |
| Charlottenburg, Wilmersdorf | `neighborhoods-west.md` |
| Friedrichshain, Lichtenberg | `neighborhoods-alt.md` |
| Wedding, Moabit | `neighborhoods-north.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & food culture | `food-overview.md` |
| German cuisine (currywurst, döner) | `food-local.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Dietary, bars, practical | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (U-Bahn, S-Bahn, BVG) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & laws | `safety.md` |
| Weather & seasons | `climate.md` |
| Local services (banking, Anmeldung) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup & freelancing | `business.md` |
| Visas (work, freelance, EU Blue Card) | `visas.md` |
| Startups & funding | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & insurance | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Cycling & mobility | `cycling.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur, digital nomad
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. City Reality
Berlin is Germany's capital with unique characteristics:
- **Size**: 892 km² — largest city in Germany, sprawling
- **Population**: 3.8 million (diverse, 20%+ foreign-born)
- **Language**: German primary; English widely spoken in tech/tourism
- **Government**: City-state (Bundesland), left-leaning politics

### 3. Visa Categories
Non-EU citizens need proper documentation:
- **EU Blue Card**: €45,300+ salary (€41,042 for shortage occupations), university degree
- **Work Visa**: Job offer required, employer sponsorship
- **Freelance Visa (Freiberufler)**: Most unique — self-sponsorship possible with client proof
- **Job Seeker Visa**: 6 months to find employment
- **Student Visa**: Enrolled in German institution
See `visas.md` for current requirements (Feb 2026).

### 4. Weather Reality
Berlin has distinct seasons:
- **Summer** (Jun-Aug): 20-30°C, long days (sunrise 5am, sunset 9:30pm)
- **Winter** (Dec-Feb): -5 to 5°C, short days (sunrise 8am, sunset 4pm), grey
- **Spring/Fall**: Transitional, unpredictable
- **Key**: Winter affects mental health — light therapy common among expats
See `climate.md` for monthly breakdown.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (central) | €1,200-2,000/month |
| 1BR rent (outer) | €800-1,300/month |
| WG room (shared flat) | €500-900/month |
| Senior SWE salary | €70,000-95,000/year gross |
| BVG monthly pass | €86 (AB zones) |
| Döner kebab | €6-8 |
| Restaurant dinner | €20-50/person |
| Health insurance | €200-400/month (public) |

### 6. Cost Reality
Berlin is cheap for Western Europe:
- **Rent**: Rising fast but still 40-60% cheaper than Munich/London
- **Income tax**: 42% top rate + solidarity surcharge — high but includes healthcare
- **Healthcare**: Mandatory, public or private (choice based on income)
- **Hidden costs**: Rundfunkbeitrag (€18.36/month TV tax), warm rent vs cold rent
- **Deposits**: 3 months rent typical (Kaution)
- **Eating out**: Very affordable compared to other capitals

### 7. Transit Excellence
Berlin has extensive public transit:
- **U-Bahn**: 10 lines, 175 stations, runs until ~1am (24h Fri/Sat)
- **S-Bahn**: Suburban rail, connects outer districts
- **Trams**: Mostly east Berlin
- **Buses**: Extensive night bus network (N-lines)
- **No barriers**: Honor system — but inspectors fine €60 for fare-dodging
See `transport.md` for complete guide.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young creatives | Kreuzberg, Neukölln, Friedrichshain |
| Families | Prenzlauer Berg, Charlottenburg, Zehlendorf |
| Budget-conscious | Wedding, Lichtenberg, Marzahn |
| Tech workers | Mitte, Prenzlauer Berg, Kreuzberg |
| Nightlife lovers | Friedrichshain, Kreuzberg, Neukölln |
| Quiet professionals | Wilmersdorf, Schöneberg, Steglitz |

## Food Culture Context

Berlin is Germany's most diverse food city:
- **Street food**: Döner capital of Europe, currywurst origin
- **Markets**: Markthalle Neun (Thursday Street Food), Turkish Market
- **Must-try**: Döner, currywurst, Buletten, Eisbein, Berliner (donut)
- **Michelin**: 2 three-star, 5 two-star, 20+ one-star restaurants
- **Bars**: Späti culture (24h corner shops), craft beer scene
- **Brunch**: Weekend institution, reserve ahead for popular spots

See `food-overview.md` for complete guide.

## Berlin-Specific Realities

- **Anmeldung** — Must register address within 14 days. Needed for EVERYTHING.
- **Schufa** — Credit score system. No Schufa = hard to rent.
- **Housing crisis** — Finding apartments is brutal. Budget 2-3 months search.
- **Cash culture** — Many places still cash-only. Always carry euros.
- **Sunday closures** — Shops closed Sundays. Spätis and some bakeries open.
- **Bureaucracy** — Ausländerbehörde appointments book months ahead.
- **Recycling** — Pfand system for bottles. Yellow/blue/brown/black bins.
- **Noise rules** — Quiet hours 10pm-6am and Sundays. Neighbors will complain.
- **Dog city** — Dogs everywhere, allowed in restaurants/trains.
- **Techno capital** — Berghain, Tresor, clubs are cultural institutions.
- **Bike theft** — Very high. Use two locks, register your bike.

## Legal Awareness

Key laws every visitor/resident must know:
- **Drugs**: Cannabis legal for adults (2024), other drugs illegal but Berlin is tolerant
- **Jaywalking**: Technically illegal (€5-10 fine), rarely enforced
- **Photography**: GDPR strict — can't photograph people without consent
- **Employment**: Must have work permit BEFORE starting work
- **Insurance**: Health insurance mandatory for all residents
- **Tax**: Must file annual tax return (Steuererklärung)
- **Rental**: Strong tenant protections, but Mietpreisbremse complex

See `safety.md` for comprehensive legal guidance.
