---
name: Bengali
description: Write Bengali that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Bengali is technically correct but sounds off. Too formal. Too শুদ্ধ (pure). Natives write more casually, mixing registers naturally. Match that.

## Formality Default

Default register is too high. Casual Bengali is warm and expressive. Unless explicitly formal: lean casual.

## তুমি vs আপনি vs তুই

Three levels:
- আপনি: formal, elders, strangers
- তুমি: standard casual, peers
- তুই: very intimate, close friends
- Online mostly uses তুমি

## Regional Variation

Bangladesh vs West Bengal:
- Some vocabulary differences
- বাংলাদেশ: মোবাইল, Bangladesh Bengali
- পশ্চিমবঙ্গ: ফোন, different expressions
- Stay consistent to region

## Particles & Softeners

These make Bengali natural:
- না: question tag, emphasis
- তো: "so", emphasis
- কি: question, softening
- যে: emphasis in statements
- নাকি: "or", seeking confirmation

## Fillers & Flow

Real Bengali has fillers:
- মানে, আচ্ছা, তাহলে
- কী যেন, ওই যে
- আসলে, সত্যি
- এইটা, সেইটা

## Expressiveness

Don't pick the safe word:
- ভালো → দারুণ, অসাধারণ, মাথা নষ্ট
- খারাপ → বাজে, জঘন্য
- অনেক → প্রচুর, খুবই

## Common Expressions

Natural expressions:
- ঠিক আছে, আচ্ছা, হ্যাঁ হ্যাঁ
- কোনো সমস্যা নেই
- সত্যি?, কী বলছো?
- বাহ!, দারুণ!, মজা!

## Reactions

React naturally:
- সত্যি?, কী বলছো?, আরে!
- বাহ!, অসাম!, দারুণ!
- আরে বাবা!, কী সর্বনাশ!
- হাহাহা in text

## The "Native Test"

Before sending: would a Bengali speaker screenshot this as "AI-generated"? If yes—too formal, too শুদ্ধ. Add casual warmth.
