# Beijing Visitor Tips & Day Trips (2025-2026)

## Essential Pre-Arrival Checklist

### Before You Leave Home

| Priority | Task | Why |
|----------|------|-----|
| 🔴 CRITICAL | Download VPN | Cannot download inside China |
| 🔴 CRITICAL | Download WeChat + verify phone | Everything runs on WeChat |
| 🔴 CRITICAL | Get Alipay (Tour Pass for foreigners) | Mobile payment is essential |
| 🟡 Important | Download Baidu Maps or Amap | Google Maps doesn't work |
| 🟡 Important | Book Forbidden City | Sells out 10 days ahead |
| 🟡 Important | Download offline translator | Google Translate works offline |
| 🟢 Helpful | Get Didi app | Chinese Uber |
| 🟢 Helpful | Book Great Wall transport | Tours or DiDi in advance |

### Essential Apps

| App | Purpose | English? |
|-----|---------|----------|
| **VPN (ExpressVPN, Astrill)** | Access Google, Instagram, etc. | Yes |
| **WeChat (微信)** | Everything — chat, pay, book tickets | Yes |
| **Alipay (支付宝)** | Backup payment | Yes |
| **Didi (滴滴)** | Ride-hailing | Yes |
| **Baidu Maps / Amap** | Navigation | Amap has English |
| **Pleco** | Chinese dictionary | Yes |
| **Google Translate** | Camera translation, offline | Yes |
| **Meituan (美团)** | Food delivery, tickets | Limited |
| **Ctrip/Trip.com** | Train/flight/hotel | Yes |

**VPN CRITICAL:** Install and TEST before arriving. Cannot download inside China. Recommended: ExpressVPN, Astrill, NordVPN (some work better than others - changes frequently).

---

## Money & Payments

### Cash vs Mobile

| Method | Acceptance | Notes |
|--------|------------|-------|
| **WeChat Pay** | 99% | Most common |
| **Alipay** | 99% | Equally common |
| **Cash** | 60% | Declining, some places refuse |
| **Credit Card** | 30% | Only big hotels/malls |

### Setting Up Mobile Payment (Foreigners)

**WeChat Pay:**
1. Download WeChat
2. Verify with non-Chinese phone number
3. Link international credit card (Visa/Mastercard work since 2023)
4. May need to verify passport in-app

**Alipay Tour Pass:**
1. Download Alipay
2. Use "Tour Pass" feature
3. Load money from international card
4. Works for 90 days, up to ¥10,000

**Pro Tips:**
- Link BOTH apps — some vendors only take one
- Carry ¥500-1,000 cash as backup
- Small vendors, street food often require mobile payment
- ATMs: Bank of China has best foreign card acceptance

### Budget Reference

| Expense | Low | Mid | High |
|---------|-----|-----|------|
| Hostel | ¥80 | ¥150 | ¥300 |
| Hotel | ¥300 | ¥700 | ¥2,000+ |
| Meal (local) | ¥25 | ¥50 | ¥100 |
| Meal (nice) | ¥100 | ¥200 | ¥500+ |
| Subway | ¥3 | ¥5 | ¥10 |
| DiDi ride | ¥20 | ¥50 | ¥100 |
| Attraction | ¥0 | ¥40 | ¥150 |

---

## Communication

### Language Survival

**Reality check:** English is NOT widely spoken in Beijing. Even in tourist areas, expect communication challenges.

**Essential Phrases (with pinyin):**

| English | Chinese | Pinyin |
|---------|---------|--------|
| Hello | 你好 | nǐ hǎo |
| Thank you | 谢谢 | xiè xie |
| How much? | 多少钱？ | duō shao qián? |
| Too expensive | 太贵了 | tài guì le |
| I don't understand | 我不懂 | wǒ bù dǒng |
| Where is...? | ...在哪里？ | ...zài nǎ lǐ? |
| Toilet | 厕所/洗手间 | cè suǒ / xǐ shǒu jiān |
| I want this | 我要这个 | wǒ yào zhè ge |
| Check please | 买单/结账 | mǎi dān / jié zhàng |
| No spicy | 不要辣 | bú yào là |

**Communication Strategies:**
1. **Screenshots:** Save address in Chinese characters
2. **Translation apps:** Point camera at menus/signs
3. **Show pictures:** Of food, attractions, etc.
4. **Hotel card:** Keep hotel business card with Chinese address

### SIM Cards

| Option | Cost (¥) | Data | Notes |
|--------|----------|------|-------|
| China Mobile | 50-100 | 5-10GB/month | Best coverage |
| China Unicom | 50-100 | 5-10GB/month | Better for foreigners |
| Airport SIM | 100-200 | 1-2GB | Convenient but expensive |
| eSIM (Airalo) | $15-30 | 1-3GB | Pre-arrival option |

**Buy at:** Airport arrival hall, or China Unicom store (bring passport)

---

## Health & Safety

### Medical Kit

| Item | Why |
|------|-----|
| N95/KN95 masks | Air pollution (AQI 150+) |
| Hand sanitizer | Public hygiene |
| Basic medicines | Pharmacies require Chinese |
| Prescription copies | For customs if needed |
| Travel insurance docs | Hospital may need upfront payment |

### Air Quality (AQI)

| AQI | Level | Action |
|-----|-------|--------|
| 0-50 | Good | Enjoy outdoor activities |
| 51-100 | Moderate | Sensitive people be aware |
| 101-150 | Unhealthy (sensitive) | Limit prolonged outdoor |
| 151-200 | Unhealthy | Mask recommended, limit outside |
| 201-300 | Very unhealthy | Stay indoors, N95 required outside |
| 300+ | Hazardous | Avoid going out |

**Apps to check:** WeChat AQI mini-programs, aqicn.org, Air Matters app

**Best AQI:** Autumn (Sep-Nov), after rain
**Worst AQI:** Winter heating season (Nov-Feb)

### Emergency Numbers

| Service | Number | Notes |
|---------|--------|-------|
| Police | 110 | Limited English |
| Ambulance | 120 | Limited English |
| Fire | 119 | — |
| Tourist Hotline | 12301 | English available |

---

## Cultural Etiquette

### Do's ✅

- **Accept things with both hands** — Business cards, gifts, money
- **Toast lower** — When clinking glasses, keep yours lower than elders/seniors
- **Try everything offered** — Refusing food is impolite
- **Carry tissues** — Public toilets often don't have paper
- **Learn basic Chinese** — Even "hello" and "thank you" appreciated
- **Be patient with crowds** — Personal space concept is different
- **Respect photography rules** — Many temples ban photos inside

### Don'ts ❌

- **Don't tip** — Not expected, can be awkward
- **Don't discuss politics** — Taiwan, Tibet, Tiananmen — avoid completely
- **Don't stick chopsticks upright** — Resembles funeral incense
- **Don't give clocks as gifts** — "Giving clock" sounds like "attending funeral"
- **Don't write names in red** — Associated with death
- **Don't expect queuing** — Pushing is normal (improving but still...)
- **Don't be surprised by staring** — Foreigners attract attention outside tourist areas

### Restaurant Culture

- **Sharing:** Dishes are communal, placed in center
- **Lazy Susan:** Spin to share dishes
- **Rice:** Often comes at the END (it's a filler)
- **Bones/shells:** Spit onto plate or table — normal
- **Fighting for the bill:** Host pays, guests fight to pay = respect
- **Tipping:** Not expected, not necessary

---

## Getting Around

### Subway Tips

- **Hours:** ~5:30 AM - 11:00 PM
- **Peak:** 7:30-9:00 AM, 5:30-7:00 PM — avoid if possible
- **Buy:** Yikatong card (¥20 deposit) or use WeChat/Alipay to scan
- **Security:** Every station has bag X-ray, add 5 minutes
- **English:** Announcements and signage in English
- **Connections:** Some interchanges are 10+ minute walks

### DiDi Tips

- **App language:** Can be set to English
- **Payment:** Link WeChat Pay or Alipay
- **Options:** Express (standard), Select (nicer car), Taxi (local taxi)
- **Surge:** During rain, rush hour — up to 1.5x
- **Driver English:** None — have destination in Chinese ready
- **Screenshots:** Save driver plate number before getting in

### Taxi Tips

- **Hailing:** Hard without DiDi, most drivers use app
- **Payment:** Mobile payment preferred, some refuse cash
- **Meter:** Always insist, start at ¥13
- **Receipt:** Can request "fapiao" receipt
- **Night:** After 11 PM, add ¥2-3 surcharge

---

## Day Trips from Beijing

### Great Wall Options (Detailed)

| Section | Distance | Crowds | Transport | Experience |
|---------|----------|--------|-----------|------------|
| **Mutianyu** | 70km | Medium | DiDi ¥300 RT / Bus 916 + shuttle | Best overall |
| **Badaling** | 60km | PACKED | Subway + shuttle | Avoid |
| **Jinshanling** | 130km | Low | Tour or private car | Hiking, photography |
| **Simatai** | 120km | Low | Tour or car | Night tours! |
| **Huanghuacheng** | 80km | Low | DiDi | Lakeside, unique |

**Recommended:** Mutianyu for first-timers, Jinshanling for photographers/hikers

### Tianjin (30 min by train)

**What:** Coastal city, colonial architecture, food scene

| Attraction | Notes |
|------------|-------|
| Five Great Avenues | European colonial architecture |
| Ancient Culture Street | Temples, traditional shops |
| Tianjin Eye | Ferris wheel on bridge |
| Italian Style Town | Historic Italian concession |
| Goubuli Baozi | Famous stuffed buns |

**Getting There:**
- High-speed train: 30-35 min, ¥55-95
- Trains every 10-15 min from Beijing South Station

**Recommended:** Full day trip, or overnight for food exploration

### Chengde (3h by train)

**What:** Imperial summer resort, UNESCO site

| Attraction | Notes |
|------------|-------|
| Mountain Resort | Largest imperial garden in China |
| Eight Outer Temples | Tibetan Buddhist temples |
| Putuo Zongcheng Temple | Mini Potala Palace |

**Getting There:** D-train ~2h, regular train ~3.5h
**Best Season:** Summer (imperial escape from Beijing heat)

### Pingyao (4h by train)

**What:** Best-preserved ancient Chinese city, UNESCO

| Attraction | Notes |
|------------|-------|
| City Walls | Complete Ming-era walls, walkable |
| Ancient Streets | Traditional architecture |
| Banks | China's first banks were here |
| Courtyard Hotels | Stay in traditional compounds |

**Getting There:** High-speed to Pingyao Gucheng, 4h
**Recommended:** 1-2 nights minimum

### Shanhaiguan (3h by train)

**What:** Where Great Wall meets the sea

| Attraction | Notes |
|------------|-------|
| First Pass Under Heaven | Dramatic gate and walls |
| Old Dragon's Head | Wall meets ocean |
| Jiaoshan Great Wall | Less restored section |

**Getting There:** High-speed train ~3h to Shanhaiguan
**Combine with:** Beidaihe beach resort (30 min away)

---

## Shopping Guide

### What to Buy

| Item | Where | Price Range |
|------|-------|-------------|
| Tea | Maliandao Tea City | ¥50-500+/100g |
| Silk | Silk Market, Ruifuxiang | ¥200-2,000+ |
| Pearls | Pearl Market (Hongqiao) | ¥50-500+ |
| Antiques/Crafts | Panjiayuan Market | ¥50-5,000+ |
| Calligraphy supplies | Liulichang Street | ¥20-500+ |
| Peking Opera masks | Wangfujing, Nanluoguxiang | ¥30-300 |
| Electronics | Zhongguancun (tech) | Market rate |

### Bargaining

| Location | Bargain? | Strategy |
|----------|----------|----------|
| Markets (Silk, Pearl) | YES | Start at 20-30% of asking |
| Panjiayuan | YES | Walk away if too high |
| Street vendors | YES | Gentle negotiation |
| Malls | NO | Fixed prices |
| Supermarkets | NO | Fixed prices |
| Tea shops | MAYBE | Depends on relationship |

**Bargaining phrases:**
- 太贵了 (tài guì le) — Too expensive
- 便宜一点 (pián yi yī diǎn) — A little cheaper
- 最低多少？(zuì dī duō shao) — What's the lowest?

---

## Common Scams to Avoid

| Scam | How It Works | Prevention |
|------|--------------|------------|
| **Tea ceremony** | Stranger invites you, ¥500+ bill | Never go with strangers |
| **Art student** | "See my gallery," pressure sales | Decline politely |
| **Black taxi** | Unlicensed, overcharge | Use DiDi only |
| **Fake monks** | Request donation for blessing | Real monks don't solicit |
| **Bait and switch** | Different item than shown | Check before paying |
| **Restaurant switch** | Menu prices change | Photograph menu first |

**General rule:** If a stranger approaches YOU with an offer, it's likely a scam.

---

## Packing Essentials

### Must Have
- [ ] Passport (keep copy separate)
- [ ] VPN app (downloaded and tested)
- [ ] WeChat/Alipay set up
- [ ] N95 masks (for pollution)
- [ ] Power adapter (Type A/C/I - Type A most common)
- [ ] Portable charger (phone dies = no payment)
- [ ] Tissues (public toilets!)
- [ ] Hand sanitizer
- [ ] Hotel address in Chinese characters
- [ ] Offline translator app

### By Season

**Winter (Nov-Feb):**
- Heavy coat
- Layers (indoor heating is strong)
- Hand warmers
- Lip balm (very dry)

**Summer (Jun-Aug):**
- Light breathable clothes
- Umbrella (sudden rain)
- Sunscreen
- Cooling towel

**Spring/Autumn:**
- Layers (temperatures vary)
- Light jacket
- Sunglasses

---

## Final Tips from Expats

1. **VPN is non-negotiable** — Install before arrival
2. **Learn to love WeChat** — Resistance is futile
3. **Carry your passport** — Random police checks happen
4. **Don't drink tap water** — Bottled only
5. **Squat toilets are common** — Tissues and hand sanitizer essential
6. **Prepare for crowds** — Personal space doesn't exist
7. **Be flexible** — Things work differently here, adapt
8. **Smile and point** — When language fails
9. **Take photos of addresses** — Show to taxi/DiDi drivers
10. **Enjoy the chaos** — Beijing is intense but incredible

---

*Last updated: February 2026*
