# Beijing Visitor Itineraries (2025-2026)

## Overview

Beijing is massive (16,400 km²) with spread-out attractions. Plan strategically by area to minimize transit time.

**Key Principles:**
- Book Forbidden City 10 days ahead (mandatory)
- Cluster attractions by district
- Start early (8am) to beat crowds
- Great Wall needs a full day
- Allow buffer for security checks

---

## 1-Day Itinerary: "Essential Beijing"

**Best for:** Layover or extremely limited time

### Schedule

| Time | Activity | Area | Notes |
|------|----------|------|-------|
| 6:00 | Wake up | — | Early start essential |
| 7:00-7:30 | Local breakfast | Near hotel | Jianbing + soy milk |
| 8:00-8:30 | Tiananmen Square | Dongcheng | Security takes 20-30 min |
| 8:30-12:30 | Forbidden City | Dongcheng | 4 hours minimum, enter south exit north |
| 12:30-13:00 | Jingshan Park | Dongcheng | ¥2, climb for Forbidden City panorama |
| 13:00-14:00 | Lunch | Nanluoguxiang | Walk from Jingshan, hutong dining |
| 14:00-15:30 | Hutong walking | Nanluoguxiang | Explore alleys, shops, cafes |
| 16:00-18:00 | Temple of Heaven | Dongcheng | Park activities, iconic architecture |
| 18:30-20:00 | Dinner | Qianmen or Wangfujing | Beijing duck recommended |
| 20:00+ | Evening walk | Houhai or Sanlitun | Nightlife, bars if desired |

**Total Cost:** ~¥150-250 (excluding meals)
- Forbidden City: ¥60
- Jingshan: ¥2
- Temple of Heaven: ¥35
- Transport: ¥30-50

---

## 3-Day Itinerary: "Classic Beijing"

### Day 1: Imperial Beijing

| Time | Activity | Details |
|------|----------|---------|
| 7:30 | Breakfast | Hotel or local jianbing stall |
| 8:30-12:30 | Forbidden City | Enter Meridian Gate, exit north |
| 12:30-13:30 | Jingshan Park + Lunch | Climb hill, eat at nearby hutong |
| 14:00-16:00 | Beihai Park | Imperial garden, boating optional |
| 16:30-18:30 | Houhai Lake area | Walk around lake, old Beijing vibe |
| 19:00 | Dinner | Kao Rou Ji (grilled meat) or duck |

### Day 2: Great Wall Day

| Time | Activity | Details |
|------|----------|---------|
| 6:00 | Wake up | — |
| 7:00 | Depart hotel | DiDi or organized tour |
| 9:00-14:00 | Mutianyu Great Wall | Cable car up, walk/toboggan down |
| 15:30 | Return to Beijing | Traffic can be heavy |
| 17:00 | Rest at hotel | You'll be tired |
| 19:00 | Dinner | Hot pot or Gui Jie night food street |
| 21:00 | Optional | Sanlitun for nightlife |

### Day 3: Culture & Temples

| Time | Activity | Details |
|------|----------|---------|
| 6:00-8:00 | Temple of Heaven Park | Morning exercises with locals |
| 8:00-10:00 | Temple buildings | Echo Wall, Hall of Prayer |
| 10:30-12:00 | Lama Temple | Active Buddhist temple |
| 12:00-13:00 | Lunch | Wudaokou or Guijie area |
| 14:00-17:00 | 798 Art District | Contemporary art, galleries |
| 17:30-19:00 | Dinner | Modern Chinese at 798 or CBD |
| 19:30 | Optional | Acrobatics show or Peking Opera |

**3-Day Cost:** ~¥600-800 (excluding meals, accommodation)
- Attractions: ¥300-350
- Great Wall trip: ¥200-300 (transport + entry + cable)
- Local transport: ¥100-150

---

## 7-Day Itinerary: "Comprehensive Beijing"

### Day 1: Arrival & Orientation

| Time | Activity | Notes |
|------|----------|-------|
| Arrival | Airport transfer | Airport Express or DiDi |
| Afternoon | Hotel check-in | Rest if jetlagged |
| Evening | Sanlitun exploration | Get bearings, dinner, SIM card |
| Night | Early sleep | Adjust to timezone |

### Day 2: Imperial Center

| Time | Activity |
|------|----------|
| 8:00-12:30 | Forbidden City (full exploration) |
| 12:30-14:00 | Jingshan Park + lunch |
| 14:30-17:00 | Beihai Park |
| 17:30-19:30 | Qianmen Street walking |
| 20:00 | Peking Duck dinner (Dadong or Siji Minfu) |

### Day 3: Great Wall (Mutianyu)

| Time | Activity |
|------|----------|
| 7:00 | Depart Beijing |
| 9:30-15:00 | Great Wall exploration |
| 17:00 | Return to city |
| 19:00 | Casual dinner, rest |

### Day 4: Temples & Hutongs

| Time | Activity |
|------|----------|
| 6:30-9:00 | Temple of Heaven (morning activities) |
| 9:30-11:30 | Lama Temple |
| 12:00-14:00 | Lunch & Confucius Temple |
| 14:30-18:00 | Hutong bike tour (Nanluoguxiang/Drum Tower area) |
| 18:00 | Drum Tower sunset view |
| 19:00 | Hutong dinner |

### Day 5: Modern Beijing

| Time | Activity |
|------|----------|
| 10:00-14:00 | 798 Art District |
| 14:30-16:30 | Olympic Park (Bird's Nest exterior, Olympic Forest Park) |
| 17:00-19:00 | CBD exploration (CCTV Building, China World) |
| 20:00 | Fine dining in CBD or Sanlitun |

### Day 6: Day Trip - Summer Palace

| Time | Activity |
|------|----------|
| 8:30 | Depart for Summer Palace |
| 9:00-14:00 | Summer Palace (full exploration) |
| 14:30-16:30 | Old Summer Palace (Yuanmingyuan) ruins |
| 17:00-19:00 | Wudaokou area (university district, Korean food) |
| 20:00 | Houhai evening bars |

### Day 7: Flexible / Shopping / Departure

**Option A: More Sightseeing**
- National Museum of China (free, 3-4h)
- Capital Museum
- Prince Gong's Mansion

**Option B: Shopping**
- Silk Market (bargaining required)
- Sanlitun Taikoo Li
- SKP (luxury)

**Option C: Day Trip**
- Ming Tombs + Changling
- Fragrant Hills (autumn colors)
- Jinshanling Great Wall (quieter section)

---

## Themed Itineraries

### History Buff (4 Days)

| Day | Focus | Sites |
|-----|-------|-------|
| 1 | Imperial | Forbidden City, Jingshan, National Museum |
| 2 | Imperial II | Summer Palace, Old Summer Palace |
| 3 | Ming Dynasty | Ming Tombs, Great Wall |
| 4 | Religious | Temple of Heaven, Lama Temple, Confucius Temple, Bell/Drum Towers |

### Photography Focus (5 Days)

| Day | Focus | Best Times |
|-----|-------|------------|
| 1 | Forbidden City | Golden hour morning, 8:00 AM |
| 2 | Great Wall (Jinshanling) | Sunrise, golden hour |
| 3 | Hutongs + Houhai | Blue hour, night |
| 4 | 798 + CBD skyline | Afternoon + night |
| 5 | Temple of Heaven + parks | Sunrise with locals |

### Family with Kids (5 Days)

| Day | Activities |
|-----|------------|
| 1 | Forbidden City (keep moving), Jingshan climb |
| 2 | Great Wall Mutianyu (toboggan!) |
| 3 | Beijing Zoo + Pandas, Olympic Park |
| 4 | Science & Technology Museum, Shichahai boat |
| 5 | Happy Valley theme park OR Badaling Safari World |

### Art & Culture (4 Days)

| Day | Focus |
|-----|-------|
| 1 | 798 Art District (full day) |
| 2 | National Art Museum, Liulichang antique street |
| 3 | Hutong galleries, M Woods, Red Gate Gallery |
| 4 | Peking Opera, tea ceremony, calligraphy class |

---

## Seasonal Adjustments

### Summer (June-August)
- Start EARLY (6-7 AM) to avoid heat
- Great Wall by 9 AM, leave by 1 PM
- Schedule indoor activities (museums) for midday
- Evening activities: Houhai, rooftop bars

### Winter (December-February)
- Forbidden City in snow is magical (if lucky)
- Shorter days — plan for 5 PM darkness
- Indoor activities: National Museum, shopping, hot pot
- Hot springs day trip option

### Autumn (September-November)
- Best season — do everything
- Fragrant Hills for fall colors
- Great Wall photography optimal
- Book everything further ahead (peak season)

### Spring (March-May)
- April sandstorms possible — check forecast
- Cherry blossoms at Yuyuantan Park (late March-April)
- Summer Palace beautiful
- Book Forbidden City 10+ days ahead

---

## Logistics Tips

### Transport Between Sites

| Route | Best Option | Time | Cost |
|-------|-------------|------|------|
| Hotel → Forbidden City | Subway + walk | Varies | ¥5-10 |
| Forbidden City → Temple of Heaven | Subway Line 2 → Line 5 | 30 min | ¥4 |
| City → Mutianyu | DiDi or tour bus | 1.5-2h | ¥200-400 DiDi |
| City → 798 | Subway Line 14 | 45 min | ¥5-8 |
| Temple of Heaven → Lama Temple | Subway Line 5 | 30 min | ¥4 |

### Daily Budget Estimates

| Style | Per Day (¥) | USD |
|-------|-------------|-----|
| Budget | 300-500 | $42-70 |
| Mid-range | 600-1,000 | $84-140 |
| Comfortable | 1,000-2,000 | $140-280 |
| Luxury | 2,000+ | $280+ |

Excludes accommodation.

---

## Avoid These Days

| Period | Why | Impact |
|--------|-----|--------|
| **Oct 1-7 (Golden Week)** | National Day holiday | 10x crowds, 2x prices |
| **Chinese New Year (Jan/Feb)** | Lunar New Year | Some things closed, huge crowds |
| **May 1-5 (Labor Day)** | Public holiday | Very crowded |
| **Tomb Sweeping (Apr)** | 3-day holiday | Busy but manageable |

---

*Last updated: February 2026*
