# Beijing Visitor Guide: Attractions (2025-2026)

## Must-See Attractions

### Truly Worth It ✅

| Attraction | Why It's Worth It | Price (¥) | Time Needed | Best Time |
|------------|-------------------|-----------|-------------|-----------|
| **The Great Wall (Mutianyu)** | Iconic, well-restored, cable car available, fewer crowds | 45 (entry) + 120 (cable car round trip) | Full day | Morning, avoid holidays |
| **Forbidden City (故宫)** | Largest palace complex in world, imperial history | 60 (Apr-Oct), 40 (Nov-Mar) | 4-6h | Book online 10 days ahead |
| **Temple of Heaven (天坛)** | Stunning architecture, park with locals doing tai chi | 15-35 | 3-4h | Early morning for local activities |
| **Summer Palace (颐和园)** | Beautiful gardens, lake, imperial retreat | 30 (Apr-Oct), 20 (Nov-Mar) | 4-5h | Spring or autumn |
| **798 Art District** | Contemporary art, galleries, cafes, photography heaven | FREE (galleries vary) | 3-5h | Afternoon/evening |
| **Jingshan Park** | Best panoramic view of Forbidden City | 2 | 1-2h | Sunset |
| **Hutongs (Nanluoguxiang area)** | Historic alleyways, authentic Beijing life | FREE | 2-4h | Morning or evening |
| **Lama Temple (雍和宫)** | Active Tibetan Buddhist temple, stunning | 25 | 1-2h | Morning |
| **National Museum of China** | World-class, comprehensive Chinese history | FREE (book online) | 3-4h | Avoid weekends |

### Worth It With Caveats ⚠️

| Attraction | Caveat | Recommendation |
|------------|--------|----------------|
| **Great Wall (Badaling)** | Extremely crowded, touristy | Go to **Mutianyu** or **Jinshanling** instead |
| **Tiananmen Square** | Security checks, early closing | Worth seeing once, but don't expect much |
| **Bird's Nest/Water Cube** | Exterior more impressive than interior | Just walk around Olympic Park, skip interior tickets |
| **Panjiayuan Antique Market** | 90% fake "antiques" | Fun for browsing/bargaining, don't expect real antiques |
| **Wangfujing Street** | Tourist trap shopping | Skip the "snack street" (scorpions are for tourists) |

---

## Tourist Traps to AVOID ❌

### 1. **Badaling Great Wall**
- **Problem**: 70% of all Great Wall visitors go here — packed shoulder-to-shoulder
- **Reality**: Cable car queues can be 2+ hours on holidays
- **Alternative**: Mutianyu (40% less crowded, cable car + toboggan), Jinshanling (wild section), Huanghuacheng (lakeside)

### 2. **"Tea Ceremony" Scams**
- **Problem**: Young women approach foreigners to "practice English," invite to "tea ceremony"
- **Reality**: Bill arrives: ¥500-2,000+ for tea. Classic Beijing scam.
- **Rule**: Never accept invitations from strangers approaching you on the street

### 3. **Wangfujing Snack Street**
- **Problem**: Scorpions, starfish, etc. are "for tourists" — no local eats this
- **Reality**: Prices 5-10x higher than real street food
- **Alternative**: Gui Jie (Ghost Street) for authentic late-night food

### 4. **Rickshaw Tours in Hutongs**
- **Problem**: Often ¥200-500 for 30-minute ride
- **Reality**: Worth ¥50-80 maximum
- **Alternative**: Walk, rent a bike, or book through reputable tour company

### 5. **Unlicensed Taxi Drivers at Airport/Train Stations**
- **Problem**: "Taxi? Taxi?" — unlicensed drivers charge 3-5x normal rates
- **Reality**: Can be unsafe, no recourse if problems
- **Alternative**: Use DiDi app or official taxi queue ONLY

### 6. **"Art Students" Near Tourist Sites**
- **Problem**: Claim to be art students, invite you to "gallery exhibition"
- **Reality**: Hard-sell for overpriced, low-quality artwork
- **Rule**: Politely decline and walk away

---

## Free/Cheap Experiences Worth Your Time

### Best Free Experiences

| Experience | Location | Notes |
|------------|----------|-------|
| **Olympic Forest Park** | North of Bird's Nest | Huge park, locals exercising, free entry |
| **Houhai Lake Walking** | Xicheng | Evening lights, bars, historic area |
| **Ritan Park Morning** | Chaoyang | Tai chi, sword dancing, traditional exercises |
| **CCTV Building (exterior)** | CBD | Iconic architecture, night photography |
| **Sanlitun People-Watching** | Chaoyang | Beijing's trendy scene |
| **Qianmen Street** | South of Tiananmen | Historic commercial street, free walking |
| **Ditan Park** | Dongcheng | Altar of Earth, peaceful |
| **Liulichang Cultural Street** | Xicheng | Calligraphy, art supplies, antiques atmosphere |

### Best Value Experiences

| Experience | Cost (¥) | Why It's Worth It |
|------------|----------|-------------------|
| **Jingshan Park** | 2 | Best Forbidden City views |
| **Beihai Park** | 10 | Imperial garden, white dagoba, boating |
| **Public bike rental** | 1-2/30min | Explore hutongs freely |
| **Local breakfast stall** | 10-20 | Jianbing (crepe), doujiang (soy milk), youtiao |
| **Temple of Heaven morning pass** | 15 | Park only, see locals exercising |

---

## Attraction Prices Reference (2025-2026)

| Attraction | Standard Price (¥) | Notes |
|------------|-------------------|-------|
| Forbidden City | 60 (summer) / 40 (winter) | Book 10 days ahead on WeChat |
| Great Wall - Mutianyu | 45 + 120 (cable) | Total ¥165 with round-trip cable |
| Great Wall - Badaling | 45 (summer) / 35 (winter) | Cable car extra ¥140 |
| Summer Palace | 30 / 20 | Combined ticket ¥60/50 |
| Temple of Heaven | 15 (park) / 35 (buildings) | Morning entry ¥15 for park activities |
| Lama Temple | 25 | |
| National Museum | FREE | Book online, passport required |
| Capital Museum | FREE | Book online |
| 798 Art District | FREE entry | Individual galleries may charge |
| Jingshan Park | 2 | Best value in Beijing |
| Beihai Park | 10 (winter) / 20 (summer) | Boating ¥60-100/hour |
| Ming Tombs | 45-65 | Changling most impressive |
| National Centre for Performing Arts | 30 (tour) | "Egg" building |
| Beijing Zoo + Panda House | 15 + 5 | Budget option for pandas |

**Currency note**: ¥1 CNY ≈ $0.14 USD ≈ €0.13 EUR

---

## Great Wall Section Comparison

| Section | Distance | Crowds | Difficulty | Best For |
|---------|----------|--------|------------|----------|
| **Mutianyu** | 70km (1.5h) | Medium | Easy-Medium | First-timers, families |
| **Badaling** | 60km (1h) | VERY HIGH | Easy | Disabled access, skip if possible |
| **Jinshanling** | 130km (2h) | Low | Medium-Hard | Hikers, photographers |
| **Simatai** | 120km (2h) | Low | Hard | Night tours (unique!) |
| **Huanghuacheng** | 80km (1.5h) | Low | Medium | Lakeside views, swimming nearby |
| **Jiankou** | 90km (2h) | Very Low | HARD | Wild wall enthusiasts (unrestored) |

**Recommendation:** 
- First visit → **Mutianyu** (best balance)
- Photography → **Jinshanling** (dramatic, fewer people)
- Unique experience → **Simatai Night** (only section open at night)

---

## Booking Tips

### Online Reservations (REQUIRED)

Many attractions require advance booking:

| Attraction | How to Book | When to Book |
|------------|-------------|--------------|
| Forbidden City | WeChat mini-program "故宫博物院" | 10 days ahead (sells out!) |
| National Museum | Website or WeChat | 1-7 days ahead |
| Great Wall (Mutianyu) | WeChat "慕田峪长城" | Day before usually OK |
| Summer Palace | WeChat mini-program | 1-3 days ahead |
| Temple of Heaven | WeChat or Meituan | Day before OK |

**CRITICAL:** Bring your passport — required for entry at ALL attractions.

### Best Apps for Booking

| App | Use For |
|-----|---------|
| **WeChat** | Most attraction bookings |
| **Meituan (美团)** | Discounted tickets, bundles |
| **Ctrip/Trip.com** | English interface, slight markup |
| **Klook** | English, easy cancellation |

---

## Pro Tips from Expats

1. **Book Forbidden City 10 days ahead** — It WILL sell out, especially weekends
2. **Go to Mutianyu, not Badaling** — Trust every guidebook on this
3. **Early morning Temple of Heaven** — See locals doing tai chi, fan dancing, choir singing
4. **Avoid Golden Week** — Oct 1-7 is nightmare level crowds everywhere
5. **798 on weekdays** — Weekends packed with Instagram crowds
6. **Jingshan sunset** — ¥2 for the best view in Beijing
7. **Download WeChat BEFORE arrival** — Many bookings require WeChat mini-programs
8. **Carry passport always** — Required for every major attraction

---

## Seasonal Considerations

| Season | Best Attractions | Avoid |
|--------|------------------|-------|
| **Spring (Mar-May)** | Summer Palace (flowers), parks | Great Wall (sandstorm risk) |
| **Summer (Jun-Aug)** | Evening activities, hutongs | Midday outdoor sites (35°C+) |
| **Autumn (Sep-Nov)** | Everything! Best season | Nothing — perfect time |
| **Winter (Dec-Feb)** | Forbidden City (snow photos), hot springs | Great Wall (icy, cold) |

---

*Last updated: February 2026. Prices are approximate and may vary by season.*
