# Beijing Visa Guide 2025-2026

> Complete guide to Chinese visa options: work, study, business, and residence permits.

## 📋 Visa Types Overview

| Visa Type | Letter | Purpose | Duration | Work Allowed |
|-----------|--------|---------|----------|--------------|
| **Tourist** | L | Tourism | 30-90 days | ❌ No |
| **Business** | M | Business activities | 30-180 days | ❌ No |
| **Work** | Z | Employment | 30 days (then permit) | ✅ Yes |
| **Student** | X1/X2 | Study | Varies | Limited |
| **Family** | S1/S2 | Family reunion | Varies | ❌ No |
| **Private** | Q1/Q2 | Visit Chinese relatives | Varies | ❌ No |
| **Journalist** | J | Media work | Varies | ✅ Yes (media only) |
| **Crew** | C | Transit crew | Short | ❌ No |
| **Transit** | G | Transit | 72-144h | ❌ No |

---

## 👔 Work Visa (Z Visa) & Work Permit

### Overview

Working legally in China requires:
1. **Z Visa** — Entry visa (valid 30 days)
2. **Work Permit** — Authorization to work
3. **Residence Permit** — Long-term stay

### Work Permit Categories (2025)

| Category | Who Qualifies | Benefits |
|----------|---------------|----------|
| **A (Top Talent)** | High-level talent, specialists | Streamlined process, 5-year permit |
| **B (Professional)** | Bachelor's + 2 years experience | Standard process, 1-2 year permit |
| **C (Temporary)** | Interns, seasonal | Limited, shorter permit |

### Category A Requirements

- **Option 1:** High-level talent (recognized awards, significant contributions)
- **Option 2:** Points system score 85+
- **Option 3:** Urgently needed talent list

### Category B Requirements

| Requirement | Details |
|-------------|---------|
| **Age** | Under 60 (extendable) |
| **Health** | Pass health examination |
| **Education** | Bachelor's or higher |
| **Experience** | 2+ years relevant work |
| **No criminal record** | Police certificate |
| **Employer** | Legitimate China employer |

### Points System

| Factor | Points |
|--------|--------|
| **Education** | PhD: 20, Master: 15, Bachelor: 10 |
| **Work experience** | Up to 15 points (2+ years in field) |
| **Annual salary** | Up to 20 points (higher = more) |
| **Mandarin HSK** | HSK 4+: 5 points |
| **Age** | Under 55: 15, 55-60: 10 |
| **Location** | Varies by city |
| **Field** | Bonus for priority industries |

**Scoring:** A category = 85+, B category = 60-84, C category = below 60

### Application Process

**Step 1: Work Permit Notification (Employer)**

| Task | Timeline |
|------|----------|
| Employer applies to SAFEA | 5-15 business days |
| Documents: Offer letter, employer license, your documents | — |
| Receive notification letter | — |

**Step 2: Z Visa (You)**

| Task | Timeline |
|------|----------|
| Apply at Chinese embassy/consulate | 4-10 business days |
| Documents: Passport, notification letter, photos | — |
| Z visa valid 30 days from issue | — |

**Step 3: Entry & Work Permit (In China)**

| Task | Timeline |
|------|----------|
| Enter China on Z visa | Within validity |
| Health examination | 1-3 days |
| Apply for work permit | 15-20 business days |
| Receive work permit card | — |

**Step 4: Residence Permit**

| Task | Timeline |
|------|----------|
| Apply at PSB Exit-Entry | 10-15 business days |
| Documents: Work permit, passport, photos, lease | — |
| Receive residence permit (1-5 years) | — |

**Total Timeline:** 6-12 weeks (from start to residence permit)

### Required Documents

**For Work Permit Notification:**
- Passport copy
- Photo (white background)
- Educational certificates (authenticated)
- Work experience proof (authenticated)
- Police clearance (authenticated)
- Health certificate
- Employment contract
- Employer business license

**Authentication:**
- Documents must be notarized and authenticated
- Process: Notary → State authentication → Chinese embassy authentication
- OR: Use Hague Apostille if applicable

### Costs

| Item | Cost | Notes |
|------|------|-------|
| **Authentication (home country)** | $200-500 | Varies by country |
| **Z visa** | $140-200 | Varies by nationality |
| **Health exam** | ¥600-800 | In China |
| **Work permit** | ¥0-1,000 | Employer usually pays |
| **Residence permit** | ¥400-800 | Based on duration |
| **Agent fees** | ¥5,000-15,000 | If using agent |

---

## 📚 Student Visa (X1/X2)

### Types

| Visa | Duration | Purpose |
|------|----------|---------|
| **X1** | Long-term (6+ months) | Degree programs, long study |
| **X2** | Short-term (<6 months) | Language course, short programs |

### Requirements

| Requirement | Details |
|-------------|---------|
| **Admission letter** | From accredited institution |
| **JW201/JW202 form** | Visa application form from school |
| **Financial proof** | Sufficient funds for study |
| **Health check** | May be required |
| **Valid passport** | 6+ months validity |

### X1 → Residence Permit

Students on X1 must convert to residence permit within 30 days of entry.

### Student Work Rules

| Activity | Allowed |
|----------|---------|
| **Full-time study** | ✅ Yes |
| **Internship (approved)** | ✅ With permission |
| **Part-time work** | ❌ Generally no |
| **Full-time work** | ❌ No |

---

## 💼 Business Visa (M)

### What You CAN Do

- Attend meetings
- Negotiate contracts
- Inspect facilities
- Attend trade fairs
- Market research

### What You CANNOT Do

- Work for Chinese company
- Receive Chinese salary
- Sign contracts as employee
- Provide services for pay

### Entry Options

| Type | Duration | Notes |
|------|----------|-------|
| **Single entry** | 30-90 days | One entry |
| **Double entry** | 30-90 days each | Two entries |
| **Multiple entry** | 6-12 months | Many entries, 30-90 days each stay |

### Requirements

| Document | Details |
|----------|---------|
| Invitation letter | From Chinese company |
| Business license copy | Of inviting company |
| Itinerary | Flight, hotel bookings |
| Company letter | From your employer |
| Passport | 6+ months validity |

---

## 👨‍👩‍👧 Family/Dependent Visa (S1/S2)

### For Family of Work Permit Holders

| Visa | Duration | Notes |
|------|----------|-------|
| **S1** | Long-term (180+ days) | Needs residence permit |
| **S2** | Short-term (<180 days) | Visit only |

### Requirements

| Document | Details |
|----------|---------|
| Sponsor's work permit | Copy |
| Sponsor's residence permit | Copy |
| Relationship proof | Marriage cert, birth cert |
| Invitation letter | From sponsor |
| Accommodation proof | Lease or hotel |

### S1 → Residence Permit

Family members on S1 must apply for residence permit within 30 days.

### Work Rights

| Status | Can Work? |
|--------|-----------|
| **S1 residence permit** | ❌ No (must get own work permit) |
| **S2** | ❌ No |

---

## 🏠 Residence Permit

### Types by Purpose

| Purpose | Base Visa | Duration |
|---------|-----------|----------|
| **Work** | Z | 1-5 years |
| **Study** | X1 | Up to study duration |
| **Family** | S1 | Up to sponsor's permit |
| **Journalist** | J1 | 1 year |

### Renewal

| Timeline | Action |
|----------|--------|
| **30 days before expiry** | Start renewal process |
| **Documents** | Similar to initial application |
| **Processing** | 10-15 business days |

### Address Changes

Must update residence permit within 10 days of moving.

---

## 🌟 Permanent Residence (Green Card)

### Who Qualifies

| Category | Requirements |
|----------|--------------|
| **Work-based** | 4+ years continuous work, 3+ years tax payment above threshold |
| **Investment** | Stable investment of $500,000+ for 3 years |
| **Family-based** | Marriage to Chinese citizen for 5+ years |
| **High-level talent** | Recognized contributions to China |

### Benefits

- No work permit needed
- Open bank accounts easily
- Buy property freely
- Re-enter without visa

### Reality

- Very difficult to obtain
- Few approved annually
- Long processing time
- Extensive documentation

---

## ⏱️ Visa Processing Times

| Visa Type | Normal | Express |
|-----------|--------|---------|
| Tourist (L) | 4 business days | 2-3 days |
| Business (M) | 4 business days | 2-3 days |
| Work (Z) | 4-5 business days | 2-3 days |
| Student (X) | 4-5 business days | 2-3 days |

**Note:** Times vary by consulate and nationality

---

## 🚨 Important Rules

### Registration

- Register with police within 24 hours
- Hotels do this automatically
- Private residence = you must go to PSB

### No Overstay

| Overstay | Consequence |
|----------|-------------|
| 1-10 days | ¥500/day fine |
| 10+ days | Fine + detention possible |
| Significant | 5-year entry ban |

### No Illegal Work

| Violation | Consequence |
|-----------|-------------|
| Working without permit | ¥5,000-20,000 fine |
| Repeat offense | Detention + deportation |
| Severe cases | 5-10 year ban |

### Visa-Free Transit

| Hours | Eligibility | Notes |
|-------|-------------|-------|
| **144-hour** | 54 countries | Must transit to third country |
| **24-hour** | Most countries | Stay in airport area |

---

## 📊 Decision Guide

| Situation | Visa Type |
|-----------|-----------|
| Job offer in Beijing | Z visa → Work permit |
| Short business trip | M visa |
| Tourism only | L visa |
| University degree | X1 visa |
| Language study (<6 months) | X2 visa |
| Spouse has work permit | S1 visa |
| Visit Chinese family | Q1/Q2 visa |
| Transit through Beijing | G visa or visa-free |

---

## 💡 Tips

1. **Start early** — Process takes 2-3 months minimum
2. **Use agent** — First-time applicants benefit from help
3. **Authenticate documents** — Don't underestimate this step
4. **Keep copies** — Of everything, everywhere
5. **Know your category** — A/B/C affects your process
6. **Health check in China** — Even if done abroad, China may require again
7. **Employer matters** — Good employer makes process smooth
8. **Don't overstay** — Even 1 day creates problems

---

*Last updated: February 2026*
