# Beijing Transportation Guide 2025-2026

> Last updated: February 2026 | Currency: ¥1 CNY ≈ $0.14 USD

## Overview

Beijing has world-class public transportation. The subway system is the largest globally by length, and costs are incredibly low. The city is designed for metro + DiDi combination. Most expats don't need cars.

---

## 🚇 Beijing Subway (地铁)

### Network Overview

| Stat | Data |
|------|------|
| **Lines** | 27 operating lines |
| **Stations** | 470+ stations |
| **Length** | 800+ km (world's longest) |
| **Daily riders** | 10+ million |
| **Hours** | ~5:00 AM – 11:00 PM |

### Key Lines for Expats

| Line | Color | Key Stops | Notes |
|------|-------|-----------|-------|
| **Line 1** | Red | Tiananmen, Wangfujing, Guomao, Sihui | Main east-west, always crowded |
| **Line 2** | Blue loop | Dongzhimen, Jianguomen, Fuxingmen | Ring around city center |
| **Line 10** | Light blue loop | Sanlitun, CBD, Zhongguancun, Olympic Park | Expat favorite, long loop |
| **Line 4** | Teal | Zoo, Summer Palace, PKU, Zhongguancun | University line |
| **Line 5** | Purple | Temple of Heaven, Lama Temple, Tiantongyuan | North-south central |
| **Line 6** | Gold | Chaoyang, Tongzhou | East-west express |
| **Line 13** | Yellow | Wudaokou, Huilongguan | Tech area, very crowded |
| **Line 14** | Pink | CBD, Chaoyang Park, 798 | Newer, convenient |
| **Line 15** | Purple | Shunyi, Wangjing | To expat suburbs |
| **Airport Express** | Gray | Dongzhimen → T2 → T3 | Direct to airport |

### Fare System

**Distance-based pricing:**

| Distance | Fare (¥) |
|----------|----------|
| 0-6 km | 3 |
| 6-12 km | 4 |
| 12-22 km | 5 |
| 22-32 km | 6 |
| 32+ km | +1 per 20 km |

**Examples:**
- Sanlitun → Guomao: ¥3
- Sanlitun → Wudaokou: ¥5
- CBD → Capital Airport: ¥25 (Airport Express)

### Payment Methods

| Method | How | Notes |
|--------|-----|-------|
| **Yikatong Card** | Tap card | ¥20 deposit, reloadable |
| **WeChat/Alipay** | QR code scan | Most convenient |
| **Apple Pay** | NFC | Supported on newer gates |
| **Single ticket** | Machine | Cash or mobile payment |

### Getting a Yikatong

1. **Purchase:** Any subway station, ¥20 deposit + credit
2. **Top up:** Stations, convenience stores, WeChat
3. **Refund:** Return card for deposit at service center
4. **Tip:** WeChat/Alipay transit codes work just as well

### Subway Tips

- ✅ **Peak hours:** 7:30-9:00 AM, 5:30-7:30 PM (avoid if possible)
- ✅ **AC stations:** All stations air-conditioned
- ✅ **English announcements:** All lines
- ✅ **Signage:** Chinese and English
- ❌ **Security:** Bag X-ray at EVERY station (add 3-5 minutes)
- ❌ **Crowding:** Lines 1, 13, 10 extremely crowded rush hour
- 📱 **Apps:** Beijing Subway app, Baidu Maps, Amap

### Women's Safety

- Dedicated women-only waiting areas on some platforms
- Report harassment to staff or police
- Generally safe, but stay aware during rush hour crowding

---

## 🚗 DiDi (滴滴) — Ride-Hailing

### Overview

DiDi is China's Uber (actually bought Uber China). Essential for Beijing life.

### Service Types

| Type | Chinese | Use | Price |
|------|---------|-----|-------|
| **Express (快车)** | kuài chē | Standard, most common | Base rate |
| **Premier (专车)** | zhuān chē | Nicer cars | +30-50% |
| **Luxury (豪华车)** | háo huá chē | Mercedes, BMW | +100-200% |
| **Taxi (出租车)** | chū zū chē | Hail official taxi | Metered |
| **Carpool (拼车)** | pīn chē | Shared ride | -30-40% |

### Typical Prices

| Route | Express (¥) | Time |
|-------|-------------|------|
| Sanlitun → CBD | 25-40 | 15-25 min |
| Sanlitun → Airport | 100-150 | 40-60 min |
| CBD → Wudaokou | 50-80 | 30-45 min |
| Short trip (3km) | 15-25 | 10-15 min |
| Shunyi → CBD | 80-150 | 60-90 min |

### Setting Up DiDi

1. Download DiDi app (English version available)
2. Register with phone number
3. Link WeChat Pay or Alipay
4. Set language to English in settings
5. Save common addresses (home, office)

### DiDi Tips

- 📍 **Pin location:** Double-check pickup point on map
- 📞 **Driver calls:** Have destination in Chinese ready
- 🚗 **Plate number:** Verify plate before getting in
- ⏰ **Peak times:** +1.5-2x surge pricing
- 🌧️ **Rain:** Extremely hard to get cars, prices spike
- 💬 **Translation:** App has built-in translation feature
- ⭐ **Rating:** Drivers rate passengers too

### Surge Pricing Times

| Time | Surge |
|------|-------|
| Weekday 8-9 AM | 1.2-1.5x |
| Weekday 5-7 PM | 1.3-1.8x |
| Friday night 10 PM+ | 1.5-2.0x |
| Rain (any time) | 2.0-3.0x |
| Holiday periods | 1.5-2.5x |

---

## 🚕 Taxis (出租车)

### Overview

Traditional taxis still exist but increasingly hard to hail. Most drivers use DiDi.

### Metered Rates

| Component | Rate |
|-----------|------|
| **Flag fall** | ¥13 (first 3 km) |
| **Per km** | ¥2.3 |
| **Night surcharge (11 PM-5 AM)** | +20% |
| **Fuel surcharge** | ¥1-3 |

### Hailing a Taxi

- **Street hail:** Possible but harder than before
- **Taxi stands:** At malls, hotels, hospitals
- **DiDi taxi:** Easier to get via app
- **Airport queue:** Official taxi line at arrivals

### Taxi Tips

- ✅ Always use meter — refuse "flat rate" offers
- ✅ Get receipt (发票 fāpiào) if needed for expense
- ❌ Don't expect English — have destination in Chinese
- ❌ Avoid "black" taxis (unlicensed) at train/airport

---

## 🚌 Buses

### Overview

Extensive but complex network. Mostly used by locals. Not recommended for newcomers due to language barrier and complexity.

### Basics

- **Fare:** ¥2 (flat rate most routes)
- **Payment:** Yikatong or cash
- **Hours:** ~5:30 AM – 10:00 PM
- **Frequency:** 5-20 min depending on route

### When Useful

- Metro doesn't reach your destination
- Scenic routes (through hutongs)
- Very cheap long-distance within city

### Not Recommended Because

- No English announcements (most routes)
- Complex route system
- Slow in traffic
- Hard to know when to get off

---

## 🚴 Bike Sharing

### Available Services

| Service | Color | Notes |
|---------|-------|-------|
| **Meituan** | Yellow | Most common |
| **Hello Bike** | Blue | Good coverage |
| **Didi Bike** | Green | DiDi's bikes |

### How It Works

1. Download app (WeChat/Alipay also work)
2. Scan QR code on bike
3. Ride
4. Lock bike at destination (designated areas)
5. Payment automatically deducted

### Pricing

| Service | Rate |
|---------|------|
| **Per ride** | ¥1.5 per 30 min |
| **Monthly pass** | ¥10-25 |
| **Deposit** | Usually ¥0 via Zhima Credit |

### Bike Tips

- 🚲 **Check bike first:** Brakes, tires, seat
- 📍 **Parking zones:** Must park in designated areas or fined
- 🚦 **Rules:** Bikes allowed on most roads, use bike lanes
- ❄️ **Winter:** Riding in -10°C is brutal
- 😷 **Pollution:** N95 mask recommended on high AQI days

---

## ✈️ Airport Transport

### Beijing Capital Airport (PEK)

| Option | Time | Cost (¥) | Notes |
|--------|------|----------|-------|
| **Airport Express** | 25 min to Dongzhimen | 25 | Best option, no traffic |
| **DiDi/Taxi** | 40-90 min (traffic) | 100-180 | Door-to-door |
| **Airport Bus** | 60-90 min | 25-30 | Multiple routes |

**Airport Express route:**
Terminal 3 → Terminal 2 → Sanyuanqiao → Dongzhimen

**Hours:** 6:00 AM – 11:00 PM

### Beijing Daxing Airport (PKX)

| Option | Time | Cost (¥) | Notes |
|--------|------|----------|-------|
| **Daxing Airport Express** | 19 min to Caoqiao | 35 | New line |
| **DiDi/Taxi** | 45-90 min | 150-250 | Far south of city |
| **High-speed train** | 35 min to Beijing West | 35 | Limited service |

### Which Airport?

| Airline | Typical Airport |
|---------|-----------------|
| Air China | PEK |
| China Eastern | Both |
| China Southern | PKX (main hub) |
| International carriers | Mostly PEK |
| Budget carriers | PKX |

---

## 🚄 High-Speed Rail

### Beijing Stations

| Station | Location | Lines | Notes |
|---------|----------|-------|-------|
| **Beijing South (北京南)** | South city | Shanghai, Tianjin | Major |
| **Beijing West (北京西)** | West city | Xi'an, Shenzhen | Major |
| **Beijing (北京站)** | East city | Older routes | Central |
| **Beijing North (北京北)** | Xicheng | Badaling, Zhangjiakou | Great Wall train |

### Sample Journey Times

| Route | Time | Price (¥) |
|-------|------|----------|
| Beijing → Shanghai | 4.5h | 550-1,750 |
| Beijing → Tianjin | 30 min | 55-95 |
| Beijing → Xi'an | 4.5h | 525-1,600 |
| Beijing → Great Wall (Badaling) | 25 min | 35 |

### Booking

- **12306.cn:** Official site (Chinese)
- **Trip.com/Ctrip:** English interface, slight markup
- **ID required:** Passport for foreigners

---

## 📊 Cost Comparison

### Monthly Transport Costs

| Profile | Mode | Cost (¥/month) |
|---------|------|----------------|
| Metro commuter | Subway only | 150-300 |
| Subway + occasional DiDi | Mixed | 300-600 |
| Heavy DiDi user | Mostly DiDi | 1,000-2,500 |
| Car owner | Own vehicle | 2,000-5,000+ |
| Shunyi with driver | Driver service | 8,000-12,000 |

### Beijing vs Other Cities

| Item | Beijing (¥) | Shanghai | London | NYC |
|------|-------------|----------|--------|-----|
| Subway ticket | 3-10 | 3-10 | ¥40+ | ¥25+ |
| Monthly pass | ~500* | ~500* | ¥1,200+ | ¥950 |
| Taxi per km | 2.3 | 2.5 | ¥15+ | ¥20+ |
| DiDi 5km | 20-35 | 20-35 | N/A | N/A |

*Beijing/Shanghai have no unlimited monthly passes — this is estimated spending

---

## 🚗 Driving (See also driving.md)

### Quick Summary

| Issue | Reality |
|-------|---------|
| **License plate** | Lottery system — years of waiting |
| **Traffic** | Horrific (worst in China) |
| **Parking** | Expensive, hard to find |
| **Recommendation** | Don't drive unless in Shunyi |

### Plate Restrictions

| Plate | Restriction |
|-------|-------------|
| **Beijing plates** | One day/week banned (rotating) |
| **Provincial plates** | Banned 7AM-8PM on 5th Ring+ |
| **Electric (green)** | No restrictions |

---

## Essential Apps

| App | Purpose | English |
|-----|---------|---------|
| **DiDi** | Ride-hailing | Yes |
| **Baidu Maps** | Navigation | Limited |
| **Amap (高德)** | Navigation | Yes |
| **Beijing Subway** | Metro routes | Yes |
| **Meituan** | Bike sharing | Limited |
| **12306** | Train tickets | No |
| **Ctrip/Trip.com** | Train/flight | Yes |

---

## Pro Tips

1. **Subway + DiDi:** Best combo for 90% of trips
2. **Rush hour:** Avoid 8-9 AM, 5:30-7:30 PM if possible
3. **Rain:** DiDi becomes impossible — use subway
4. **Airport Express:** Always faster than taxi during rush hour
5. **Save addresses in Chinese:** Screenshot or keep in notes
6. **Bike share for last mile:** Perfect metro → destination connection
7. **Yikatong for buses too:** If you take occasional buses

---

*Last updated: February 2026*
