# Beijing Startup Guide 2025-2026

> Launching and growing a startup in China's capital: funding, ecosystem, and practical considerations.

## Overview

Beijing is China's startup capital, home to the country's largest concentration of tech companies, VCs, and entrepreneurial talent. The ecosystem centers on Zhongguancun, with government support and deep talent pools from top universities.

---

## 🌟 Why Beijing for Startups

### Advantages

| Factor | Details |
|--------|---------|
| **Talent pool** | Tsinghua, Peking University, top engineers |
| **VC concentration** | Most major China VCs headquartered here |
| **Government support** | Zhongguancun policies, subsidies |
| **Tech giants** | ByteDance, Baidu spin-offs, alumni network |
| **Market access** | 22 million local population |
| **Political center** | Government relationships matter |

### Challenges

| Factor | Reality |
|--------|---------|
| **Competition** | Fierce for talent, funding, customers |
| **Costs** | Higher than other cities |
| **Bureaucracy** | Complex regulations |
| **Language** | Most business in Chinese |
| **Work culture** | 996 expectations common |

---

## 💰 Funding Landscape

### Stage Overview (2025)

| Stage | Typical Range (¥) | Typical Range (USD) |
|-------|-------------------|---------------------|
| Angel/Pre-seed | 500K-5M | $70K-700K |
| Seed | 5M-20M | $700K-2.8M |
| Series A | 20M-100M | $2.8M-14M |
| Series B | 50M-300M | $7M-42M |
| Series C+ | 200M+ | $28M+ |

### Top Beijing VCs

| Firm | Stage Focus | Notable Investments |
|------|-------------|---------------------|
| **Sequoia China** | All stages | ByteDance, Meituan, JD |
| **Hillhouse** | Growth | Tencent, JD |
| **Source Code** | Early | ByteDance, Bilibili |
| **ZhenFund** | Seed | Many unicorns |
| **Matrix Partners** | Early/Growth | Broad portfolio |
| **Sinovation** | AI-focused | AI startups |
| **IDG Capital** | Multi-stage | Baidu, Tencent |
| **Gaorong Capital** | Growth | ByteDance, Meituan |
| **GGV Capital** | Cross-border | Global expansion |
| **Northern Light** | Early | Tech focus |

### Government Funding

| Program | Type | Amount |
|---------|------|--------|
| **Zhongguancun Fund** | Matching | Up to ¥10M match |
| **Beijing Innovation Fund** | Grant | ¥500K-2M |
| **High-tech Enterprise** | Tax break | 15% CIT rate |
| **R&D Subsidies** | Grant | Varies |
| **Talent Programs** | Support | Housing, incentives |

### Fundraising Reality

| Aspect | Reality |
|--------|---------|
| **Timeline** | 3-9 months typical |
| **Due diligence** | Thorough, relationship-based |
| **Terms** | More founder-friendly than before |
| **Language** | Pitch decks often in Chinese |
| **Relationships** | Warm intros matter enormously |

---

## 🏢 Company Setup

### Structure Options

| Structure | Ownership | Use Case |
|-----------|-----------|----------|
| **Chinese company** | 100% local | Chinese founders |
| **WFOE** | 100% foreign | Foreign founders, most cases |
| **VIE** | Indirect | Restricted sectors, complex |
| **Cayman + WFOE** | Offshore + China | VC-backed, standard structure |

### "Cayman Sandwich" Structure

Standard for VC-backed startups:

```
Cayman Holding Company (Investors invest here)
    ↓
Hong Kong Company (Intermediate)
    ↓
WFOE in Beijing (Operations)
```

**Why:** Allows foreign investment, familiar to VCs, clean exit path

### Setup Timeline

| Step | Timeline |
|------|----------|
| Offshore structure | 4-8 weeks |
| WFOE in Beijing | 6-10 weeks |
| Bank accounts | 2-4 weeks |
| Operational | 3-4 months total |

### Costs

| Item | Cost |
|------|------|
| Cayman setup | $3,000-8,000 |
| HK company | $1,000-3,000 |
| WFOE setup | ¥20,000-50,000 |
| Legal fees | $10,000-30,000 |
| Annual compliance | $15,000-30,000 |

---

## 🎯 Accelerators & Incubators

### Top Programs

| Program | Focus | Benefits |
|---------|-------|----------|
| **Tsinghua x-lab** | University spinoffs | Resources, mentorship |
| **Zhongguancun Inno Way** | All startups | Space, events, connections |
| **Sinovation Ventures** | AI | Funding + support |
| **Techstars** | Cross-border | Global network |
| **Plug and Play** | Corporate partnerships | Enterprise connections |
| **Microsoft Accelerator** | Tech | Azure credits, mentorship |
| **HAX** | Hardware | Shenzhen connection |

### Government Programs

| Program | Benefits |
|---------|----------|
| **Zhongguancun High-tech Enterprise** | Tax incentives, grants |
| **Beijing "Golden Seed"** | Early-stage support |
| **Haidian Innovation District** | Subsidized space, services |

### Incubator Space

| Type | Cost (¥/month) | Notes |
|------|----------------|-------|
| Hot desk | 500-1,500 | Flexible |
| Dedicated desk | 1,500-3,000 | More privacy |
| Private office | 3,000-10,000+ | Team space |
| Subsidized | Free-1,000 | Government programs |

---

## 👥 Building Teams

### Hiring Challenges

| Challenge | Reality |
|-----------|---------|
| **Competition** | ByteDance, Alibaba, etc. poach talent |
| **Salary expectations** | Tech talent expensive |
| **Equity understanding** | Varies, education needed |
| **Work culture** | 996 expectations |

### Salary Benchmarks (Startup)

| Role | Monthly (¥) | Notes |
|------|-------------|-------|
| Junior engineer | 15,000-25,000 | Fresh grad |
| Mid engineer | 30,000-50,000 | 3-5 years |
| Senior engineer | 50,000-80,000 | 5+ years |
| Tech lead | 60,000-100,000 | Management |
| Product manager | 25,000-60,000 | Varies by experience |

### Equity Compensation

| Role | Typical Range |
|------|---------------|
| Early employee (#1-5) | 0.5-2% |
| Employee #5-10 | 0.1-0.5% |
| Employee #10-30 | 0.05-0.2% |
| Later employees | 0.01-0.1% |

**Note:** ESOP pool typically 10-20% at seed stage

### Where to Find Talent

| Source | Best For |
|--------|----------|
| **Boss直聘** | All levels |
| **Liepin** | Mid/senior |
| **Maimai** | Referrals, networking |
| **Tsinghua/PKU** | New grads |
| **LinkedIn** | Expats, returnees |
| **ByteDance alumni** | Top talent |

---

## 🎪 Ecosystem Events

### Major Events

| Event | When | Focus |
|-------|------|-------|
| **GMIC** | Spring | Mobile/internet |
| **Startup Grind Beijing** | Monthly | Networking |
| **TechNode events** | Ongoing | Tech news |
| **Demo Day events** | Quarterly | Accelerator showcases |
| **36Kr events** | Ongoing | Media/industry |

### Where to Network

| Venue | Notes |
|-------|-------|
| **Zhongguancun Inno Way** | Startup hub |
| **WeWork Zhongguancun** | Coworking |
| **Tsinghua campus events** | University connection |
| **VC office hours** | Some funds offer |

### Online Communities

| Platform | Use |
|----------|-----|
| **36Kr (36氪)** | News, analysis |
| **PEdaily (投资界)** | Investment news |
| **IT桔子** | Company database |
| **WeChat groups** | Founders, investors |

---

## 🌏 For Foreign Founders

### Visa Considerations

| Path | Notes |
|------|-------|
| **Work permit via own company** | Possible but complex |
| **Startup visa** | Limited availability |
| **Investment visa** | If meeting thresholds |
| **Co-founder arrangement** | Chinese co-founder holds permit |

### Practical Considerations

| Factor | Reality |
|--------|---------|
| **Bank accounts** | Personal and company challenging |
| **Signing authority** | Need Chinese co-founder for many things |
| **Government relations** | Chinese speaker essential |
| **Local partnerships** | Critical for many industries |

### Recommended Approach

1. **Chinese co-founder** — If possible, essential for many functions
2. **Strong local team** — Operations, finance, HR
3. **Legal counsel** — China-experienced lawyers
4. **Patient capital** — China takes time

### Success Stories (Foreign Founders)

| Company | Founder | Notes |
|---------|---------|-------|
| **Xiaoju Kuaizhi** | Multiple | Didi early team included foreigners |
| **Various** | Y Combinator China | Some cross-border success |
| **Many** | — | Often with Chinese co-founders |

---

## 📊 Sector Landscape (2025)

### Hot Sectors

| Sector | Investment Level | Government Support |
|--------|-----------------|-------------------|
| **AI/LLM** | Very High | High |
| **Robotics** | High | High |
| **Biotech/Pharma** | High | High |
| **Clean Energy/EV** | High | Very High |
| **Semiconductor** | Very High | Very High |
| **Enterprise SaaS** | Medium | Medium |

### Cooling Sectors

| Sector | Status | Notes |
|--------|--------|-------|
| **Consumer Internet** | Mature | Hard to differentiate |
| **Crypto** | Banned | Not viable in China |
| **EdTech** | Regulated | Heavy restrictions |
| **Gaming** | Regulated | License requirements |

### Government Priority Industries

| Industry | Why |
|----------|-----|
| **Semiconductors** | Self-sufficiency |
| **AI** | Global competition |
| **New Energy** | Environmental goals |
| **Biotech** | Healthcare modernization |
| **Advanced Manufacturing** | Industrial upgrade |

---

## ⚠️ Common Pitfalls

1. **Underestimating complexity** — China is hard, takes longer than expected
2. **Wrong structure** — Get legal advice before setting up
3. **Ignoring regulations** — Rules change, stay compliant
4. **Over-relying on guanxi** — Relationships matter but product too
5. **Not localizing** — What works elsewhere may not work here
6. **Burning cash** — Runway matters, be efficient
7. **Talent mistakes** — Equity, culture, expectations
8. **IP protection** — Register early, protect assets

---

## 💡 Success Factors

| Factor | Why Important |
|--------|---------------|
| **Local insight** | Understanding Chinese users/market |
| **Speed** | Competition moves fast |
| **Capital efficiency** | Funding environment changing |
| **Government relations** | Increasingly important |
| **Talent retention** | Key people are everything |
| **Regulatory awareness** | Stay ahead of changes |

---

## 🛠️ Resources

### Essential Services

| Service | Providers |
|---------|-----------|
| **Legal** | Han Kun, Fangda, AllBright |
| **Accounting** | Big 4, local firms |
| **Incorporation** | CorpHub, Innoport |
| **Banking** | Bank of China, CMB |
| **Coworking** | WeWork, Kr Space, Ucommune |

### Information Sources

| Source | Use |
|--------|-----|
| **36Kr** | News, analysis |
| **TechNode** | English coverage |
| **IT桔子** | Company database |
| **PitchBook/CB Insights** | Data (paid) |
| **Crunchbase** | Company data |

---

*Last updated: February 2026*
