# Beijing Safety & Legal Guide

> Last updated: February 2026 | Essential information on laws, regulations, and staying safe

## Overview

Beijing is generally very safe for visitors and residents. Violent crime against foreigners is rare. The main risks are: petty scams, traffic, air pollution, and unknowingly violating local laws. Understanding China's legal system is crucial.

---

## 🚨 Crime & Personal Safety

### Crime Level

| Type | Risk Level | Notes |
|------|------------|-------|
| Violent crime | Very Low | Rare against foreigners |
| Petty theft | Low-Medium | Pickpocketing at tourist spots |
| Scams | Medium | Tourist areas, see below |
| Traffic accidents | Medium | Dangerous driving culture |
| Assault | Very Low | Extremely rare |

### Safety by Area

| Area | Safety Level | Notes |
|------|--------------|-------|
| Sanlitun | Safe | Well-policed, night activity |
| CBD | Very Safe | Business district, cameras |
| Hutongs | Safe | Some dark alleys at night |
| Train stations | Medium | Pickpockets, watch belongings |
| Tourist sites | Safe | Scams more than crime |
| Outer suburbs | Safe | Less English support |

### Women's Safety

- Generally safe to walk alone, including at night
- Public transport safe but very crowded during rush hour
- Harassment rare but can happen in crowded spaces
- Women-only subway waiting areas available
- Trust your instincts

---

## 🎭 Common Scams

### Tea Ceremony Scam 🚨

**How it works:**
1. Young woman approaches, "practices English"
2. Invites you to "tea ceremony" or "art exhibition"
3. Bill arrives: ¥500-2,000+

**Prevention:** Never go anywhere with strangers who approach you

### Art Student Scam

**How it works:**
1. "Art student" invites you to gallery
2. Pressure to buy overpriced art

**Prevention:** Politely decline

### Fake Monks

**How it works:**
1. Person in monk robes asks for donation
2. Aggressive if refused

**Reality:** Real monks don't solicit on streets
**Prevention:** Politely decline and walk away

### Black Taxi/Unlicensed Drivers

**How it works:**
1. "Taxi? Taxi?" at airports/stations
2. No meter, inflated price
3. Sometimes dangerous routes

**Prevention:** Use DiDi or official taxi queue only

### Restaurant Scams

**How it works:**
1. Menu shows one price
2. Bill shows different price
3. "Service charge" or "special tea" added

**Prevention:** Photograph menu, check bill carefully

### Money Changing

**How it works:**
1. Better exchange rate offered
2. Fake bills given

**Prevention:** Use banks or ATMs only

---

## ⚖️ Legal System

### Key Points

- **Civil law system** — different from common law
- **Presumption of guilt** — prove innocence, not prosecution proving guilt
- **Detention:** Can be held 37 days before charges
- **Embassy access:** Right to contact embassy, but limited assistance
- **Lawyers:** Recommended for any legal issue

### Foreigners and the Law

- Laws apply equally to foreigners
- No special treatment (may be worse in political matters)
- "Cultural misunderstanding" is not a valid defense
- Fines and deportation common for minor offenses
- Prison sentences for serious violations

---

## 🔐 Mandatory Requirements

### 24-Hour Registration

**THE MOST IMPORTANT RULE:**

All foreigners must register with police within **24 hours** of arrival at any address.

| Situation | Who Registers |
|-----------|---------------|
| Hotel | Hotel does it automatically |
| Airbnb | Host should register (many don't) |
| Friend's home | YOU must go to PSB |
| Rental apartment | YOU must go to PSB |
| Moving apartments | Re-register within 24 hours |

**How to Register:**

1. Go to local PSB (Public Security Bureau / 派出所)
2. Bring: Passport, rental contract, landlord ID copy
3. Fill forms (Chinese, staff usually helps)
4. Receive registration slip
5. **Keep this slip** — needed for visa extensions

**Consequences of Not Registering:**
- Warning and fine (¥500-2,000 first offense)
- Detention for repeated violations
- Visa problems
- Deportation possible

### Work Permit Requirements

**Working illegally = serious offense**

| Situation | Legal Status |
|-----------|--------------|
| Tourist visa (L) | NO work allowed |
| Business visa (M) | NO work allowed |
| Work permit (Z visa + permit) | Legal to work |
| Student visa (X) | Limited work with approval |

**Consequences of Illegal Work:**
- Fine: ¥5,000-20,000
- Detention: 5-15 days
- Deportation
- 5-year entry ban

---

## 🚫 Prohibited Activities

### Drugs

**Zero tolerance policy:**

| Offense | Consequence |
|---------|-------------|
| Possession (any amount) | 5-15 years |
| Trafficking | 15 years to death penalty |
| Use (even marijuana) | Detention + forced treatment |
| Positive drug test | Same as possession |

**Note:** Testing positive can result in charges, even if consumed elsewhere

### Photography Restrictions

**Do NOT photograph:**
- Military installations
- Government buildings
- Police/security personnel
- Airports (security areas)
- Border crossings
- "No photography" signs

**Consequences:** Camera/phone confiscation, detention, espionage accusations

### Political Activities

**Avoid:**
- Protests or demonstrations
- Political organizing
- Distributing political material
- Discussing "sensitive topics" publicly (Tiananmen, Tibet, Taiwan, Uyghurs)
- Criticizing government/Party online

**Note:** Social media is monitored. WeChat messages can be used as evidence.

### Religious Activities

- Personal worship: Generally OK
- Proselytizing: Illegal
- Unauthorized religious gatherings: Illegal
- Religious materials distribution: Illegal

### VPN Usage

**Gray area:**

| Use | Legal Status |
|-----|--------------|
| Personal use (accessing Google) | Technically illegal but tolerated |
| Business VPN (authorized) | Legal |
| Selling/promoting VPN | Illegal, arrests made |
| Using VPN for illegal content | Illegal |

**Practical reality:** Millions use VPNs daily. Enforcement targets Chinese citizens and businesses, not tourists using Gmail.

---

## 🚗 Traffic Safety

### Pedestrian Dangers

| Hazard | Notes |
|--------|-------|
| **Electric scooters** | Silent, fast, ignore traffic rules |
| **Right turns on red** | Cars turn while you have green |
| **Red light running** | Common, always look both ways |
| **Bike lanes** | Shared with scooters, can be chaotic |

### Safety Tips

- **Always look both ways** even on one-way streets
- **Don't assume green = safe** — cars may still turn
- **Watch for electric scooters** — silent and fast
- **Use pedestrian bridges** when available
- **Cross with groups** when possible

### Driving Safety

See `driving.md` for full details, but:
- Driving culture is aggressive
- Rules frequently ignored
- Accidents common
- If possible, use DiDi rather than driving

---

## 📱 Digital Safety

### Internet Monitoring

**Assume all internet activity is monitored:**

| Platform | Status |
|----------|--------|
| WeChat | Monitored, censored |
| Weibo | Monitored, censored |
| Email (Chinese services) | Monitored |
| VPN traffic | Blocked but accessible |
| Foreign services | Blocked without VPN |

### Sensitive Topics Online

**Avoid discussing or sharing:**
- Tiananmen Square events
- Tibet independence
- Taiwan status
- Xinjiang/Uyghurs
- Hong Kong protests
- Criticism of leadership
- "Winnie the Pooh" (blocked as political meme)

### WeChat Caution

- Assume messages are read
- Don't share sensitive content
- Don't join political groups
- Be careful with forwarding
- Account can be banned

### VPN Best Practices

- Download before arriving in China
- Have multiple VPN options (they get blocked)
- Don't discuss VPN use on Chinese platforms
- Don't sell or promote VPN services

---

## 🏥 Health & Emergency

### Emergency Numbers

| Service | Number | Notes |
|---------|--------|-------|
| Police | 110 | Limited English |
| Ambulance | 120 | Limited English |
| Fire | 119 | |
| Traffic accident | 122 | |
| Tourist hotline | 12301 | English available |

### Hospitals for Foreigners

| Hospital | Type | Notes |
|----------|------|-------|
| United Family | International | English, expensive |
| Raffles Medical | International | Good for minor issues |
| Beijing Hospital (VIP) | Public + international wing | Cheaper than private |
| Peking Union Hospital | Public | Best for serious issues, crowded |

### If Arrested or Detained

1. **Request to contact embassy** — This is your right
2. **Do not sign anything** you don't understand
3. **Request interpreter**
4. **Do not resist** — cooperate physically
5. **Request lawyer** (embassy can provide list)
6. **Document everything** mentally

### Embassy Contact

| Country | Beijing Embassy Phone |
|---------|---------------------|
| USA | +86-10-8531-4000 |
| UK | +86-10-5192-4000 |
| Canada | +86-10-5139-4000 |
| Australia | +86-10-5140-4111 |
| EU states | Varies |

---

## 🔒 Protecting Your Belongings

### Hotel Safety

- Use safe for valuables
- Don't leave electronics visible
- Keep passport secure but accessible

### Street Safety

- Front pockets for wallet
- Bag across body, not on shoulder
- Phone secure, not sticking out of pocket
- Be aware in crowded areas

### Digital Security

- VPN for sensitive activities
- Don't use public WiFi for banking
- Two-factor authentication
- Phone pin/face lock

---

## ⚠️ Know Your Rights (and Limits)

### You Have Rights To:

- Contact your embassy
- Interpreter during questioning
- Refuse to answer (but may not help)
- Lawyer (after certain periods)
- Medical care if needed
- Know charges against you

### You Do NOT Have Rights To:

- Remain silent (no Miranda rights)
- Phone call immediately
- Release on bail automatically
- Trial by jury
- Public trial necessarily

---

## Quick Reference: What NOT To Do

1. ❌ Work on tourist/business visa
2. ❌ Forget to register with police
3. ❌ Carry or use any drugs
4. ❌ Photograph military/government
5. ❌ Discuss sensitive politics publicly
6. ❌ Join protests or demonstrations
7. ❌ Overstay your visa (even one day)
8. ❌ Drive without Chinese license
9. ❌ Sign documents you don't understand
10. ❌ Assume laws don't apply to foreigners

---

*Last updated: February 2026*
