# Moving to Beijing: Resident Guide

> Last updated: February 2026 | Complete guide to settling in Beijing as an expat

## Overview

Moving to Beijing is a significant undertaking. This guide covers the practical steps from arrival to feeling settled.

---

## 📋 Pre-Arrival Checklist

### 4-8 Weeks Before

| Task | Notes |
|------|-------|
| ✅ Visa sorted | Z visa for work, see `visas.md` |
| ✅ VPN downloaded | Cannot download inside China |
| ✅ WeChat installed | Verify phone number works |
| ✅ Essential documents copied | Passport, visa, diplomas |
| ✅ Bank notified | International usage alerts |
| ✅ International health insurance | Until local kicks in |
| ✅ Vaccinations | Optional but consider hepatitis A/B |
| ✅ Prescriptions | Bring supply + doctor's letter |

### 1 Week Before

| Task | Notes |
|------|-------|
| ✅ Temporary accommodation | Hotel or Airbnb for first weeks |
| ✅ Airport transfer arranged | DiDi or company pickup |
| ✅ Cash | ¥2,000-3,000 for initial needs |
| ✅ Contact list | HR, agent, emergency numbers |
| ✅ Chinese phrases | Basic survival phrases |
| ✅ Offline maps | Download Beijing area |

---

## 🛬 First 72 Hours

### Day 1: Arrival

| Time | Task |
|------|------|
| Arrival | Clear immigration, collect bags |
| Airport | Get SIM card at arrival hall |
| Transfer | DiDi or arranged pickup |
| Hotel | Check in, rest |
| Evening | Light exploration, find food |

### Day 2: Essentials

| Task | Location | Time |
|------|----------|------|
| Register with police | Hotel does automatically | — |
| Get Yikatong (metro card) | Subway station | 10 min |
| Buy essentials | Convenience store, supermarket | 1 hour |
| Set up WeChat Pay | On phone | 30 min |
| Explore neighborhood | Walking | 2 hours |

### Day 3: Work Setup

| Task | Notes |
|------|-------|
| Meet HR/employer | Documents, paperwork |
| Begin work permit process | Employer handles |
| Get local phone plan | If not done at airport |
| Start apartment search | Agent or online |

---

## 🏠 Finding Housing

### Process Overview

1. **Temporary housing** (1-4 weeks)
2. **Research areas** (see `neighborhoods-*.md`)
3. **Contact agents or search online**
4. **View apartments** (at least 5-10)
5. **Negotiate and sign**
6. **Move in**
7. **Register with police** (within 24 hours)

### Apartment Hunting

**Platforms:**
- Lianjia (链家) — largest, Chinese only
- Ziroom (自如) — managed apartments
- WeChat groups — expat communities
- SmartShanghai/The Beijinger — expat listings

**Working with Agents:**
- Agents are standard and expected
- Fee: 1 month rent (sometimes negotiable)
- Good agent helps with landlord communication
- Bad agent wastes time with unsuitable places

### What to Check

| Item | Why |
|------|-----|
| **Heating system** | Old buildings can be cold |
| **Hot water type** | Gas instant vs tank |
| **Internet speed** | Test if possible |
| **Building age** | Newer = better maintenance |
| **Landlord responsiveness** | Will they fix things? |
| **Neighborhood noise** | Construction, traffic |
| **Metro distance** | Walk it yourself |
| **Elevator** | Especially if high floor |

### Contract Essentials

| Term | Standard |
|------|----------|
| **Duration** | 1 year minimum |
| **Deposit** | 2 months (3 for nice places) |
| **Payment** | Quarterly or semi-annual |
| **Notice period** | 1-2 months |
| **Utilities** | Confirm who pays what |
| **Repairs** | Landlord responsibility |

**Red Flags:**
- No written contract
- Cash-only payments
- Landlord refuses photos
- Significantly below market rate
- Pressure to sign immediately

### Move-in Day

1. **Document everything** — photos of existing damage
2. **Test everything** — AC, heating, appliances, water
3. **Get landlord contact** — WeChat, phone
4. **Utility accounts** — transfer or set up
5. **Internet** — schedule installation
6. **Keys** — get all copies

---

## 📝 Registration & Documentation

### Police Registration (Mandatory)

**Within 24 hours of moving to ANY new address:**

| Item | What to Bring |
|------|---------------|
| Passport | Original |
| Rental contract | Copy OK |
| Landlord ID | Copy (landlord provides) |
| Your photo | Some stations require |

**Process:**
1. Find local PSB (派出所) — ask landlord or search map
2. Take a number, wait
3. Fill form (staff helps)
4. Submit documents
5. Receive registration slip
6. **Keep this slip** — needed for visa extensions

### Work Permit Process

**Your employer handles most of this:**

| Step | Timeline | Who Does It |
|------|----------|-------------|
| Work permit notification | 2-4 weeks | Employer |
| Z visa application | 1-2 weeks | You (at consulate) |
| Entry to China | — | You |
| Work permit | 2-4 weeks | Employer |
| Residence permit | 1-2 weeks | You + Employer |
| Health check | 1 day | You |

### Health Check

**Required for work permit:**

| Location | Notes |
|----------|-------|
| **International Travel Healthcare Center** | Multiple in Beijing |
| **Bring:** Passport, 2 photos | Morning, fasting recommended |
| **Tests:** Blood, X-ray, ECG, basic physical | 2-3 hours |
| **Cost:** ~¥600-800 | |
| **Results:** 3-5 business days | |

---

## 🏦 Financial Setup

### Bank Account (See `local.md` for details)

**Recommended:** Bank of China or ICBC

**For full banking:**
- Work permit required (not just visa)
- Employment proof helpful
- Can do basic account with visa

### Salary Payment

| Method | Notes |
|--------|-------|
| **Chinese bank account** | Most common for local contracts |
| **Home country account** | Some international companies |
| **Split** | Part local, part home |

### Transferring Money Home

| Method | Speed | Cost | Limit |
|--------|-------|------|-------|
| **Bank wire** | 2-5 days | ¥100-300 + fees | $50k/year limit |
| **Wise (TransferWise)** | 1-2 days | Low | $50k/year limit |
| **Western Union** | Fast | High | Limited |
| **Carrying cash** | Instant | None | $5,000 limit |

**$50k annual limit:** Foreigners can legally convert and transfer up to $50,000 equivalent per year with proper documentation.

---

## 🏥 Healthcare Setup

### Health Insurance

| Type | Source | Coverage |
|------|--------|----------|
| **Employer-provided** | Company | Basic to comprehensive |
| **Private international** | Cigna, Bupa, Allianz | Comprehensive |
| **Local Chinese** | Chinese insurers | Basic, in Chinese |
| **Travel insurance** | Home country | Short-term only |

### Register with Doctor

**Recommended:** Establish relationship with international clinic for routine care

| Hospital Type | Best For | Cost |
|---------------|----------|------|
| **International (United Family)** | Routine care, English | High |
| **Public VIP** | Specialists, serious issues | Medium |
| **Public general** | Budget, minor issues | Low |

---

## 🎒 Settling In

### First Month Checklist

| Week | Tasks |
|------|-------|
| **Week 1** | SIM card, temporary housing, registration, basics |
| **Week 2** | Apartment search, work permit process begins |
| **Week 3** | Sign apartment, health check, bank account |
| **Week 4** | Move in, register new address, settle |

### Making Friends

| How | Notes |
|-----|-------|
| **Work colleagues** | Natural social circle |
| **Expat groups** | Beijing Expats Facebook, WeChat groups |
| **Sports/hobbies** | Hash House Harriers, Ultimate Frisbee, etc. |
| **Language exchange** | Meet locals wanting English practice |
| **Apps** | Meetup (needs VPN), WeChat groups |

### Finding Community

| Group | Focus |
|-------|-------|
| **The Beijinger** | Expat events, forums |
| **InterNations** | Professional expats |
| **WeChat groups** | Neighborhood-specific |
| **Embassy events** | National community |
| **Religious groups** | If applicable |

---

## 📦 Shipping Belongings

### Options

| Method | Time | Cost | Best For |
|--------|------|------|----------|
| **Air freight** | 1-2 weeks | $$$$$ | Urgent items |
| **Sea freight** | 6-10 weeks | $$ | Large shipments |
| **Checked luggage** | Instant | $$$ | Personal items |
| **Buy in China** | N/A | Varies | Most things |

### What to Bring vs Buy

**Bring:**
- Medications (with prescriptions)
- Electronics (phone, laptop)
- Specialty clothing (large sizes)
- Sentimental items
- Professional equipment

**Buy in China:**
- Furniture
- Kitchen items
- Bedding
- Basic electronics
- Most clothing

### Customs Considerations

- Used electronics: OK for personal use
- Books: May be inspected
- Food: Limited, processed OK
- Restricted: Political materials, weapons

---

## 🚸 If Bringing Family

### Schools

See `education.md` for details. Start process 6-12 months ahead for international schools.

### Spouse Employment

| Situation | Options |
|-----------|---------|
| **Dependent visa** | Cannot work legally |
| **Own work permit** | Full employment rights |
| **Freelance visa** | Self-employment option |
| **Remote work** | Gray area, technically illegal |

### Kids' Adjustment

| Age | Challenge | Solution |
|-----|-----------|----------|
| **0-5** | Minimal | Adapts easily |
| **6-12** | Social adjustment | International school community |
| **13+** | Significant | May resist, needs support |

---

## ⏰ Timelines

### Minimum Setup Time

| Task | Minimum Time |
|------|--------------|
| Work permit process | 4-8 weeks |
| Apartment finding | 1-2 weeks |
| Bank account | 1-3 days |
| Internet installation | 1-5 days |
| Feeling settled | 3-6 months |

### If Children (International School)

| Task | Timeline |
|------|----------|
| Research schools | 12+ months before |
| Applications | 6-12 months before |
| Interviews | 4-8 months before |
| Acceptance | 2-6 months before |
| Preparation | Summer before arrival |

---

## 💡 Tips from Long-Term Expats

1. **Learn some Chinese** — Even basics help enormously
2. **Embrace WeChat** — Resistance is futile
3. **Get a VPN that works** — Test before arrival
4. **Don't compare to home** — Beijing is different, not worse
5. **Make local friends** — Expat bubble limits experience
6. **Explore beyond Sanlitun** — Real Beijing is elsewhere
7. **Prepare for bureaucracy** — Patience required
8. **Keep sense of humor** — Things will go wrong
9. **Document everything** — Receipts, contracts, registrations
10. **Have exit plan** — Know what you'd need to leave quickly

---

*Last updated: February 2026*
