# Beijing Neighborhoods — Quick Comparison Index

> **Data Sources:** Lianjia (Dec 2025), Beijing Real Estate, Expat forums, local research (2026)  
> **Currency:** CNY/RMB (¥1 CNY ≈ $0.14 USD ≈ €0.13 EUR)

---

## 📊 Rental Price Comparison (Monthly ¥ — 2025-2026)

| Neighborhood | Studio | 1-Bedroom | 2-Bedroom | 3-Bedroom | Notes |
|-------------|--------|-----------|-----------|-----------|-------|
| **CBD (Guomao)** | 7,000-10,000 | 10,000-18,000 | 15,000-30,000 | 25,000-45,000 | Business hub, towers |
| **Sanlitun** | 6,000-9,000 | 9,000-15,000 | 14,000-25,000 | 22,000-40,000 | Expat central, nightlife |
| **Chaoyang Park area** | 6,000-9,000 | 8,000-14,000 | 12,000-22,000 | 18,000-35,000 | Families, green space |
| **Dongzhimen/Sanyuanqiao** | 5,500-8,000 | 7,500-12,000 | 10,000-18,000 | 15,000-28,000 | Convenient, Airport Express |
| **Zhongguancun** | 4,500-7,000 | 6,000-10,000 | 9,000-16,000 | 12,000-22,000 | Tech hub, Haidian |
| **Wudaokou** | 3,500-5,500 | 5,000-8,000 | 7,000-12,000 | 10,000-18,000 | Students, Korean food |
| **Dongcheng (Hutong area)** | 4,000-6,500 | 6,000-10,000 | 9,000-16,000 | 14,000-25,000 | Historic, character |
| **Xicheng (Houhai)** | 4,500-7,000 | 6,500-11,000 | 10,000-18,000 | 15,000-28,000 | Historic west, lakes |
| **Shunyi (Central Villa)** | — | — | 18,000-30,000 | 25,000-50,000+ | Expat villas, schools |
| **Tongzhou** | 3,000-4,500 | 4,000-6,500 | 5,500-9,000 | 7,000-12,000 | New sub-center, budget |
| **Changping** | 2,500-4,000 | 3,500-5,500 | 4,500-7,500 | 6,000-10,000 | Far suburbs, affordable |

---

## 🎯 Quick Profile Matching

### 💼 Single Professionals (Budget: 6,000-12,000/month)
| Priority | Best Choice | Why |
|----------|-------------|-----|
| Nightlife + Social | **Sanlitun** | Bars, restaurants, expat scene |
| Tech/Startup | **Zhongguancun** | Near tech companies, universities |
| Convenience | **Dongzhimen** | Airport Express, central |
| Budget + Central | **Dongcheng (outer)** | Historic, affordable, subway |

### 💑 Couples / DINKs (Budget: 10,000-20,000/month)
| Priority | Best Choice | Why |
|----------|-------------|-----|
| Lifestyle | **Sanlitun** | Best dining, nightlife, shopping |
| Parks + Space | **Chaoyang Park area** | Green space, good apartments |
| Culture | **Dongcheng/Xicheng** | Hutongs, temples, history |
| Modern + Value | **CBD perimeter** | New buildings, good transit |

### 👨‍👩‍👧‍👦 Expat Families (Budget: 20,000-50,000/month)
| Priority | Best Choice | Why |
|----------|-------------|-----|
| International Schools | **Shunyi** | ISB, WAB, BSB, Dulwich |
| Chinese Integration | **Chaoyang Park area** | Mix of local and expat |
| Space + Value | **Shunyi outer** | Large villas, compounds |
| Central + Schools | **Sanlitun/Liangmaqiao** | Some international schools nearby |

### 🎓 Students (Budget: 3,000-6,000/month)
| Priority | Best Choice | Why |
|----------|-------------|-----|
| University Area | **Wudaokou** | PKU, Tsinghua nearby |
| Budget | **Changping/Shahe** | Cheap, near university towns |
| Central + Budget | **Dongcheng outer** | Historic, subway access |

### 💎 Luxury / No Budget Limit
| Priority | Best Choice | Why |
|----------|-------------|-----|
| Ultimate Prestige | **Shunyi compounds** | Riviera, Yosemite, villas |
| Central Luxury | **CBD penthouses** | Skyline views, China World |
| Historic Luxury | **Courtyard homes** | Restored siheyuan |

---

## 🚇 Metro Access Score

| Neighborhood | Metro Access | Walkability | Car Dependency |
|--------------|--------------|-------------|----------------|
| CBD (Guomao) | ⭐⭐⭐⭐⭐ | ⭐⭐⭐⭐ | Low |
| Sanlitun | ⭐⭐⭐⭐ | ⭐⭐⭐⭐⭐ | Low |
| Dongcheng | ⭐⭐⭐⭐⭐ | ⭐⭐⭐⭐⭐ | Low |
| Zhongguancun | ⭐⭐⭐⭐⭐ | ⭐⭐⭐⭐ | Low |
| Wudaokou | ⭐⭐⭐⭐⭐ | ⭐⭐⭐⭐ | Low |
| Chaoyang Park | ⭐⭐⭐⭐ | ⭐⭐⭐ | Medium |
| Houhai/Xicheng | ⭐⭐⭐⭐ | ⭐⭐⭐⭐⭐ | Low |
| Shunyi | ⭐⭐ (Line 15 only) | ⭐⭐ | Very High |
| Tongzhou | ⭐⭐⭐⭐ | ⭐⭐⭐ | Medium |
| Changping | ⭐⭐⭐ | ⭐⭐ | High |

---

## 🏫 International School Proximity

| Neighborhood | Schools Nearby | Notes |
|--------------|---------------|-------|
| **Shunyi** | ISB, WAB, BSB, Dulwich, CISB | Primary expat school zone |
| **Chaoyang Park** | BCIS, Ivy Academy, 3e | Some bilingual options |
| **Sanlitun/Liangmaqiao** | Canadian IS, House of Knowledge | Limited but central |
| **Haidian** | SMIC, Keystone | Tech family options |
| **CBD** | Yew Chung, Harrow | Central options |

---

## 🌿 Air Quality by Area

| Area | AQI Tendency | Notes |
|------|--------------|-------|
| **Shunyi** | ⭐⭐⭐⭐ Better | More suburban, some green |
| **Olympic Forest** | ⭐⭐⭐⭐ Better | Park nearby helps |
| **CBD** | ⭐⭐⭐ Average | Traffic pollution |
| **Haidian/Universities** | ⭐⭐⭐ Average | Less industrial |
| **Dongcheng** | ⭐⭐⭐ Average | Historic but central |
| **Tongzhou** | ⭐⭐⭐⭐ Better | Newer development, less traffic |

**Note:** AQI varies dramatically day-to-day regardless of neighborhood. Air purifiers essential everywhere.

---

## 🌐 Expat Density

| Neighborhood | Expat % | English Friendliness |
|--------------|---------|---------------------|
| **Sanlitun** | Very High | ⭐⭐⭐⭐⭐ |
| **Shunyi** | Very High | ⭐⭐⭐⭐⭐ |
| **CBD** | High | ⭐⭐⭐⭐ |
| **Chaoyang Park** | High | ⭐⭐⭐⭐ |
| **Wudaokou** | High (students) | ⭐⭐⭐⭐ |
| **Dongcheng** | Medium | ⭐⭐⭐ |
| **Zhongguancun** | Medium (tech) | ⭐⭐⭐ |
| **Tongzhou** | Low | ⭐⭐ |
| **Changping** | Very Low | ⭐ |

---

## ⚠️ Key Warnings

1. **Shunyi Isolation** — Beautiful villas but 1+ hour to downtown, car mandatory
2. **CBD Traffic** — Gridlocked 8-10 AM, 5-8 PM. Walking or metro often faster
3. **Sanlitun Noise** — Bar street area can be very loud weekends
4. **Hutong Heating** — Old buildings may have poor insulation
5. **Wudaokou Crowds** — Very busy, student nightlife
6. **Tongzhou Distance** — 40-60 min subway to CBD
7. **Changping** — Far from everything, minimal English support

---

## 🔗 Detailed Guides

- [CBD, Sanlitun, Chaoyang →](neighborhoods-downtown.md)
- [Zhongguancun, Wudaokou, Haidian Tech →](neighborhoods-tech.md)  
- [Dongcheng, Xicheng, Historic Districts →](neighborhoods-historic.md)
- [Shunyi, Changping, Tongzhou →](neighborhoods-suburban.md)
- [How to Choose Your Neighborhood →](neighborhoods-choosing.md)
