# Beijing Local Services Guide

> Last updated: February 2026 | Banking, SIM cards, apps, and daily life essentials

## Overview

Setting up daily life in Beijing requires navigating a parallel digital ecosystem. Google, Facebook, and Western apps don't work. WeChat is EVERYTHING. This guide covers essential setup for daily life.

---

## 📱 Mobile/SIM Cards

### Carriers

| Carrier | Coverage | Expat-Friendly | Notes |
|---------|----------|----------------|-------|
| **China Mobile** | Best | Medium | Largest network |
| **China Unicom** | Good | Best | Better for foreigners |
| **China Telecom** | Good | Medium | Third option |

### Getting a SIM Card

**Requirements:**
- Passport
- Local address (hotel OK initially)
- Sometimes proof of residence

**Where:**
- Official carrier stores (recommended)
- Airport arrival halls
- Electronics stores

**Process:**
1. Go to carrier store with passport
2. Choose plan
3. Biometric registration (face scan)
4. Pay and activate
5. Takes 15-30 minutes

### Typical Plans

| Plan Type | Data | Cost (¥/month) | Notes |
|-----------|------|----------------|-------|
| Basic | 5GB | 50-80 | Enough for light use |
| Standard | 10-20GB | 80-150 | Most common |
| Heavy use | 30-50GB | 150-250 | Video streaming |
| Unlimited* | "Unlimited" | 200-400 | Throttled after limit |

*"Unlimited" usually means speed throttled after 20-40GB

### eSIM Options

- Some phones support eSIM
- Can pre-order before arrival
- Airalo, Holafly offer China eSIMs
- Coverage may be limited

---

## 💰 Banking

### Opening a Bank Account

**Required Documents:**
- Passport
- Valid visa (work visa for some features)
- Local phone number
- Proof of address (rental contract)
- Some banks require employment proof

**Recommended Banks:**

| Bank | English Support | Mobile App | ATM Network |
|------|-----------------|------------|-------------|
| **Bank of China** | Best | Good | Excellent |
| **ICBC** | Good | Good | Excellent |
| **China Merchants** | Medium | Excellent | Good |
| **HSBC (Expat)** | Excellent | Good | Limited |

### Bank Account Process

1. Go to main branch (not sub-branch)
2. Take a queue number
3. Fill forms (bring Chinese speaker if possible)
4. Submit documents
5. Receive debit card same day or wait 1-2 weeks
6. Set up mobile banking

### Mobile Banking Setup

1. Download bank's app
2. Link to your account
3. Set up passwords/PINs
4. Verify via SMS
5. Link to WeChat/Alipay

**Note:** Some apps are Chinese-only, use translation

### ATM Tips

- Most ATMs accept international cards
- Bank of China/ICBC best for foreign cards
- Daily withdrawal limit: ~¥10,000-20,000
- Notify home bank before arrival
- Fees: ¥15-30 per withdrawal + home bank fees

---

## 💳 Mobile Payment

### WeChat Pay Setup

**For Foreigners (2024+ updates):**

1. Download WeChat
2. Verify with phone number (any country)
3. Go to "Me" → "Services" → "Wallet"
4. Add international credit card (Visa/Mastercard)
5. Complete identity verification (passport photo)
6. May need to verify via video call

**Limitations:**
- Daily limits lower than Chinese users
- Some features restricted
- Must re-verify periodically

### Alipay Tour Pass

**For short-term visitors:**

1. Download Alipay
2. Use "Tour Pass" feature (prominent on home)
3. Load money from international card
4. Valid for 90 days
5. Maximum ¥10,000 balance

### Which to Use?

| Use Case | Recommendation |
|----------|----------------|
| Restaurants | Either |
| Street vendors | WeChat more common |
| Online shopping | Alipay |
| Utilities | Either |
| Mini-programs | WeChat |
| Social features | WeChat |

### Payment Reality

- 99% of merchants accept mobile payment
- Cash increasingly difficult (some refuse)
- Cards only at major hotels/malls
- Always keep backup payment method

---

## 📲 Essential Apps

### Must-Have Apps

| App | Chinese | Purpose | English? |
|-----|---------|---------|----------|
| **WeChat** | 微信 | Everything — chat, pay, life | Yes |
| **Alipay** | 支付宝 | Payments, services | Yes |
| **DiDi** | 滴滴 | Ride-hailing | Yes |
| **Baidu Maps** | 百度地图 | Navigation | Limited |
| **Amap** | 高德地图 | Navigation | Yes |
| **Meituan** | 美团 | Food delivery, services | Limited |
| **Eleme** | 饿了么 | Food delivery | Limited |
| **Taobao** | 淘宝 | Online shopping | Limited |
| **JD.com** | 京东 | Online shopping | Yes |
| **Dianping** | 大众点评 | Restaurant reviews | Limited |

### VPN Apps (Download BEFORE Arrival)

| VPN | Notes |
|-----|-------|
| **ExpressVPN** | Reliable, pricey |
| **Astrill** | Good for China |
| **NordVPN** | Sometimes blocked |
| **Surfshark** | Budget option |

**Critical:** Cannot download most VPNs inside China

### Communication (Behind the Wall)

| Blocked | Alternative |
|---------|-------------|
| WhatsApp | WeChat |
| Google | Baidu |
| Gmail | WeChat, Chinese email |
| Google Maps | Baidu Maps, Amap |
| YouTube | Bilibili, Youku |
| Facebook | Weibo |
| Instagram | Xiaohongshu (RED) |
| Twitter | Weibo |

---

## 🏠 Housing Apps

### Finding Apartments

| Platform | Type | English | Notes |
|----------|------|---------|-------|
| **Lianjia (贝壳)** | All | No | Largest, most listings |
| **Ziroom (自如)** | Managed rentals | No | Quality controlled |
| **SmartShanghai Beijing** | Expat listings | Yes | Fewer options |
| **The Beijinger classifieds** | Expat | Yes | Good for shared housing |
| **WeChat groups** | Peer-to-peer | Mixed | Ask expat community |

### Rental Agents

- Agents are common and expected
- Fee: Usually 1 month rent
- Always verify apartment matches listing
- Check heating, water pressure, internet

---

## 🍽️ Food & Delivery Apps

### Food Delivery

| App | Coverage | Speed | English |
|-----|----------|-------|---------|
| **Meituan (美团)** | Best | Fast | Limited |
| **Eleme (饿了么)** | Good | Fast | Limited |
| **Sherpa's** | Expat areas | Medium | Yes |

### Groceries

| App | Type | Notes |
|-----|------|-------|
| **Meituan Maicai** | Groceries | Next-day delivery |
| **Dingdong Maicai** | Groceries | Same-day |
| **Freshippo (盒马)** | Premium groceries | Alibaba's supermarket |
| **JD Fresh** | Groceries | Good quality |
| **Taobao** | Everything | Longer delivery |

### Restaurant Discovery

| App | Use |
|-----|-----|
| **Dianping (大众点评)** | Chinese Yelp — reviews, booking |
| **WeChat mini-programs** | Many restaurants have own |
| **The Beijinger** | Expat restaurant guides |
| **Tripadvisor** | Tourist-focused (needs VPN) |

---

## 🏥 Healthcare Apps

### Hospital Appointment Booking

| App | Use |
|-----|-----|
| **114 (挂号)** | Public hospital appointments |
| **Hospital WeChat accounts** | Individual hospital booking |
| **Ping An Good Doctor** | Online consultation |

### Pharmacy

- Pharmacies everywhere, often 24-hour
- Basic medicines available without prescription
- Prescription drugs require hospital prescription
- Apps: Meituan, JD Health for delivery

---

## 💼 Work & Business

### Office Tools (China Alternatives)

| Blocked | China Alternative |
|---------|-------------------|
| Google Workspace | WPS Office, Feishu |
| Slack | Feishu, DingTalk |
| Zoom | Tencent Meeting, VooV |
| Dropbox | Baidu Pan, WeTransfer |
| Notion | Wolai, Feishu Docs |

### Business Registration

For business setup, see `business.md`

---

## 📫 Mail & Shipping

### Receiving Packages

- **Address format:** Province → City → District → Street → Building → Apt
- **Chinese address:** Essential for delivery
- **Phone number:** Courier will call
- **Timing:** Usually same-day to 2 days within China

### International Shipping

| Service | Speed | Cost | Notes |
|---------|-------|------|-------|
| **China Post** | Slow | Cheap | Track via 17track |
| **SF Express** | Fast | Medium | Best domestic |
| **DHL/FedEx/UPS** | Fast | Expensive | Documents |
| **Taobao logistics** | Varies | Cheap | For purchases |

### Receiving International Mail

- Can take 2-4 weeks
- Customs inspection possible
- Some items restricted (books, electronics may be inspected)
- Track via China Post

---

## 🔌 Utilities

### Electricity & Gas

- Pre-paid system
- Top up via WeChat/Alipay
- Scan meter → WeChat mini-program → Pay
- Keep topped up — electricity cuts off when empty

### Water

- Usually included in rent or building fee
- If separate, same pre-paid system

### Internet

| Provider | Notes |
|----------|-------|
| **China Telecom** | Reliable |
| **China Unicom** | Good for gaming |
| **China Mobile** | Good coverage |

**Setup:**
1. Choose provider
2. Technician visits (1-3 days)
3. Router installed
4. Pay monthly via app

**Speed:** 100-500 Mbps common, ¥100-200/month

---

## 🧹 Home Services

### Cleaning

| Service | Cost | Notes |
|---------|------|-------|
| **Hourly cleaner** | ¥40-80/hour | Book via Meituan, 58.com |
| **Deep clean** | ¥200-500 | Occasional |
| **Ayi (monthly)** | ¥3,000-6,000 | Regular helper |

### Repairs

| Service | Where | Notes |
|---------|-------|-------|
| **Plumber** | Building management, Meituan | ¥50-200 |
| **Electrician** | Building management | ¥50-200 |
| **Locksmith** | Street, Meituan | ¥50-150 |
| **AC repair** | Brand service, Meituan | ¥100-300 |

### Laundry

- Most apartments have washing machines
- Laundry services: Meituan, building services
- Dry cleaning: ¥20-50 per item

---

## 🛒 Online Shopping

### Major Platforms

| Platform | Best For | Speed | Price |
|----------|----------|-------|-------|
| **Taobao** | Everything | 2-5 days | Cheapest |
| **JD.com** | Electronics, quality | 1-2 days | Medium |
| **Pinduoduo** | Deals, budget | 3-7 days | Cheapest |
| **Tmall** | Brands, quality | 2-4 days | Medium |
| **Xiaohongshu** | Fashion, beauty | 2-5 days | Premium |

### Shopping Tips

- Use translation apps for Taobao
- Check reviews (星 = stars)
- 7-day return policy standard
- Payment via Alipay (Taobao) or WeChat

---

## 📞 Communication Tips

### Calling Home

| Method | Notes |
|--------|-------|
| **VPN + WhatsApp/FaceTime** | Free, needs VPN |
| **WeChat voice/video** | Free, works without VPN |
| **Local SIM international** | Expensive |
| **Google Voice + VPN** | Cheap calls |

### Local Communication

- **WeChat:** Everyone uses it
- **Phone calls:** Increasingly rare
- **Email:** Not common for personal use
- **SMS:** Only for verification codes

---

*Last updated: February 2026*
