# Beijing Healthcare Guide

> Navigating hospitals, insurance, and medical care in Beijing.

## Overview

Beijing has excellent medical facilities ranging from crowded public hospitals to world-class international clinics. Understanding the system and having proper insurance are essential.

---

## 🏥 Hospital Types

### Public Hospitals

| Level | Quality | Cost | English | Wait Time |
|-------|---------|------|---------|-----------|
| **Grade 3A (三甲)** | Highest | Low | Limited | Long (hours) |
| **Grade 3** | Good | Low | Minimal | Long |
| **Grade 2** | Decent | Very low | None | Moderate |
| **Community** | Basic | Minimal | None | Short |

### Private/International Hospitals

| Type | Quality | Cost | English | Wait Time |
|------|---------|------|---------|-----------|
| **International** | Excellent | Very high | Excellent | Short |
| **Private Chinese** | Good | High | Some | Short |
| **VIP wards (public)** | Good | Medium | Some | Moderate |

---

## 🌟 Recommended Hospitals

### International Hospitals (English-Speaking)

| Hospital | Location | Specialty | Notes |
|----------|----------|-----------|-------|
| **United Family** | Chaoyang, Shunyi | All | Top choice for expats |
| **Beijing United Family** | Jianguomen | Full-service | Central location |
| **Shunyi United Family** | Shunyi | Family focus | Near international schools |
| **Raffles Medical** | Multiple | General | Good for minor issues |
| **International SOS** | Sanlitun area | Emergency, general | 24-hour |
| **Vista Clinic** | Multiple | General | Walk-in friendly |

### Top Public Hospitals

| Hospital | Specialty | Location |
|----------|-----------|----------|
| **Peking Union (协和)** | Overall best | Dongcheng |
| **Beijing Hospital** | General, government | Dongcheng |
| **301 Hospital (军总)** | Military, VIP | Haidian |
| **Chaoyang Hospital** | Emergency | Chaoyang |
| **Tiantan Hospital** | Neurology | Fengtai |
| **Anzhen Hospital** | Cardiac | Chaoyang |
| **Tumor Hospital** | Oncology | Haidian |

### VIP/International Departments

Many top public hospitals have VIP or international wings:

| Hospital | VIP Wing | Notes |
|----------|----------|-------|
| **Peking Union** | International Medical | English, shorter waits |
| **Beijing Hospital** | VIP department | Better facilities |
| **Chaoyang Hospital** | International unit | 24h emergency |

---

## 💉 Common Medical Needs

### General Practice/Family Doctor

| Option | Cost per visit | Notes |
|--------|----------------|-------|
| International clinic | ¥1,000-2,500 | Full service |
| VIP public hospital | ¥300-800 | Good compromise |
| Regular public | ¥50-200 | Long waits, no English |

### Specialist Consultations

| Option | Cost | Booking |
|--------|------|---------|
| International | ¥1,500-3,000 | Direct booking |
| Public VIP | ¥500-1,200 | Online/phone |
| Public regular | ¥100-500 | Very difficult |

### Dental Care

| Clinic Type | Cleaning | Filling | Crown |
|-------------|----------|---------|-------|
| International | ¥800-1,500 | ¥1,000-2,500 | ¥5,000-12,000 |
| Private Chinese | ¥300-600 | ¥500-1,000 | ¥2,000-5,000 |
| Public | ¥100-300 | ¥200-500 | ¥1,000-3,000 |

**Recommended Dental:**
- SDM Dental (international)
- Arrail Dental (good quality)
- United Family Dental

### Eye Care

| Service | Cost Range |
|---------|------------|
| Eye exam (international) | ¥400-800 |
| Eye exam (optical shop) | ¥100-200 |
| Glasses | ¥500-3,000 |
| Contacts (monthly) | ¥200-500 |
| LASIK | ¥15,000-30,000 |

**Recommended:**
- Beijing Tongren Hospital (public, eye specialty)
- C-MER Eye Center (private)

---

## 🏨 Emergency Care

### Emergency Numbers

| Service | Number |
|---------|--------|
| Ambulance | 120 |
| Police | 110 |
| Fire | 119 |

**Note:** 120 operators speak limited English

### Emergency Hospitals

| Hospital | Notes |
|----------|-------|
| **United Family** | 24h, English, expensive |
| **International SOS** | 24h, expat-focused |
| **Chaoyang Hospital** | Good public ER |
| **Peking Union** | Best public, very busy |

### Emergency Protocol

1. **Minor:** Go to international clinic
2. **Serious:** Call 120 or taxi to nearest hospital
3. **Life-threatening:** Call 120, specify English if possible
4. **Contact embassy** if needed

---

## 💊 Pharmacies

### Types

| Type | Hours | English | Prescription |
|------|-------|---------|--------------|
| Chain pharmacies | 8am-10pm | No | Required for Rx |
| 24-hour pharmacies | 24h | No | Required for Rx |
| Hospital pharmacies | Business hours | Some | Best for Rx |
| International clinics | Varies | Yes | Convenient |

### Common Chains

| Chain | Notes |
|-------|-------|
| **Guoda (国大)** | Largest chain |
| **Yifeng (一丰)** | Common |
| **Tongrentang (同仁堂)** | Traditional medicine |

### Medicine Notes

- Many Western medications available
- Prescription rules stricter now
- Some medications (esp. controlled) unavailable
- Bring prescriptions from home with doctor's letter
- Check regulations before bringing medicine into China

---

## 🛡️ Health Insurance

### Types

| Type | Annual Cost | Coverage | Best For |
|------|-------------|----------|----------|
| **International** | ¥30,000-80,000 | Comprehensive | Long-term expats |
| **Local premium** | ¥10,000-30,000 | Good | Cost-conscious expats |
| **Basic local** | ¥3,000-8,000 | Limited | Budget option |
| **Travel insurance** | ¥2,000-5,000 | Short-term | Visitors |

### Major International Insurers

| Insurer | Notes |
|---------|-------|
| **Cigna** | Good network |
| **Bupa** | Global coverage |
| **Allianz** | Comprehensive |
| **Aetna** | Strong US connection |
| **MSH** | Popular in China |

### What to Look For

| Factor | Why Important |
|--------|---------------|
| **Direct billing** | Avoid upfront payment |
| **International hospitals** | United Family coverage |
| **Evacuation coverage** | Critical situations |
| **Pre-existing conditions** | Common exclusion |
| **Maternity** | Often separate rider |
| **Dental/vision** | Usually extra |

### Employer Insurance

Most employers provide:
- Basic coverage
- May only cover public hospitals
- Upgrade options usually available
- Check international clinic coverage

---

## 🤰 Maternity Care

### Options

| Facility | Cost (delivery) | Notes |
|----------|-----------------|-------|
| United Family | ¥80,000-150,000 | Top choice, English |
| American Hospital | ¥60,000-100,000 | Good option |
| Public VIP | ¥20,000-50,000 | Quality varies |
| Public regular | ¥5,000-15,000 | Crowded, no English |

### Prenatal Care

| Service | International | Public VIP |
|---------|---------------|------------|
| Standard checkup | ¥1,500-2,500 | ¥500-1,000 |
| Ultrasound | ¥500-1,000 | ¥200-400 |
| Blood tests | ¥500-1,500 | ¥200-500 |

### What to Expect

- Many expats choose international hospitals
- Book delivery room early (especially United Family)
- Epidural available but not universal
- C-section rates higher in China
- Confinement (坐月子) tradition common

---

## 🧠 Mental Health

### Services Available

| Service | Provider | Cost |
|---------|----------|------|
| Counseling | International clinics | ¥800-1,500/session |
| Psychiatry | International/public | ¥1,000-2,000+ |
| Online therapy | Various platforms | ¥300-800/session |

### Recommended Providers

| Provider | Notes |
|----------|-------|
| United Family | Comprehensive mental health |
| Beijing United Wellness | Psychiatry, therapy |
| Oasis International | Psychology services |
| Various expat therapists | WeChat/private practice |

### Cultural Considerations

- Mental health stigma still exists
- Therapy less common culturally
- Confidentiality important
- Expat-focused providers understand cross-cultural issues

---

## 💊 Traditional Chinese Medicine (TCM)

### Overview

TCM is widely practiced and officially supported:

| Treatment | What It Is |
|-----------|------------|
| **Acupuncture** | Needle therapy |
| **Cupping** | Suction cup therapy |
| **Moxibustion** | Heat therapy |
| **Herbal medicine** | Herbal prescriptions |
| **Tui na** | Medical massage |

### Where to Go

| Type | Notes |
|------|-------|
| **Tongrentang (同仁堂)** | Famous chain, herbal medicine |
| **Hospital TCM depts** | Combined with Western |
| **Private TCM clinics** | Varies in quality |

### Expat Experience

- Many expats find TCM helpful
- Especially for chronic conditions
- Quality varies significantly
- Consider reputable hospitals or referrals

---

## 📋 Navigating Public Hospitals

### Registration Process

1. **Arrive early** — 6-7 AM for popular hospitals
2. **Get registration number** — Machine or window (预约挂号)
3. **Pay registration fee** — ¥50-300 depending on doctor level
4. **Wait to be called** — Follow screen displays
5. **See doctor** — Brief consultation
6. **Get tests/prescriptions** — Pay, then do
7. **Return with results** — Same or next day

### Using Apps

| App | Function |
|-----|----------|
| **114 Guahao (挂号)** | Book appointments |
| **Hospital WeChat** | Individual hospital booking |
| **Alipay/WeChat** | Pay hospital bills |

### Tips

- Expert doctors (专家号) book out fast
- Morning slots are busiest
- Bring someone who speaks Chinese
- Be prepared for direct communication style
- Keep all receipts for insurance

---

## 📱 Health Apps

| App | Use |
|-----|-----|
| **Ping An Good Doctor** | Online consultations |
| **JD Health** | Pharmacy delivery |
| **WeDoctor** | Appointments, consultations |
| **Hospital WeChat accounts** | Booking, results |

---

## 💡 Healthcare Tips

1. **Get insurance first** — Before you need it
2. **Find your hospital** — Know where you'd go in emergency
3. **Keep records** — Medical history, prescriptions
4. **Register with clinic** — Establish relationship
5. **Learn basic medical Chinese** — Or keep phrases saved
6. **Bring medications** — With prescription documentation
7. **International clinic for serious** — Worth the cost
8. **Public for simple issues** — If language not barrier

---

*Last updated: February 2026*
