# Beijing Food Practicalities

## Dining Hours

### Typical Restaurant Hours

| Meal | Time | Notes |
|------|------|-------|
| **Breakfast** | 6:00-10:00 | Street food peaks 7-9 AM |
| **Lunch** | 11:00-14:00 | Busy 12:00-13:00 |
| **Dinner** | 17:00-21:00 | Peak 18:00-20:00 |
| **Late night** | 21:00+ | Limited options except Gui Jie |

### Opening/Closing

- **Most restaurants:** Open 10:30/11:00, close 21:00-22:00
- **Last order:** Usually 30-60 min before closing
- **Lunch break:** Some smaller places close 14:00-17:00
- **24-hour:** Gui Jie, some convenience stores, fast food

### Holiday Hours

- **Chinese New Year:** Many restaurants closed 1-2 weeks
- **National Day (Oct 1-7):** Tourist areas packed, some local places closed
- **Sunday:** Some family restaurants close or limited hours

---

## Alcohol in Beijing

### Drinking Culture

- **Legal age:** 18 (rarely enforced)
- **Availability:** Everywhere — restaurants, bars, convenience stores
- **Pricing:** Much cheaper than Western countries
- **Culture:** Drinking with meals is common, especially business dinners

### Beer

| Brand | Type | Price (¥) | Notes |
|-------|------|----------|-------|
| **Yanjing (燕京)** | Local lager | 5-15 | Beijing's beer |
| **Tsingtao (青岛)** | National brand | 5-15 | Most famous |
| **Snow (雪花)** | Mass market | 3-10 | Cheapest |
| **Craft beers** | Various | 40-80 | Growing scene |

### Craft Beer Scene

| Brewery | Location | Notes |
|---------|----------|-------|
| **Great Leap Brewing** | Multiple | Beijing pioneer |
| **Slow Boat** | Sanlitun | Great taproom |
| **Jing-A** | Multiple | Local favorite |
| **Arrow Factory** | Sanlitun | Cozy |
| **京A (Jing-A)** | Multiple | Bilingual |

### Wine

- **Restaurant markup:** 200-300% typical
- **Bring your own:** Some restaurants allow for corkage fee (¥50-150)
- **Best selection:** Fine dining, hotel restaurants, wine bars
- **Local wine:** Improving but still limited quality

### Baijiu (白酒)

Chinese liquor — very strong (40-60% ABV), acquired taste.

| Type | Notes | When |
|------|-------|------|
| **Maotai (茅台)** | Premium, expensive | Business banquets |
| **Wuliangye (五粮液)** | Top quality | Special occasions |
| **Erguotou (二锅头)** | Local Beijing, cheap | Casual drinking |
| **Red Star (红星)** | Budget | Street food pairing |

**Drinking etiquette:**
- "干杯" (gān bēi) = "empty glass" — finish your drink
- Don't refuse toasts from elders/hosts
- Use both hands when toasting seniors
- It's OK to sip if you explain you can't handle it

---

## Dietary Restrictions

### Vegetarian/Vegan

**Challenge level:** Moderate to difficult

**Problems:**
- "Vegetable" dishes often cooked in meat fat/stock
- Oyster sauce in most stir-fries
- Hidden meat in sauces
- Language barrier in explaining needs

**Solutions:**

| Phrase | Pinyin | Meaning |
|--------|--------|---------|
| 我吃素 | wǒ chī sù | I'm vegetarian |
| 全素 | quán sù | Completely vegetarian |
| 不要肉 | bú yào ròu | No meat |
| 不要鸡蛋 | bú yào jī dàn | No eggs |
| 不要海鲜 | bú yào hǎi xiān | No seafood |
| 纯素/严格素食 | chún sù | Vegan |

**Best options:**
1. Buddhist vegetarian restaurants (素食)
2. Indian restaurants
3. Tribe, Veggie Table (expat vegetarian)
4. King's Joy (Michelin vegetarian)
5. DIY at hot pot (vegetable broth)

### Halal (清真)

**Availability:** Good — large Muslim (Hui) community

**Look for:** 清真 (qīng zhēn) signs
**Best area:** Niujie (Ox Street)
**Common:** Lamb and beef noodle shops, BBQ

### Gluten-Free

**Challenge level:** Very difficult

**Problems:**
- Soy sauce in almost everything
- Wheat noodles are staple
- Cross-contamination common
- Concept less understood

**Solutions:**
- Rice dishes (but check for soy sauce)
- Hot pot (separate broth, careful with sauces)
- Western restaurants more accommodating
- Communicate in writing with Chinese characters

**Phrase:** 我对麸质过敏 (wǒ duì fū zhì guò mǐn) = I'm allergic to gluten

### Common Allergies

| Allergy | Chinese | Pinyin | Challenge |
|---------|---------|--------|-----------|
| Peanuts | 花生 | huā shēng | Common in dishes |
| Tree nuts | 坚果 | jiān guǒ | Moderate |
| Shellfish | 贝类 | bèi lèi | Easier to avoid |
| Soy | 大豆 | dà dòu | Very difficult |
| Eggs | 鸡蛋 | jī dàn | Moderate |

**Tip:** Write your allergy in Chinese characters and show to restaurant staff

---

## Restaurant Etiquette

### Arrival

- **Reservations:** Only needed for popular/fine dining
- **Seating:** Often assigned, especially at popular places
- **Private rooms:** Available at most mid-range+ (for groups)

### Ordering

- **Order for the table:** Not individual portions
- **Tea:** Usually provided free or ¥5-20 per pot
- **Cold dishes (凉菜):** Order first, arrive first
- **Hot dishes (热菜):** Main courses
- **Rice/noodles:** Order at end if needed (filler)
- **Over-ordering:** Normal, shows hospitality

### During the Meal

- **Lazy Susan:** Spin to share dishes
- **Chopstick etiquette:**
  - Don't stick upright in rice (funeral imagery)
  - Don't point with chopsticks
  - Don't cross chopsticks when resting
- **Noise:** Acceptable, shows enjoyment
- **Bones/shells:** Put on plate or table, not back in dish

### Paying

- **Bill request:** "买单" (mǎi dān) or "结账" (jié zhàng)
- **Fighting for bill:** Cultural norm — host should insist
- **Payment:** WeChat/Alipay preferred
- **Tipping:** NOT expected or required
- **Service charge:** Very rare (some hotels add)
- **Splitting:** Becoming common among young people

### Group Dining

- **Host pays:** Traditional — whoever invites pays
- **Business dinners:** Company pays, lots of drinking
- **Family dinners:** Eldest usually pays
- **Friends:** Increasingly common to split

---

## Food Safety

### General Tips

- **Tap water:** DO NOT drink — bottled only
- **Ice:** Usually safe in established restaurants
- **Street food:** Start slow, build tolerance
- **Busy stalls:** High turnover = fresher food
- **Meat:** Make sure it's cooked through
- **Seafood:** Stick to reputable restaurants

### Stomach Adjustment

**First week tips:**
1. Start with milder foods (rice, noodles)
2. Avoid street food first 3-4 days
3. Keep Imodium on hand
4. Stay hydrated
5. Introduce street food gradually

### Food Poisoning Signs

- Symptoms usually appear 2-6 hours after eating
- Most cases are mild and resolve in 24-48 hours
- Seek medical help if: severe symptoms, high fever, blood, dehydration

### Medicine to Have

| Item | Chinese Name | Use |
|------|--------------|-----|
| Imodium | 止泻药 | Diarrhea |
| Pepto-Bismol | 胃药 | Stomach upset |
| Rehydration salts | 口服补液盐 | Dehydration |
| Activated charcoal | 活性炭 | Food poisoning |

---

## Useful Dining Phrases

### Basic

| English | Chinese | Pinyin |
|---------|---------|--------|
| Menu please | 菜单 | cài dān |
| Bill please | 买单/结账 | mǎi dān / jié zhàng |
| I want this | 我要这个 | wǒ yào zhè ge |
| How much? | 多少钱？ | duō shao qián? |
| Delicious! | 好吃！ | hǎo chī! |
| Too spicy | 太辣了 | tài là le |
| Not spicy please | 不要辣 | bú yào là |
| A little spicy OK | 微辣 | wēi là |

### Ordering

| English | Chinese | Pinyin |
|---------|---------|--------|
| Cold dishes | 凉菜 | liáng cài |
| Hot dishes | 热菜 | rè cài |
| Rice | 米饭 | mǐ fàn |
| Noodles | 面条 | miàn tiáo |
| Beer | 啤酒 | pí jiǔ |
| Water | 水 | shuǐ |
| Hot water | 热水 | rè shuǐ |
| Tea | 茶 | chá |

### Dietary

| English | Chinese | Pinyin |
|---------|---------|--------|
| Vegetarian | 我吃素 | wǒ chī sù |
| No meat | 不要肉 | bú yào ròu |
| No pork | 不要猪肉 | bú yào zhū ròu |
| No MSG | 不要味精 | bú yào wèi jīng |
| Allergic to... | 我对...过敏 | wǒ duì...guò mǐn |
| Halal | 清真 | qīng zhēn |

---

## Delivery

### Apps

| App | Notes |
|-----|-------|
| **Meituan (美团)** | Biggest selection |
| **Eleme (饿了么)** | Alibaba-owned, similar |
| **Sherpa's** | English interface, premium |

### How It Works

1. Open app (WeChat/Alipay linked)
2. Browse restaurants (mostly Chinese)
3. Select items, pay via app
4. Delivery: 20-45 minutes typically
5. Driver calls when arriving

### Tips

- **Minimum order:** Often ¥20-30
- **Delivery fee:** ¥3-10
- **Tipping:** Not expected
- **Peak times:** Lunch 11:30-13:00, Dinner 18:00-20:00 (longer waits)
- **Weather:** Rain/snow = long delays
- **Address:** Have Chinese address ready
- **Phone call:** Driver may call — have translation ready

---

## Special Occasions

### Birthday Dinners

- **Noodles:** Traditional — long noodles = long life
- **Cakes:** Western-style now common
- **No candle blowing:** Less common tradition in China

### Business Dining

- **Venue:** Private room (包间 bāo jiān) preferred
- **Seating:** Host faces door, guest of honor to right
- **Toasting:** Expect many toasts, pace yourself
- **Payment:** Host company pays
- **Gifts:** Not food — give before/after meal

### Chinese New Year

- **Dumplings:** Must eat (shape like ancient money)
- **Fish:** Must have, not finish (余 yú = surplus)
- **Restaurant bookings:** Many closed, others packed

---

*Last updated: February 2026*
