# Beijing & Northern Chinese Cuisine Guide

## Peking Duck (北京烤鸭)

### The Signature Dish

Beijing's most famous dish, perfected over 600 years. Whole duck is roasted until skin is crispy, then carved tableside and served with thin pancakes, scallion, cucumber, and sweet bean sauce.

### The Experience

1. Watch the chef carve (skill display)
2. Take a thin pancake
3. Add duck skin/meat
4. Add scallion, cucumber, sauce
5. Roll and eat

### Where to Eat

| Restaurant | Style | Price (whole duck) | Notes |
|------------|-------|-------------------|-------|
| **Da Dong** | Modern, lean | ¥298-398 | Michelin, lean meat style |
| **Siji Minfu (四季民福)** | Traditional | ¥198-298 | Michelin, crispy skin |
| **Quanjude (全聚德)** | Historic | ¥268-368 | 1864 original, touristy |
| **Bianyifang (便宜坊)** | Oldest | ¥228-328 | 1416, closed oven style |
| **Dadong (大董)** | Innovation | ¥368-468 | Art presentation |
| **Jing Yaa Tang** | Fine dining | ¥500-800 | Michelin 2-star |
| **Liqun** | Hole-in-wall | ¥200-280 | Hutong authentic |

### Duck Styles

| Style | Description | Restaurants |
|-------|-------------|-------------|
| **Hanging roast** | Open fire, crispier | Da Dong, Siji Minfu |
| **Closed oven** | Retained heat, juicier | Bianyifang |
| **Lean/modern** | Less fat rendered | Da Dong |
| **Traditional** | More fat, richer | Quanjude |

### Pro Tips
- **Book ahead** for popular restaurants (especially Da Dong, Siji Minfu)
- **Half duck** available at most places if dining alone/small group
- **Full experience:** Skin course → meat course → soup from bones
- **Best value:** Siji Minfu (quality + price)
- **Skip:** Wangfujing "street" duck (tourist trap)

---

## Traditional Beijing Dishes

### Zhajiangmian (炸酱面)
**What:** Beijing's signature noodle — thick wheat noodles with fermented bean paste sauce, minced pork, and julienned vegetables.

**Where:** 
- Old Beijing Noodle King (老北京炸酱面大王)
- Hai Wan Ju (海碗居)
- Any restaurant with "老北京" (Old Beijing) in name

**Price:** ¥25-50

### Jingjiang Rousi (京酱肉丝)
**What:** Shredded pork with sweet bean sauce, served with thin pancakes (like duck).

**Where:** Most Beijing restaurants
**Price:** ¥40-80

### Luzhu Huoshao (卤煮火烧)
**What:** Stewed pork offal (intestines, lung) with bread in rich soup. VERY local.

**Where:**
- Beixinqiao Luzhu (北新桥卤煮)
- Chen's Luzhu (陈记卤煮)

**Price:** ¥30-50
**Note:** Acquired taste — offal and strong flavors

### Douzhi (豆汁)
**What:** Fermented mung bean juice. Sour, pungent, controversial. True Beijing breakfast.

**Where:** Old Beijing breakfast shops, Niujie area
**Price:** ¥5-10
**Note:** Most foreigners hate it. Try once for experience.

### Baodu (爆肚)
**What:** Quick-fried tripe (beef/lamb stomach), dipped in sesame sauce.

**Where:**
- Baodu Feng (爆肚冯) — Michelin Bib Gourmand
- Baodu Man (爆肚满)

**Price:** ¥50-100

### Jianbing (煎饼)
**What:** Beijing breakfast crepe — egg, crispy cracker, scallions, cilantro, sauce, folded.

**Where:** Street vendors, every morning
**Price:** ¥8-15
**Best time:** 7-9 AM (freshest)

### Baozi (包子)
**What:** Steamed filled buns. Beijing style often with pork and scallion.

**Where:**
- Qing Feng Baozi (庆丰包子) — famous chain
- Street vendors
- Any breakfast spot

**Price:** ¥10-25 for portion

---

## Northern Chinese Regional

### Dongbei (Northeastern) 东北菜

**Flavors:** Heavy, hearty, garlic, soy, pickled vegetables

| Dish | Description | Price |
|------|-------------|-------|
| **Guobaorou (锅包肉)** | Sweet-sour crispy pork | ¥50-80 |
| **Disanxian (地三鲜)** | Potato, eggplant, pepper stir-fry | ¥30-50 |
| **Suan cai (酸菜)** | Pickled cabbage with pork | ¥40-60 |
| **Jiaozi (饺子)** | Dongbei-style big dumplings | ¥25-45 |

**Where:** Dongbei restaurants are everywhere in Beijing

### Inner Mongolia (蒙古) Style

**Specialties:** Lamb, lamb, and more lamb

| Dish | Description | Price |
|------|-------------|-------|
| **Shuan yangrou (涮羊肉)** | Beijing lamb hotpot | ¥60-100/person |
| **Kao yangrou (烤羊肉)** | Roasted lamb | ¥80-150 |
| **Lamb skewers** | Street style | ¥3-8 each |

**Where:** Many Mongolian restaurants, especially near Niujie

### Shanxi (山西) Noodles

**Famous for:** Knife-cut noodles, vinegar

| Dish | Description |
|------|-------------|
| **Daoxiaomian (刀削面)** | Knife-shaved noodles |
| **Youmian (莜面)** | Oat noodles |
| **Shanxi vinegar** | Aged black vinegar |

**Where:** Jiumaojiu (九毛九), various Shanxi restaurants

---

## Hotpot Culture

### Beijing Copper Pot (老北京铜锅)

Traditional Beijing hotpot uses:
- Copper pot with chimney
- Sesame paste dipping sauce
- Thin-sliced lamb
- Vegetables, tofu

**Key experience:** Different from Sichuan — not spicy, focused on lamb quality

### Where to Eat Beijing Hotpot

| Restaurant | Style | Price/person | Notes |
|------------|-------|--------------|-------|
| **Dong Lai Shun (东来顺)** | Classic | ¥80-150 | 1903 original |
| **Nan Men Shuan Rou (南门涮肉)** | Traditional | ¥70-120 | Authentic |
| **Ju Bao Yuan (聚宝源)** | Local | ¥60-100 | Always packed |

### Sichuan Hotpot in Beijing

| Restaurant | Style | Price/person | Notes |
|------------|-------|--------------|-------|
| **Haidilao (海底捞)** | Service legend | ¥100-200 | Free services, long waits |
| **Xiaolongkan (小龙坎)** | Traditional | ¥80-150 | Chengdu original |
| **Shoo Loong Kan** | Modern | ¥100-180 | Trendy |

### Haidilao Experience

Famous for:
- Free snacks, drinks while waiting
- Nail services, phone covers
- Hand-pulled noodle show at table
- Birthday celebrations
- Extreme service attention

**Tip:** Download Haidilao app to queue remotely

---

## Street Food Guide

### Essential Beijing Street Foods

| Food | What | Where | Price |
|------|------|-------|-------|
| **Jianbing** | Breakfast crepe | Morning vendors | ¥8-15 |
| **Chuan'r (串儿)** | Skewers (lamb, beef, vegetables) | Night markets, Gui Jie | ¥3-10/skewer |
| **Bingtanghulu (冰糖葫芦)** | Candied hawthorn | Winter street vendors | ¥10-15 |
| **Roujiamo (肉夹馍)** | "Chinese hamburger" | Xi'an food shops | ¥10-20 |
| **Malatang (麻辣烫)** | Spicy broth with self-selected items | Everywhere | ¥20-50 |
| **Liangpi (凉皮)** | Cold noodle salad | Shaanxi shops | ¥12-25 |

### Night Food Streets

| Street | What | Location |
|--------|------|----------|
| **Gui Jie (簋街)** | 24-hour crayfish, skewers | Dongzhimen |
| **Donghuamen** | Tourist snacks (skip the scorpions) | Near Wangfujing |
| **Niujie (牛街)** | Halal street food | Xicheng |
| **Wangjing Korean** | Korean fried chicken, BBQ | Wangjing |

### Street Food Tips

- **Morning:** Best time for jianbing (7-9 AM)
- **Night:** Skewers and BBQ come alive after 9 PM
- **WeChat/Alipay:** Most street vendors accept mobile payment
- **Hygiene:** Start with busy stalls (high turnover = fresher)
- **Stomach adjustment:** Give yourself 2-3 days for local bacteria

---

## Traditional Beijing Breakfast

### The Classics

| Item | What | Price |
|------|------|-------|
| **Jianbing** | Savory crepe | ¥8-15 |
| **Youtiao (油条)** | Fried dough stick | ¥2-5 |
| **Doujiang (豆浆)** | Soy milk (sweet or savory) | ¥3-6 |
| **Douzhi (豆汁)** | Fermented mung bean juice | ¥5-10 |
| **Jiaoquan (焦圈)** | Crispy fried ring | ¥2-5 |
| **Zhou (粥)** | Congee/porridge | ¥5-15 |

### Where to Find

- **Hotel breakfast:** Usually have Chinese options
- **Street vendors:** 6-9 AM, look for steam
- **Yonghe Dawang (永和大王):** Chain, reliable
- **Local breakfast shops:** Follow the crowds

---

## Dining Customs

### At the Table

- **Communal eating:** Dishes in center, everyone shares
- **Lazy Susan:** Spin to access dishes
- **Rice comes last:** It's filler, not main course
- **Bones on table:** Normal to put bones on plate or table
- **Toast with "干杯" (gān bēi):** Means "empty glass" — finish your drink!
- **Never stick chopsticks upright:** Resembles funeral incense

### Ordering Tips

- **Order for the table:** Not individual plates
- **Balance:** Mix of meat, vegetables, starches
- **Rice/noodles:** Order at end if still hungry
- **Over-ordering:** Normal and hospitable
- **Leftovers:** Take home is common

---

*Last updated: February 2026*
