# Beijing Education Guide

> Schools, universities, and education options for expat families.

## Overview

Beijing has extensive education options from international schools to bilingual programs. Choice depends on budget, child's age, language goals, and length of stay.

---

## 🏫 School Types

### Categories

| Type | Language | Curriculum | Cost (¥/year) | For Whom |
|------|----------|------------|---------------|----------|
| **International** | English | IB/US/UK | 200,000-350,000 | Expat families |
| **Bilingual** | Chinese+English | Mixed | 100,000-250,000 | Long-term expats |
| **Local International Dept** | English+Chinese | Chinese core | 80,000-150,000 | Budget-conscious |
| **Local Public** | Chinese | Chinese | Free-20,000 | Permanent residents |
| **Local Private** | Chinese | Chinese | 30,000-100,000 | Local families |

---

## 🌍 International Schools

### Top-Tier International Schools

| School | Curriculum | Location | Fees (¥/year) | Notes |
|--------|------------|----------|---------------|-------|
| **International School of Beijing (ISB)** | IB, US | Shunyi | 260,000-320,000 | Top choice, huge campus |
| **Western Academy of Beijing (WAB)** | IB | Chaoyang | 250,000-310,000 | Strong IB, established |
| **British School of Beijing (BSB)** | UK, IGCSE, IB | Shunyi | 230,000-300,000 | British curriculum |
| **Dulwich College Beijing** | UK, IGCSE, IB | Shunyi | 240,000-290,000 | Arts, drama strong |
| **Canadian International School (CISB)** | Canadian, IB | Chaoyang | 180,000-240,000 | Good value |
| **Beijing City International School (BCIS)** | IB | Chaoyang | 200,000-260,000 | Central location |

### Application Process

| Step | Timeline |
|------|----------|
| Research schools | 12+ months before |
| School visits/tours | 6-12 months before |
| Application submission | 6-9 months before |
| Assessments/interviews | 4-6 months before |
| Offer/acceptance | 3-6 months before |
| Enrollment | Summer before |

### What Schools Look For

| Factor | Notes |
|--------|-------|
| **Academic records** | Transcripts, report cards |
| **Assessments** | Entry tests (varies by age) |
| **English proficiency** | Critical for most |
| **References** | From current school |
| **Passport** | Foreign passport required for most |

### Additional Costs

| Item | Cost (¥/year) |
|------|---------------|
| School bus | 10,000-25,000 |
| Lunch program | 5,000-15,000 |
| Uniforms | 3,000-8,000 |
| Books/materials | 2,000-8,000 |
| Field trips | 3,000-10,000 |
| Extracurriculars | 5,000-30,000 |
| **Total additional** | **25,000-90,000** |

---

## 🌐 Bilingual Schools

### Top Bilingual Options

| School | Style | Location | Fees (¥/year) |
|--------|-------|----------|---------------|
| **Keystone Academy** | Boarding option, Chinese values | Shunyi | 280,000-320,000 |
| **Daystar Academy** | Progressive, bilingual | Multiple | 150,000-200,000 |
| **YCIS Beijing** | Hong Kong style | Haidian | 180,000-250,000 |
| **Ivy Academy** | Bilingual, arts | Chaoyang | 140,000-180,000 |
| **3e International** | Early years focus | Chaoyang | 180,000-220,000 |
| **House of Knowledge** | Reggio approach | Sanlitun | 170,000-210,000 |

### Bilingual Considerations

| Pro | Con |
|-----|-----|
| Child learns Chinese | May not reach native level in either |
| Local integration | Can be academically challenging |
| Usually cheaper | Curriculum may differ from home |
| Cultural understanding | Less recognized internationally |

---

## 👶 Early Childhood (0-6)

### Types

| Type | Age | Cost (¥/month) |
|------|-----|----------------|
| **Ayi (nanny)** | 0-3 | 5,000-10,000 |
| **Chinese kindergarten** | 3-6 | 2,000-5,000 |
| **Bilingual kindergarten** | 2-6 | 8,000-15,000 |
| **International preschool** | 2-6 | 12,000-25,000 |

### Recommended Early Years

| School | Age | Notes |
|--------|-----|-------|
| **3e International** | 2-6 | Strong program |
| **House of Knowledge** | 2-6 | Reggio, creative |
| **Montessori schools** | 2-6 | Various options |
| **International school EY** | 3-5 | ISB, WAB, etc. |

---

## 🎓 Higher Education

### International Students in China

| Type | Program | Notes |
|------|---------|-------|
| **Degree programs** | Chinese universities | Increasing quality |
| **Chinese language** | Language programs | Very common |
| **Study abroad** | Home country program | Semester/year |

### Top Beijing Universities

| University | Ranking | Notes |
|------------|---------|-------|
| **Tsinghua** | #1 China | "MIT of China" |
| **Peking University (PKU)** | #2 China | Liberal arts, social science |
| **Renmin University** | Top 10 | Social sciences |
| **BLCU** | — | Chinese language learning |
| **Beihang** | Top 20 | Aerospace, engineering |

### Tuition (International Students)

| Program | Cost (¥/year) |
|---------|---------------|
| Chinese language | 20,000-35,000 |
| Undergraduate | 25,000-50,000 |
| Graduate | 30,000-60,000 |
| MBA programs | 100,000-300,000 |

### Scholarships

| Scholarship | Coverage |
|-------------|----------|
| **CSC (Chinese Government)** | Full tuition + stipend |
| **Confucius Institute** | Various levels |
| **University-specific** | Partial to full |
| **Beijing Municipal** | Various programs |

---

## 📚 Curriculum Comparison

### International Baccalaureate (IB)

| Stage | Age | Focus |
|-------|-----|-------|
| PYP | 3-12 | Inquiry-based learning |
| MYP | 11-16 | Interdisciplinary |
| DP | 16-19 | University preparation |

**Pros:** Globally recognized, critical thinking
**Cons:** Rigorous, may not suit all students

### British Curriculum

| Stage | Age | Exams |
|-------|-----|-------|
| Primary | 5-11 | Key Stage assessments |
| Secondary | 11-16 | IGCSEs |
| Sixth Form | 16-18 | A-Levels or IB |

**Pros:** Structured, globally recognized
**Cons:** Exam-focused, less flexibility

### American Curriculum

| Stage | Age | Features |
|-------|-----|----------|
| Elementary | 5-11 | Foundational |
| Middle School | 11-14 | Exploratory |
| High School | 14-18 | AP courses, college prep |

**Pros:** Flexibility, extracurricular focus
**Cons:** Less internationally recognized than IB

---

## 🏠 School Location Considerations

### Shunyi Schools (Most International)

| School | Drive from Shunyi center |
|--------|------------------------|
| ISB | 10-15 min |
| BSB | 10-15 min |
| Dulwich | 15-20 min |
| WAB | 20-25 min |

### Central Beijing Schools

| School | Location |
|--------|----------|
| WAB | Chaoyang (near Lido) |
| BCIS | Chaoyang Park area |
| CISB | Chaoyang |
| 3e | Chaoyang |

### Commute Considerations

- Most international schools in Shunyi
- Central living = long school commute
- Shunyi living = long city commute
- School buses available (¥10,000-25,000/year)
- Many families choose home location based on school

---

## 📊 Decision Framework

### By Budget

| Budget (¥/year) | Options |
|-----------------|---------|
| 100,000-150,000 | Bilingual, local international dept |
| 150,000-250,000 | Mid-tier international, good bilingual |
| 250,000+ | Top-tier international |

### By Length of Stay

| Duration | Recommendation |
|----------|----------------|
| 1-2 years | International school (smooth transition) |
| 3-5 years | International or bilingual (Chinese exposure) |
| 5+ years | Consider bilingual (deeper integration) |

### By Age

| Age | Considerations |
|-----|----------------|
| 0-5 | Bilingual easier, language acquisition natural |
| 6-10 | Can adapt to either |
| 11+ | International usually better (curriculum continuity) |
| 15+ | Critical for university prep, stick with known curriculum |

---

## 📝 Application Tips

1. **Start early** — 12+ months for top schools
2. **Visit in person** — Tours reveal a lot
3. **Check accreditation** — WASC, CIS, NEASC
4. **Talk to current parents** — Unfiltered perspective
5. **Understand waitlists** — Popular schools have them
6. **Consider siblings** — Priority policies vary
7. **Budget realistically** — Include all costs
8. **Think about transition** — Leaving Beijing eventually

---

## 🔗 Resources

| Resource | Use |
|----------|-----|
| **The Beijinger School Guide** | Annual directory |
| **Beijing Kids Magazine** | Family resources |
| **School websites** | Direct information |
| **Expat parent groups** | WeChat, Facebook |

---

## 💡 Common Mistakes

1. **Choosing only by name** — Fit matters more than prestige
2. **Ignoring location** — Commute affects family life
3. **Underestimating costs** — Budget for extras
4. **Late applications** — Waitlists are real
5. **Not considering transitions** — Where will child go next?
6. **Ignoring child's input** — Especially for older kids

---

*Last updated: February 2026*
