# Beijing Driving & Car Ownership Guide

> Everything you need to know about driving in Beijing — spoiler: most expats don't.

## Overview

Driving in Beijing is challenging due to:
- **License plate lottery** — Can take years to get Beijing plates
- **Horrific traffic** — Some of the worst in Asia
- **Aggressive driving culture** — Different rules than the West
- **Excellent alternatives** — Subway + DiDi work well

**Recommendation:** Unless you live in Shunyi or outer suburbs, don't drive.

---

## 🚗 The License Plate System

### Beijing Plate Lottery

Beijing restricts vehicle registration through a lottery system:

| Aspect | Reality |
|--------|---------|
| **Odds** | ~1 in 3,000+ per application |
| **Waiting time** | 5-10+ years for many |
| **Applications** | Monthly, online |
| **Requirements** | Beijing residence permit, valid driver's license |

### Electric Vehicles (EV)

| Aspect | Reality |
|--------|---------|
| **Separate lottery** | Better odds (~1 in 50-100) |
| **No driving restrictions** | Can drive any day |
| **Incentives** | Government subsidies |
| **Charging** | Infrastructure growing |

### New Energy Vehicles (NEV)

| Type | Plate Color | Restrictions |
|------|-------------|--------------|
| Pure electric (EV) | Green | None |
| Plug-in hybrid | Green | None |
| Regular gas/diesel | Blue | Day restrictions |

### Provincial Plates

Using out-of-province plates in Beijing:

| Restriction | Details |
|-------------|---------|
| **5th Ring Road+** | Banned 7AM-8PM weekdays |
| **Some roads** | Additional restrictions |
| **Fine** | ¥100 + 3 points per violation |
| **Workaround** | Some expats use, but inconvenient |

---

## 🪪 Getting a Driver's License

### Who Needs One?

| Situation | License Needed |
|-----------|----------------|
| Driving in China | Chinese driver's license |
| Renting a car | Chinese license |
| DiDi driver (not recommended) | Chinese license |
| Hiring a driver | Not you, driver has license |

### License Exchange (Foreign → Chinese)

**Eligible Countries (No Driving Test):**
- Most EU countries
- USA (some states)
- Japan, Korea
- Australia, New Zealand
- Many others

**Process:**

| Step | Details | Time |
|------|---------|------|
| 1. Medical exam | Eye test, basic physical | ¥50-100 |
| 2. Translate license | Official translation | ¥100-200 |
| 3. Theory test | Chinese traffic rules | 1 hour |
| 4. Apply at DMV | Vehicle Management Office | 2-4 hours |
| 5. Receive license | Issued same day | — |

**Required Documents:**
- Passport + residence permit
- Original foreign license
- Official translation
- Medical certificate
- Photos (white background)
- Temporary residence proof

### Theory Test

| Aspect | Details |
|--------|---------|
| **Questions** | 100 multiple choice |
| **Passing score** | 90/100 |
| **Language** | Chinese or English |
| **Content** | Traffic rules, signs, laws |
| **Tips** | Download practice apps |

**Practice Apps:**
- 驾考宝典 (Chinese)
- Various English apps available

### If Test Required

Some nationalities must take full driving test:

| Test | Cost | Notes |
|------|------|-------|
| Theory | Included | Same as above |
| Road test | ¥200-500 | Course driving |
| Total time | 1-3 months | Multiple attempts may be needed |

---

## 🚦 Traffic Rules & Culture

### Key Rules

| Rule | Details |
|------|---------|
| **Driving side** | Right side |
| **Speed limits** | City: 40-60 km/h, Highways: 100-120 km/h |
| **Alcohol** | 0.02% BAC (very strict) |
| **Red lights** | Absolutely stop (cameras everywhere) |
| **Right on red** | Generally allowed, but yield |
| **Seat belts** | Required front, technically all |
| **Phone use** | Illegal, fines |

### Reality vs Rules

| Rule | Reality |
|------|---------|
| Speed limits | Commonly exceeded |
| Lane discipline | Fluid interpretation |
| Turn signals | Optional for many |
| Pedestrian right of way | Don't count on it |
| Honking | Constant communication |

### Driving Hazards

| Hazard | Notes |
|--------|-------|
| **Electric scooters** | Everywhere, unpredictable |
| **Pedestrians** | May cross unexpectedly |
| **Buses** | Pull out suddenly |
| **Aggressive merging** | Normal here |
| **Tailgating** | Very common |
| **Wrong-way driving** | On side roads, happens |

### Safety Tips

1. **Assume everyone will cut you off**
2. **Watch for scooters** — Silent and fast
3. **Be aggressive but not angry**
4. **Use horn liberally** — It's communication, not aggression
5. **Dashcam essential** — For disputes
6. **GPS always** — Roads change frequently

---

## 🅿️ Parking

### Costs

| Location | Cost |
|----------|------|
| **Street parking** | ¥2-10/hour |
| **Mall parking** | ¥2-10/hour (often free with purchase) |
| **Office building** | ¥500-2,000/month |
| **Residential** | ¥300-1,500/month |
| **CBD premium** | ¥2,000-5,000/month |

### Finding Parking

| App | Notes |
|-----|-------|
| **Amap (高德)** | Shows parking lots |
| **Baidu Maps** | Parking info |
| **ETCP** | Parking payment app |

### Parking Tips

- Always pay via app or machine
- Residential spots often sold separately from rent
- CBD parking is nightmare
- Some malls validate with purchase

---

## 💰 Car Ownership Costs

### Purchase

| Type | Price Range (¥) |
|------|-----------------|
| **Economy** | 80,000-150,000 |
| **Mid-range** | 150,000-300,000 |
| **Luxury** | 300,000-800,000+ |
| **Electric** | 150,000-500,000 |
| **Used** | 50,000-200,000 |

### Annual Costs

| Expense | Annual Cost (¥) |
|---------|-----------------|
| **Insurance** | 3,000-10,000 |
| **Road tax** | 300-660 |
| **Maintenance** | 2,000-5,000 |
| **Gas/charging** | 6,000-15,000 |
| **Parking** | 6,000-24,000 |
| **Tolls** | 1,000-5,000 |
| **Total** | **18,000-60,000+** |

### Electric vs Gas

| Factor | EV | Gas |
|--------|-------|-----|
| Plate lottery | Better odds | Terrible odds |
| Driving restrictions | None | One day/week banned |
| Fuel cost | ¥0.5-1/km | ¥0.8-1.5/km |
| Charging | Growing network | Gas everywhere |
| Resale value | Uncertain | Stable |

---

## 🚐 Alternatives to Driving

### DiDi

**Why DiDi often beats driving:**
- No parking hassle
- No plate lottery
- Cost comparable to car ownership
- Someone else deals with traffic

**Monthly DiDi budget:** ¥1,000-3,000 for regular use

### Hiring a Driver

| Arrangement | Monthly (¥) | Notes |
|-------------|-------------|-------|
| **Full-time personal** | 7,000-12,000 | Your car |
| **Driver + car rental** | 12,000-20,000 | Everything included |
| **Part-time** | 4,000-7,000 | Limited hours |

**Common in:** Shunyi expat families, executives

### Car Rental

| Type | Daily (¥) | Notes |
|------|-----------|-------|
| Economy | 150-250 | Basic sedan |
| Mid-range | 250-400 | Better cars |
| Luxury | 500-1,500 | Executive vehicles |
| SUV | 300-600 | For trips |

**Rental companies:** 神州租车, 一嗨租车, Avis, Hertz

---

## 🗺️ Navigation

### Apps

| App | Notes |
|-----|-------|
| **Amap (高德地图)** | Best real-time traffic |
| **Baidu Maps** | Good alternative |
| **Apple Maps** | Limited in China |
| **Google Maps** | Doesn't work properly |

### GPS Tips

- Always check traffic before departing
- Alternative routes often better
- Real-time updates essential
- Construction changes routes frequently

---

## 🚗 Road Trips from Beijing

### Popular Destinations

| Destination | Distance | Time | Notes |
|-------------|----------|------|-------|
| **Great Wall (Mutianyu)** | 70km | 1.5h | Good day trip |
| **Tianjin** | 130km | 1.5h | Coastal city |
| **Chengde** | 230km | 3h | Imperial resort |
| **Pingyao** | 500km | 5h | Ancient city |
| **Qingdao** | 700km | 7h | Beach, beer |
| **Inner Mongolia** | 400km | 5h | Grasslands |

### Highway Driving

| Aspect | Details |
|--------|---------|
| **Tolls** | Electronic (ETC) or manual |
| **Service areas** | Every 50-100km |
| **Speed** | 100-120 km/h limit |
| **Fuel** | Petrol stations common |
| **EV charging** | Growing network |

### ETC (Electronic Toll Collection)

- Get ETC device from bank
- Links to bank account
- 5% discount typically
- Much faster than cash lanes

---

## 📊 Should You Drive in Beijing?

### Drive If:

- ✅ Live in Shunyi or outer suburbs
- ✅ Family with kids in different locations
- ✅ Already have Beijing plates
- ✅ Frequent trips outside city
- ✅ Company provides car + driver

### Don't Drive If:

- ❌ Live in central Beijing
- ❌ Work near subway
- ❌ Don't have Beijing plates
- ❌ Low frustration tolerance
- ❌ Not confident in aggressive traffic

### The Math

| Scenario | Monthly Cost |
|----------|--------------|
| Own car (central) | ¥3,500-6,000 (+ stress + time) |
| DiDi heavy use | ¥2,000-4,000 (no hassle) |
| Subway + DiDi | ¥500-1,500 (most efficient) |

---

## 💡 Key Takeaways

1. **License plate lottery makes car ownership difficult**
2. **Consider EV for better odds and no restrictions**
3. **DiDi + subway works for most expats**
4. **If you must drive, expect stress**
5. **Shunyi residents often need cars**
6. **Hiring a driver is common for families**
7. **Road trips require planning (tolls, plates, traffic)**
8. **Dashcam is essential**

---

*Last updated: February 2026*
