# Beijing Culture & Customs Guide

> Understanding Chinese culture, social norms, and daily etiquette for life in Beijing.

## Overview

Beijing is China's political and cultural heart, with 3,000+ years of history. Understanding cultural context makes life smoother and relationships deeper. This guide covers essential cultural knowledge for expats.

---

## 🗣️ Language

### The Reality

| Situation | English Level |
|-----------|---------------|
| International hotels/restaurants | Good |
| Sanlitun area | Moderate |
| Subway/public transport | Signs yes, staff minimal |
| Local restaurants | Very limited |
| Hospitals | VIP sections only |
| Government offices | Almost none |
| Taxi drivers | None |

### Mandarin Basics

Beijing speaks Mandarin (普通话 Pǔtōnghuà) with a distinctive "Beijing accent" — adding "r" sounds (儿化 érhuà).

| English | Standard | Beijing Accent |
|---------|----------|----------------|
| Where? | 哪里 nǎlǐ | 哪儿 nǎr |
| A little | 一点 yīdiǎn | 一点儿 yīdiǎnr |
| Here | 这里 zhèlǐ | 这儿 zhèr |

### Essential Phrases

| English | Chinese | Pinyin |
|---------|---------|--------|
| Hello | 你好 | nǐ hǎo |
| Thank you | 谢谢 | xiè xie |
| Sorry/Excuse me | 不好意思 | bù hǎo yì si |
| I don't understand | 我不懂 | wǒ bù dǒng |
| How much? | 多少钱？ | duō shao qián? |
| Too expensive | 太贵了 | tài guì le |
| Where is...? | ...在哪儿？ | ...zài nǎr? |
| I want this | 我要这个 | wǒ yào zhè ge |
| No need | 不用了 | bù yòng le |
| Can you help me? | 你能帮我吗？ | nǐ néng bāng wǒ ma? |

### Learning Resources

| Resource | Notes |
|----------|-------|
| **HelloChinese** | App, gamified |
| **Du Chinese** | Reading practice |
| **ChineseClass101** | Audio lessons |
| **Pleco** | Dictionary (essential) |
| **Language exchange** | WeChat groups, Tandem |
| **Local tutors** | ¥100-300/hour |
| **University courses** | BLCU, Tsinghua |

---

## 🤝 Social Etiquette

### Face (面子 Miànzi)

The most important cultural concept:

| Concept | Meaning |
|---------|---------|
| **Give face** | Show respect, praise publicly |
| **Lose face** | Public embarrassment, criticism |
| **Save face** | Allow graceful exit from awkward situations |

**Do:**
- Praise publicly, criticize privately
- Accept small gifts graciously
- Let others save face in disagreements

**Don't:**
- Publicly correct or criticize
- Argue aggressively in public
- Force yes/no answers (allow ambiguity)

### Relationships (关系 Guānxi)

Relationships drive Chinese business and social life:

| Principle | Application |
|-----------|-------------|
| **Build trust slowly** | Multiple meetings before business |
| **Reciprocity** | Favors create obligations |
| **Network matters** | Introductions carry weight |
| **Long-term view** | Relationships outlast transactions |

### Gift Giving

| Situation | Appropriate Gift | Avoid |
|-----------|------------------|-------|
| Business meeting | Quality items from home country | Clocks (death symbol) |
| Home visit | Fruit, wine, chocolate | Sharp objects (cut ties) |
| Chinese New Year | Red envelopes (money) | White/black wrapping |
| Thank you | Tea, specialty foods | Green hats (infidelity) |

**Gift Etiquette:**
- Offer with two hands
- May be refused initially (offer 2-3 times)
- Don't open in front of giver (unless asked)
- Red/gold wrapping preferred

### Business Cards

Still important in Chinese business:

| Rule | Why |
|------|-----|
| Offer with two hands | Shows respect |
| Receive with two hands | Acknowledgment |
| Study it briefly | Shows interest |
| Don't write on it | Disrespectful |
| Place carefully | Not in back pocket |

---

## 🍽️ Dining Etiquette

### Table Manners

| Do | Don't |
|----|-------|
| Wait to be seated | Sit at head of table (reserved for host/elder) |
| Let host order | Order most expensive dish |
| Toast with two hands | Start drinking before host |
| Try everything offered | Refuse food completely |
| Leave some food | Finish everything (implies not enough) |

### Drinking Culture

| Custom | Meaning |
|--------|---------|
| **干杯 (gān bēi)** | "Empty glass" — finish your drink |
| **随意 (suí yì)** | "As you wish" — sip is OK |
| **Toast lower** | Your glass rim below elder's = respect |
| **Refill others** | Before filling your own |

**Dealing with Pressure:**
- Say you're driving (开车)
- Health reasons (身体不好)
- Toast with tea or soda (accepted)
- Take small sips (don't drain every time)

### Chopstick Rules

| Don't | Why |
|-------|-----|
| Stick chopsticks upright | Resembles funeral incense |
| Point with chopsticks | Rude |
| Spear food | Shows poor skill |
| Pass food chopstick-to-chopstick | Funeral ritual |

---

## 📱 Digital Culture

### WeChat (微信) Is Everything

| Use | Notes |
|-----|-------|
| Messaging | Default communication |
| Payments | Pay for everything |
| Moments | Social media feed |
| Mini-programs | Apps within app |
| Groups | Social and professional |
| Business | Contacts, networking |

### WeChat Etiquette

| Do | Don't |
|----|-------|
| Respond to messages | Leave voice messages for strangers |
| Share Moments appropriately | Spam with sales |
| Use appropriate emoji | Over-use Western sarcasm |
| Add contacts properly | Add without introduction |

### Online Communication

| Platform | Tone |
|----------|------|
| **WeChat work** | More formal |
| **WeChat personal** | Casual, emoji OK |
| **Email** | Formal, often CC everyone |
| **Phone** | Direct, quick decisions |

---

## 🎌 Cultural Calendar

### Major Holidays

| Holiday | When | Notes |
|---------|------|-------|
| **Chinese New Year (春节)** | Jan/Feb (lunar) | 7-15 days off, travel chaos |
| **Qingming (清明)** | Early April | Tomb sweeping, 3 days |
| **Labor Day (劳动节)** | May 1-5 | 5 days off |
| **Dragon Boat (端午)** | June (lunar) | 3 days |
| **Mid-Autumn (中秋)** | Sept/Oct (lunar) | 3 days, mooncakes |
| **National Day (国庆)** | Oct 1-7 | 7 days, "Golden Week" |

### Holiday Impacts

| Holiday | Impact |
|---------|--------|
| Chinese New Year | Everything closed 1-2 weeks, travel impossible |
| Golden Week | Tourist sites packed, prices up |
| Other holidays | Some closures, manageable |

### Lucky/Unlucky Numbers

| Number | Meaning | Because |
|--------|---------|---------|
| **8** | Very lucky | Sounds like "wealth" (发) |
| **6** | Lucky | Sounds like "smooth" (顺) |
| **9** | Lucky | Sounds like "long-lasting" (久) |
| **4** | Unlucky | Sounds like "death" (死) |
| **7** | Neutral/unlucky | Associated with ghosts |

---

## 🏛️ Social Hierarchy

### Age and Seniority

| Principle | Application |
|-----------|-------------|
| **Respect elders** | Defer to older people |
| **Titles matter** | Use professional titles |
| **Seniority in business** | Acknowledge rank |

### Addressing People

| Relationship | Term |
|--------------|------|
| Older man | 大哥 (dà gē) - big brother |
| Older woman | 大姐 (dà jiě) - big sister |
| Much older | 叔叔/阿姨 (shūshu/āyí) - uncle/auntie |
| Business (male) | [Name] 先生 (xiānsheng) - Mr. |
| Business (female) | [Name] 女士 (nǚshì) - Ms. |
| Boss | [Title] 总 (zǒng) - Director/General |

---

## 🚫 Sensitive Topics

### Topics to Avoid

| Topic | Why |
|-------|-----|
| Taiwan | Politically sensitive |
| Tibet | Politically sensitive |
| Tiananmen | Censored, risky |
| Xinjiang | Politically sensitive |
| Hong Kong protests | Sensitive |
| Political criticism | Can have consequences |
| Comparing to Japan | Historical tensions |

### Safe Conversations

| Topic | Notes |
|-------|-------|
| Food | Always welcome |
| Travel in China | Show interest in culture |
| Technology | Chinese tech achievements |
| Family | Appropriate, shows warmth |
| Hobbies | Common ground |

---

## 🎭 Social Norms

### Public Behavior

| Acceptable | Surprising to Westerners |
|------------|-------------------------|
| Spitting | Common (decreasing) |
| Smoking indoors | Still happens |
| Loud conversations | Normal volume |
| Staring at foreigners | Curiosity, not hostility |
| Cutting lines | Happens, frustrating |
| Asking personal questions | Age, salary, marriage status |

### Personal Questions

Chinese people may ask:
- How old are you?
- Are you married?
- Do you have children?
- How much do you earn?
- Why don't you have children?

**These are friendly, not intrusive. Brief, vague answers are fine.**

---

## 🏠 Daily Life Culture

### Service Culture

| Aspect | Reality |
|--------|---------|
| Customer service | Variable, improving |
| Delivery speed | Incredibly fast |
| Convenience | Everything delivered |
| Flexibility | Rules can be negotiated |

### Time Culture

| Aspect | Expectation |
|--------|-------------|
| Business meetings | On time or early |
| Social events | Slight lateness OK |
| Dinner invitations | 10-15 min late common |
| Government offices | Arrive early, expect waits |

---

## 💡 Cultural Tips

1. **Learn to say "差不多" (chà bù duō)** — "more or less" — embraces Chinese ambiguity
2. **Accept that "no" is rarely direct** — Read context
3. **Join activities** — Colleagues appreciate inclusion
4. **Show interest in Chinese culture** — Genuine curiosity is valued
5. **Be patient with bureaucracy** — Frustration doesn't help
6. **Understand indirect communication** — What's not said matters
7. **Reciprocate hospitality** — If hosted, host back
8. **Learn about Chinese history** — Shows respect and opens conversations

---

*Last updated: February 2026*
