# Beijing Cost of Living Guide 2025-2026

> Last updated: February 2026 | Currency: ¥1 CNY ≈ $0.14 USD

## Overview

Beijing is China's most expensive city alongside Shanghai, but still significantly cheaper than London, NYC, or Singapore. Your experience varies dramatically based on lifestyle — live local and it's cheap; live expat and costs approach Western levels.

### Quick Summary

| Profile | Monthly Cost (¥) | Monthly (USD) |
|---------|-----------------|---------------|
| **Single (budget)** | 8,000-12,000 | $1,100-1,700 |
| **Single (comfortable)** | 15,000-25,000 | $2,100-3,500 |
| **Couple (comfortable)** | 20,000-35,000 | $2,800-4,900 |
| **Family of 4 (expat)** | 50,000-100,000+ | $7,000-14,000+ |
| **Family (Shunyi, int'l school)** | 80,000-150,000+ | $11,000-21,000+ |

---

## 🏠 Housing (Biggest Expense: 30-50% of budget)

### Rental Prices (Monthly)

| Area | Studio (¥) | 1BR (¥) | 2BR (¥) | 3BR (¥) |
|------|------------|---------|---------|---------|
| **CBD** | 7,000-10,000 | 10,000-18,000 | 15,000-30,000 | 25,000-45,000 |
| **Sanlitun** | 6,000-9,000 | 9,000-15,000 | 14,000-25,000 | 22,000-40,000 |
| **Zhongguancun** | 4,500-7,000 | 6,000-10,000 | 9,000-16,000 | 12,000-22,000 |
| **Dongcheng** | 4,000-6,500 | 6,000-10,000 | 9,000-16,000 | 14,000-25,000 |
| **Wudaokou** | 3,500-5,500 | 5,000-8,000 | 7,000-12,000 | 10,000-18,000 |
| **Tongzhou** | 3,000-4,500 | 4,000-6,500 | 5,500-9,000 | 7,000-12,000 |
| **Shunyi villa** | — | — | 18,000-30,000 | 35,000-80,000+ |

### Additional Housing Costs

| Expense | Cost | Notes |
|---------|------|-------|
| **Agency fee** | 1 month rent | Negotiable, sometimes 0.5 |
| **Deposit** | 1-3 months | Usually 2 months |
| **Property management** | ¥200-500/month | Included in some buildings |
| **Key money** | Rare | Not common in Beijing |

### Utilities (Monthly)

| Utility | Cost (¥) | Notes |
|---------|----------|-------|
| **Electricity** | 100-300 | AC usage in summer/winter |
| **Gas** | 50-100 | Cooking, water heating |
| **Water** | 30-80 | Cheap |
| **Internet** | 100-200 | China Unicom, China Mobile |
| **Central heating** | 1,800-3,000/season | Northern China has heating fee |
| **Total** | 300-700 | Excluding heating season |

**Heating season:** Mid-November to mid-March. Fee charged by sq meter.

---

## 🍽️ Food & Groceries

### Grocery Prices

| Item | Price (¥) | USD |
|------|-----------|-----|
| Milk (1L) | 12-20 | $1.70-2.80 |
| Bread (loaf) | 10-25 | $1.40-3.50 |
| Eggs (12) | 12-20 | $1.70-2.80 |
| Rice (5kg) | 40-80 | $5.60-11.20 |
| Chicken breast (500g) | 15-25 | $2.10-3.50 |
| Beef (500g) | 40-80 | $5.60-11.20 |
| Vegetables (kg) | 5-15 | $0.70-2.10 |
| Fruit (seasonal, kg) | 10-30 | $1.40-4.20 |
| Imported cheese (200g) | 40-80 | $5.60-11.20 |
| Wine (decent bottle) | 80-200 | $11.20-28.00 |
| Beer (local, 6-pack) | 20-40 | $2.80-5.60 |
| Coffee beans (250g) | 50-150 | $7.00-21.00 |

### Monthly Grocery Budget

| Style | Budget (¥) | Notes |
|-------|------------|-------|
| Local markets only | 800-1,500 | Chinese cooking |
| Mix local + imported | 1,500-3,000 | Balanced |
| Mostly imported | 3,000-5,000+ | Western products |
| Family of 4 | 3,000-6,000 | Varies by diet |

### Supermarket Tiers

| Tier | Stores | Price Level |
|------|--------|-------------|
| Budget | Local wet markets, Wumart | Cheapest |
| Mid-range | Carrefour, Walmart, Jingkelong | Standard |
| Premium | Jenny Lou's, April Gourmet, BHG | Imported goods |
| Organic | Organic shops, online | Most expensive |

### Dining Out

| Type | Cost per person (¥) | USD |
|------|---------------------|-----|
| Street food (jianbing, etc.) | 10-25 | $1.40-3.50 |
| Local restaurant | 30-60 | $4.20-8.40 |
| Mid-range restaurant | 80-150 | $11.20-21.00 |
| Hotpot (Haidilao type) | 100-200 | $14.00-28.00 |
| Western casual | 80-150 | $11.20-21.00 |
| Fine dining | 300-800+ | $42-112+ |
| Coffee (specialty) | 30-50 | $4.20-7.00 |
| Beer (bar) | 30-60 | $4.20-8.40 |
| Cocktail (bar) | 60-100 | $8.40-14.00 |

---

## 🚗 Transportation

### Monthly Costs

| Mode | Cost (¥/month) | Notes |
|------|----------------|-------|
| Subway only | 150-300 | Most trips ¥3-7 |
| Subway + DiDi | 400-800 | Typical commuter |
| Heavy DiDi | 1,500-3,000 | Daily use |
| Car ownership | 2,500-5,000 | Insurance, gas, parking |
| Driver service | 8,000-12,000 | Shunyi families |

### Specific Costs

| Item | Cost (¥) |
|------|----------|
| Subway single ride | 3-10 |
| DiDi short trip (3km) | 15-25 |
| DiDi airport | 100-180 |
| Bike share (monthly) | 15-25 |
| Gasoline (liter) | 7.5-9 |
| Parking (hour, CBD) | 10-30 |
| Parking (month, compound) | 500-2,000 |

---

## 👨‍👩‍👧‍👦 Education

### International Schools (Annual)

| Type | Fee Range (¥/year) | USD |
|------|-------------------|-----|
| Top-tier (ISB, WAB, BSB) | 250,000-350,000 | $35,000-49,000 |
| Upper tier (Dulwich, CISB) | 180,000-280,000 | $25,000-39,000 |
| Bilingual | 120,000-200,000 | $17,000-28,000 |
| Local international dept | 80,000-150,000 | $11,000-21,000 |

### Additional School Costs (Annual)

| Item | Cost (¥) |
|------|----------|
| School bus | 8,000-20,000 |
| Uniforms | 2,000-5,000 |
| Books/materials | 2,000-8,000 |
| Extracurriculars | 5,000-20,000 |
| Field trips | 2,000-10,000 |

### Preschool/Kindergarten (Monthly)

| Type | Cost (¥/month) |
|------|----------------|
| Local Chinese | 2,000-5,000 |
| Bilingual | 8,000-15,000 |
| International | 12,000-25,000 |

### Tutoring/After-school

| Type | Cost (¥/hour) |
|------|---------------|
| Local tutor | 100-300 |
| International tutor | 300-800 |
| SAT/college prep | 500-1,500 |
| Music lessons | 200-500 |

---

## 🏥 Healthcare

### Insurance

| Type | Annual Cost (¥) | USD |
|------|-----------------|-----|
| Basic local insurance | 3,000-8,000 | $420-1,120 |
| International (individual) | 15,000-40,000 | $2,100-5,600 |
| International (family) | 40,000-100,000+ | $5,600-14,000+ |
| Company-provided | Usually included | — |

### Out-of-Pocket (Without Insurance)

| Service | Cost (¥) |
|---------|----------|
| GP visit (public) | 50-200 |
| GP visit (private/international) | 500-1,500 |
| Specialist (public) | 100-500 |
| Specialist (private) | 800-2,000 |
| Dental cleaning | 300-800 |
| Emergency room | 500-5,000+ |

### Hospitals

| Type | Examples | Prices |
|------|----------|--------|
| Public | Beijing Hospital, Peking Union | Cheap but crowded |
| VIP public | International depts of above | Mid-range |
| Private/International | United Family, Raffles | Expensive |

---

## 🏋️ Lifestyle & Entertainment

### Monthly Averages

| Item | Cost (¥) | USD |
|------|----------|-----|
| Gym membership | 200-800 | $28-112 |
| Yoga class (drop-in) | 100-200 | $14-28 |
| Movie ticket | 50-100 | $7-14 |
| Netflix (VPN) | 80-100 | $11-14 |
| Spotify/music | 15-30 | $2-4 |
| Mobile phone plan | 50-200 | $7-28 |

### Other Costs

| Item | Cost (¥) |
|------|----------|
| Haircut (men, budget) | 30-80 |
| Haircut (men, expat salon) | 150-400 |
| Haircut (women, basic) | 80-200 |
| Haircut (women, expat salon) | 300-800 |
| Massage (1 hour) | 150-400 |
| Domestic helper (monthly) | 5,000-8,000 |
| Driver (monthly) | 7,000-12,000 |

---

## 📊 Monthly Budget Breakdowns

### Single Professional (Comfortable)

| Category | Budget (¥) | Notes |
|----------|------------|-------|
| Rent (1BR Sanlitun) | 10,000 | Mid-range |
| Utilities | 400 | Including internet |
| Groceries | 1,500 | Mix local/imported |
| Dining out | 2,000 | ~15 meals out |
| Transport | 600 | Subway + DiDi |
| Entertainment | 1,000 | Movies, drinks, etc. |
| Phone | 100 | Basic plan |
| Gym | 300 | Monthly |
| Misc | 1,000 | Buffer |
| **Total** | **~17,000** | **~$2,400** |

### Couple (No Kids)

| Category | Budget (¥) | Notes |
|----------|------------|-------|
| Rent (2BR Chaoyang) | 15,000 | Good area |
| Utilities | 600 | |
| Groceries | 2,500 | |
| Dining out | 3,500 | Restaurants, delivery |
| Transport | 1,000 | |
| Entertainment | 2,000 | |
| Phone (2) | 200 | |
| Gym (2) | 600 | |
| Misc | 2,000 | |
| **Total** | **~27,000** | **~$3,800** |

### Family of 4 (Expat Package)

| Category | Budget (¥) | Notes |
|----------|------------|-------|
| Rent (3BR Shunyi villa) | 45,000 | Good compound |
| Utilities | 2,000 | Including heating |
| Groceries | 5,000 | Family size |
| Dining out | 4,000 | |
| School fees (2 kids) | 45,000 | Averaged monthly |
| School extras | 3,000 | Bus, activities |
| Transport (car + driver) | 10,000 | |
| Healthcare | 3,000 | Insurance portion |
| Entertainment | 3,000 | |
| Domestic help | 6,000 | |
| Misc | 5,000 | |
| **Total** | **~130,000** | **~$18,000** |

---

## 💰 Salary Reference

### Local Companies

| Role | Monthly (¥) | Annual (¥) |
|------|-------------|------------|
| Fresh graduate | 8,000-15,000 | 96,000-180,000 |
| Mid-level professional | 20,000-40,000 | 240,000-480,000 |
| Senior professional | 40,000-80,000 | 480,000-960,000 |
| Director level | 60,000-120,000 | 720,000-1,440,000 |
| Tech engineer (mid) | 25,000-50,000 | 300,000-600,000 |
| Tech engineer (senior) | 50,000-100,000 | 600,000-1,200,000 |

### Expat Packages

| Level | Monthly (¥) | Includes |
|-------|-------------|----------|
| Junior expat | 30,000-50,000 | Basic |
| Professional | 50,000-100,000 | + housing allowance |
| Senior/Director | 100,000-200,000 | + school, flights |
| Executive | 200,000+ | Full package |

---

## 🌍 Beijing vs Other Cities

### Cost Comparison

| Item | Beijing | Shanghai | Singapore | London |
|------|---------|----------|-----------|--------|
| 1BR rent (central) | ¥10,000 | ¥12,000 | ¥20,000 | ¥25,000 |
| Meal (local) | ¥40 | ¥45 | ¥70 | ¥100 |
| Meal (Western) | ¥100 | ¥120 | ¥150 | ¥180 |
| Subway | ¥3-7 | ¥3-7 | ¥15-30 | ¥30-50 |
| DiDi/Taxi 5km | ¥25 | ¥30 | ¥100 | ¥150 |
| Beer (bar) | ¥40 | ¥50 | ¥80 | ¥60 |

### Cost Index (Beijing = 100)

| City | Index |
|------|-------|
| Beijing | 100 |
| Shanghai | 110 |
| Singapore | 160 |
| Hong Kong | 170 |
| London | 180 |
| New York | 200 |

---

## 💡 Money-Saving Tips

1. **Live near work:** Saves transport time and money
2. **Cook at home:** Local ingredients are very cheap
3. **Shop at wet markets:** 50% cheaper than supermarkets
4. **Use bike sharing:** ¥1-2 per trip
5. **Avoid Sanlitun prices:** Same food cheaper elsewhere
6. **Negotiate rent:** Especially for long-term leases
7. **Learn some Chinese:** Access cheaper local options
8. **Use Meituan/Eleme:** Restaurant coupons and deals

---

*Last updated: February 2026*
