# Beijing Climate & Air Quality Guide

> Last updated: February 2026 | Essential survival information for Beijing's extreme weather

## Overview

Beijing has a **humid continental climate** with extreme variations: bitter cold winters (-15°C), scorching summers (40°C+), dusty springs, and crisp autumns. Combined with air quality issues, climate preparation is essential.

---

## 🌡️ Monthly Breakdown

| Month | Avg High (°C) | Avg Low (°C) | Rain (mm) | Conditions |
|-------|---------------|--------------|-----------|------------|
| January | 2 | -9 | 3 | Cold, dry, clear |
| February | 5 | -6 | 6 | Cold, warming |
| March | 12 | 1 | 9 | Sandstorms possible |
| April | 21 | 8 | 21 | Pleasant but dusty |
| May | 27 | 14 | 34 | Warm, pleasant |
| June | 31 | 19 | 78 | Hot, humid, rain starts |
| July | 31 | 23 | 185 | Hottest, heavy rain |
| August | 30 | 22 | 160 | Hot, humid, monsoon |
| September | 26 | 15 | 49 | Cooling, beautiful |
| October | 19 | 7 | 19 | Perfect weather |
| November | 10 | -1 | 6 | Cold arriving |
| December | 3 | -7 | 2 | Cold, very dry |

---

## ❄️ Winter (November – March)

### What to Expect

- **Temperature:** -5°C to 5°C average, can drop to -15°C
- **Humidity:** Very low (20-40%) — dry skin, nosebleeds
- **Precipitation:** Minimal snow, mostly clear
- **Heating:** Central heating runs Nov 15 – Mar 15
- **Daylight:** Shortest days, dark by 5:00 PM

### Winter Survival Guide

| Challenge | Solution |
|-----------|----------|
| **Extreme cold** | Quality down jacket, thermal layers |
| **Dry skin** | Humidifier (essential), heavy moisturizer |
| **Nosebleeds** | Humidifier, saline spray |
| **Indoor/outdoor gap** | Layer up to adjust (hot inside, freezing outside) |
| **Frozen fingers** | Good gloves, hand warmers |

### Essential Winter Gear

- Down jacket (fill power 600+)
- Thermal base layers
- Wool sweater/fleece mid-layer
- Warm hat covering ears
- Quality gloves
- Scarf
- Warm boots (insulated)
- Humidifier for apartment

### Indoor Heating

- **Central heating:** Government-controlled, Nov 15 – Mar 15
- **Quality:** Varies by building (new = better)
- **Temperature:** Usually 20-24°C inside
- **Old buildings:** May be inadequate — check before renting
- **Supplemental:** Electric heaters if needed

### Winter Activities

- Houhai Lake ice skating (when frozen)
- Hot springs (many around Beijing)
- Ski resorts (Nanshan, 1-2h from city)
- Indoor activities — malls, museums, theaters

---

## ☀️ Summer (June – August)

### What to Expect

- **Temperature:** 30-38°C average, can hit 40°C+
- **Humidity:** Very high (60-80%)
- **Rain:** Monsoon season, sudden heavy storms
- **Heat index:** Often feels like 40°C+

### Summer Survival Guide

| Challenge | Solution |
|-----------|----------|
| **Extreme heat** | Stay in AC, avoid midday outdoors |
| **Humidity** | Light, breathable clothing |
| **Sudden rain** | Always carry compact umbrella |
| **AC blast** | Light jacket for over-AC'd spaces |
| **Hydration** | Drink constantly, electrolytes |

### Essential Summer Gear

- Breathable clothing (cotton, linen)
- Light cardigan (for AC)
- Umbrella (sun/rain)
- Sunscreen (SPF 50+)
- Sunglasses
- Refillable water bottle
- Portable fan (battery-powered)

### Air Conditioning

- **Ubiquitous:** Every building, subway, mall has AC
- **Too cold:** Chinese tend to set AC very cold (18-22°C)
- **Keep layer:** Light jacket for indoors

### Summer Tips

- **Schedule around heat:** 6-10 AM, after 6 PM for outdoor activities
- **Midday:** Indoor activities only
- **Great Wall:** Go early morning or skip until autumn
- **Food safety:** Extra careful with street food (heat + humidity)

---

## 🌸 Spring (March – May)

### What to Expect

- **Temperature:** 10-25°C, rapidly warming
- **Sandstorms:** March-April, dust from Gobi Desert
- **Pollen:** April-May can be bad for allergies
- **Rainfall:** Increasing, occasional

### Spring Survival

| Challenge | Solution |
|-----------|----------|
| **Sandstorms** | N95 mask, stay indoors on bad days |
| **Pollen/allergies** | Antihistamines, mask |
| **Unpredictable weather** | Layers, check forecast |
| **Dry wind** | Moisturizer, lip balm |

### Sandstorm Reality

- **Frequency:** 5-10 significant events per spring
- **Warning signs:** Yellow sky, visibility dropping
- **AQI:** Can spike to 500+ (hazardous)
- **Duration:** Usually 1-2 days
- **Action:** Stay indoors, seal windows, run air purifier

### Cherry Blossoms

- **Where:** Yuyuantan Park, PKU, Yuanmingyuan
- **When:** Late March to mid-April
- **Tip:** Weekdays less crowded

---

## 🍂 Autumn (September – November)

### What to Expect

- **Temperature:** 15-25°C cooling to 5-15°C
- **Humidity:** Lower, comfortable
- **Rainfall:** Decreasing
- **Air quality:** Often better (less humidity traps pollution)

### Why Autumn is Best

- Perfect weather for outdoor activities
- Great Wall trips ideal
- Clear skies for photography
- Fragrant Hills fall colors (October)
- Comfortable temperatures

### What to Wear

- Layers (mornings cool, afternoons warm)
- Light jacket
- Long pants
- Comfortable walking shoes

---

## 😷 Air Quality (AQI)

### Understanding AQI

| AQI | Level | Color | Health Implications |
|-----|-------|-------|---------------------|
| 0-50 | Good | Green | Enjoy outdoor activities |
| 51-100 | Moderate | Yellow | Sensitive people may notice |
| 101-150 | Unhealthy for sensitive | Orange | Limit prolonged outdoor |
| 151-200 | Unhealthy | Red | Everyone should limit outdoor |
| 201-300 | Very unhealthy | Purple | Avoid outdoor activity |
| 300+ | Hazardous | Maroon | Stay indoors, air purifier |

### Beijing AQI Reality (2025)

- **Average AQI:** ~70-100 (moderate to unhealthy for sensitive)
- **Good days:** 150-200 days/year with AQI <100
- **Bad days:** 50-100 days/year with AQI >150
- **Hazardous days:** 10-20 days/year with AQI >300
- **Trend:** Improving but still problematic

### Seasonal Patterns

| Season | Typical AQI | Reason |
|--------|-------------|--------|
| Winter | Higher (150-250+) | Coal heating, cold traps pollution |
| Summer | Lower (50-100) | Rain washes air, wind disperses |
| Spring | Variable | Sandstorms spike AQI |
| Autumn | Best (40-80) | Lower humidity, clear skies |

### After Rain

- **Best time:** Day after heavy rain
- **AQI:** Often 20-40 (excellent)
- **Duration:** Usually 1-3 days before pollution rebuilds

### Monitoring Apps

| App | Notes |
|-----|-------|
| **Air Matters** | Multiple city comparison |
| **AirVisual** | Forecasts |
| **WeChat mini-programs** | Various |
| **Government app** | Official (sometimes criticized as underreporting) |

### US Embassy vs Chinese Readings

- **US Embassy:** Often 20-30% higher readings
- **Why:** Different measurement standards
- **Recommendation:** Trust US Embassy readings (more conservative)

### Air Purifiers

**Essential for every apartment:**

| Brand | Price Range (¥) | Notes |
|-------|-----------------|-------|
| Xiaomi | 600-2,000 | Good value |
| Blueair | 2,000-5,000 | High-end |
| IQAir | 4,000-10,000+ | Premium |
| Philips | 1,500-4,000 | Reliable |

**Tips:**
- Run continuously during bad days
- Check filter replacement schedule
- Get appropriate size for room (check CADR rating)
- Some compounds provide purifiers

### Masks

| Type | Protection | Use |
|------|------------|-----|
| Surgical mask | Low | Not effective for PM2.5 |
| KN95/N95 | High | Recommended for bad AQI days |
| KN90 | Good | Budget option |
| Cloth mask | Minimal | Fashion only |

**Fit is critical:** Masks only work if sealed properly

---

## 🗓️ Best Times to Visit

### Ideal

| Activity | Best Months |
|----------|-------------|
| General tourism | September, October |
| Great Wall | September-November, April-May |
| Forbidden City | October, April |
| Outdoor activities | September-October |
| Photography | Autumn (clear skies) |

### Avoid

| Time | Why |
|------|-----|
| Golden Week (Oct 1-7) | Extreme crowds |
| Chinese New Year | Many places closed |
| July-August | Hot, humid, rain |
| December-February | Freezing |
| Mid-March | Sandstorms |

---

## 🏠 Home Preparation

### Winter Checklist

- [ ] Humidifier (running 24/7)
- [ ] Air purifier
- [ ] Check heating works (before Nov 15)
- [ ] Draft stoppers for doors/windows
- [ ] Electric blanket or heater backup
- [ ] Heavy curtains for insulation

### Summer Checklist

- [ ] AC maintenance/cleaning
- [ ] Dehumidifier (for closets)
- [ ] Mosquito repellent/nets
- [ ] Umbrella by door
- [ ] Water bottles filled in fridge

### Year-Round

- [ ] Air purifier filters stocked
- [ ] AQI monitoring app installed
- [ ] N95 masks supply
- [ ] Allergy medication (spring)

---

## Weather Apps

| App | Use |
|-----|-----|
| **Weather 中国天气** | Official Chinese |
| **WeChat weather** | Built-in, convenient |
| **Apple Weather** | Decent for Beijing |
| **Windy** | Detailed forecasts, AQI maps |

---

*Last updated: February 2026*
