# Beijing Business Setup Guide

> Comprehensive guide to starting and running a business in Beijing: structures, requirements, and practicalities.

## Overview

Beijing offers enormous market potential but significant bureaucratic complexity. Business setup requires patience, local partners (for some structures), and understanding of Chinese regulatory environment.

---

## 🏢 Business Structure Options

### Structure Comparison

| Structure | Foreign Ownership | Complexity | Best For |
|-----------|------------------|------------|----------|
| **WFOE** | 100% | High | Most foreign businesses |
| **Rep Office** | N/A | Medium | Sales support, no revenue |
| **Joint Venture** | Varies | Very High | Regulated industries |
| **FIPE** | 100% | Medium | Partnership structure |
| **VIE** | Indirect | Very High | Restricted sectors |

---

## 🏭 WFOE (Wholly Foreign-Owned Enterprise)

### What Is It?

A WFOE (外商独资企业) is a limited liability company 100% owned by foreign investors. Most common structure for foreign businesses in China.

### Types

| Type | Purpose | Notes |
|------|---------|-------|
| **Trading WFOE** | Import/export | Requires additional licenses |
| **Service WFOE** | Consulting, services | Most common |
| **Manufacturing WFOE** | Production | Requires location in industrial zone |
| **Tech WFOE** | Software, R&D | Popular for tech companies |

### Setup Requirements

| Requirement | Details |
|-------------|---------|
| **Registered capital** | Industry-specific, ¥100,000-1,000,000+ typical |
| **Business scope** | Must be precisely defined |
| **Registered address** | Commercial office required |
| **Legal representative** | Individual responsible for company |
| **Articles of association** | Company bylaws |
| **Feasibility study** | For some industries |

### Setup Process

| Step | Timeline | Notes |
|------|----------|-------|
| 1. Company name approval | 1-3 days | Chinese name required |
| 2. Business license application | 5-10 days | SAMR (市场监督管理局) |
| 3. Company seal carving | 1-2 days | Multiple official seals |
| 4. Bank account opening | 2-4 weeks | Basic + capital account |
| 5. Tax registration | 1-2 weeks | National + local tax |
| 6. Foreign exchange registration | 1-2 weeks | For capital injection |
| 7. Capital injection | Ongoing | Within 5 years typically |

**Total Timeline:** 2-4 months (with experienced agent)

### Costs

| Item | Cost (¥) | Notes |
|------|----------|-------|
| **Government fees** | 1,000-5,000 | Registration, stamps |
| **Agent fees** | 10,000-50,000 | Depends on complexity |
| **Registered address** | 3,000-20,000/year | Virtual office option |
| **Legal review** | 5,000-30,000 | Recommended |
| **Accounting setup** | 2,000-10,000 | Initial setup |
| **Annual compliance** | 20,000-50,000/year | Accounting, audit, filing |

### WFOE Pros & Cons

**Pros:**
- Full control (100% ownership)
- Protect intellectual property
- Hire employees directly
- Invoice in RMB
- Standard corporate structure

**Cons:**
- Complex setup
- Higher costs
- Full compliance burden
- Cannot access some sectors

---

## 📋 Representative Office

### What Is It?

A Rep Office (代表处) is a liaison office that cannot engage in profit-making activities. Used for market research, coordination, and relationship building.

### Limitations

| Can Do | Cannot Do |
|--------|-----------|
| Market research | Sign contracts |
| Coordinate activities | Generate revenue |
| Build relationships | Hire non-clerical staff |
| Promote parent company | Import/export directly |
| Attend trade shows | Invoice customers |

### Requirements

| Requirement | Details |
|-------------|---------|
| **Parent company** | Must exist 2+ years |
| **Representative** | Appointed chief representative |
| **Office address** | Must lease approved space |
| **Bank account** | For expenses only |

### Costs

| Item | Cost (¥/year) |
|------|---------------|
| **Registration** | 3,000-5,000 |
| **Agent fees** | 5,000-15,000 |
| **Office space** | 50,000-200,000+ |
| **Compliance** | 15,000-30,000 |

### Rep Office → WFOE

Common path: Start with Rep Office to test market, then convert to WFOE when ready to operate fully.

---

## 🤝 Joint Venture (JV)

### When Required

| Sector | Requirement |
|--------|-------------|
| **Automotive** | JV with local partner |
| **Media/Publishing** | Prohibited or JV only |
| **Telecom** | Restricted |
| **Finance** | Special licenses |
| **Education** | Complex regulations |

### JV Considerations

| Factor | Reality |
|--------|---------|
| **Partner selection** | Critical — do thorough due diligence |
| **Control** | Often contentious |
| **IP protection** | Major concern |
| **Exit options** | Plan ahead |
| **Dispute resolution** | Specify mechanism |

**Recommendation:** Avoid JV unless legally required. WFOE preferred when possible.

---

## 📍 Registered Address

### Options

| Type | Cost (¥/year) | Pros | Cons |
|------|---------------|------|------|
| **Virtual address** | 5,000-15,000 | Cheapest | Not all districts allow |
| **Serviced office** | 30,000-80,000 | Flexible | Higher cost |
| **Full office** | 100,000+ | Full operations | Expensive, commitment |

### District Considerations

| District | Notes |
|----------|-------|
| **Chaoyang** | Most foreign companies, easier process |
| **Haidian** | Tech focus, incentives available |
| **CBD** | Premium address, higher costs |
| **Economic zones** | Tax incentives, specific requirements |

---

## 💼 Hiring Employees

### Employment Basics

| Requirement | Details |
|-------------|---------|
| **Written contract** | Mandatory, Chinese required |
| **Probation** | 1-6 months depending on contract length |
| **Social insurance** | Mandatory 5 insurances + 1 fund |
| **Termination** | Complex rules, severance required |

### Social Insurance Contributions (Beijing 2025)

| Insurance | Employer | Employee |
|-----------|----------|----------|
| Pension | 16% | 8% |
| Medical | 9.8% | 2% |
| Unemployment | 0.5% | 0.5% |
| Work injury | 0.2-1.9% | — |
| Maternity | 0.8% | — |
| Housing fund | 5-12% | 5-12% |
| **Total** | **~32-40%** | **~15-22%** |

### Hiring Foreigners

| Requirement | Details |
|-------------|---------|
| **Work permit** | Company sponsors, see `visas.md` |
| **Quota** | Some companies have limits |
| **Cost** | ¥5,000-15,000 processing |
| **Timeline** | 4-8 weeks |

---

## 💰 Taxation

### Corporate Taxes

| Tax | Rate | Notes |
|-----|------|-------|
| **Corporate Income Tax** | 25% | Standard rate |
| **CIT (small/tech)** | 15-20% | Qualifying businesses |
| **VAT** | 6-13% | Depends on activity |
| **Withholding tax** | 10% | Dividends to foreign shareholder |

### VAT Rates

| Activity | Rate |
|----------|------|
| **Services** | 6% |
| **Transportation** | 9% |
| **Manufacturing** | 13% |
| **Small taxpayer** | 3% (simplified) |

### Tax Incentives

| Incentive | Benefit |
|-----------|---------|
| **High-tech enterprise** | 15% CIT rate |
| **R&D deduction** | 175% super-deduction |
| **Economic zones** | Various benefits |
| **Double tax treaties** | Reduced withholding |

---

## 📊 Annual Compliance

### Required Filings

| Filing | Deadline | Notes |
|--------|----------|-------|
| **Annual audit** | April 30 | CPA firm required |
| **Corporate tax filing** | May 31 | Annual reconciliation |
| **Annual inspection** | June 30 | SAMR online system |
| **Statistics report** | Various | Industry-specific |
| **SAFE report** | December | Foreign exchange |

### Ongoing Requirements

| Requirement | Frequency |
|-------------|-----------|
| Monthly tax filing | Monthly |
| Social insurance | Monthly |
| Book keeping | Ongoing |
| Invoice management | Ongoing |
| Bank reconciliation | Monthly |

### Estimated Annual Compliance Costs

| Company Size | Cost (¥/year) |
|--------------|---------------|
| Small (1-5 employees) | 30,000-60,000 |
| Medium (5-20 employees) | 60,000-150,000 |
| Large (20+ employees) | 150,000+ |

---

## 🏦 Banking

### Corporate Bank Account

**Required documents:**
- Business license
- Organization code certificate
- Tax registration
- Company seal
- Legal representative ID
- Articles of association

**Account types:**
- Basic account (daily operations)
- Capital account (foreign investment)
- Special accounts (as needed)

### Foreign Exchange

| Activity | Requirements |
|----------|--------------|
| **Capital injection** | SAFE registration |
| **Profit repatriation** | Tax clearance, audit |
| **Payment for services** | Tax withholding proof |
| **Import/export** | Trade license |

---

## 🌐 E-Commerce & ICP

### ICP License

Required for any website hosted in China.

| Type | Purpose | Notes |
|------|---------|-------|
| **ICP Bei'an** | Basic registration | All websites need |
| **ICP License** | Commercial websites | E-commerce, paid services |
| **EDI License** | E-commerce platforms | Marketplace operations |

### E-Commerce Setup

| Option | Complexity | Notes |
|--------|------------|-------|
| **Cross-border e-commerce** | Medium | Via bonded zones |
| **Tmall/JD store** | Medium | Platform fees, requirements |
| **Own website** | High | ICP, payment integration |
| **WeChat store** | Medium | WeChat mini-program |

---

## 🎯 Sector-Specific Notes

### Technology

| Type | Considerations |
|------|----------------|
| **Software** | WFOE works, IP registration important |
| **AI** | Government interest, potential support |
| **Data** | Data localization requirements |
| **Cloud** | Must partner with licensed provider |

### Consulting/Services

| Type | Considerations |
|------|----------------|
| **Management consulting** | WFOE straightforward |
| **Legal services** | Restricted, rep office only |
| **Accounting** | Must be licensed CPA |
| **Education** | Complex regulations |

### Trading/Import-Export

| Type | Considerations |
|------|----------------|
| **General trading** | Need import/export license |
| **Food/cosmetics** | CFDA registration required |
| **Medical devices** | NMPA approval required |
| **Dangerous goods** | Special permits |

---

## 🚨 Common Pitfalls

1. **Underestimating timeline** — Plan for 3-6 months, not 3-6 weeks
2. **Wrong structure** — Get advice before committing
3. **Inadequate registered capital** — Affects credibility and operations
4. **IP not protected** — Register trademarks/patents early
5. **Non-compliant hiring** — Social insurance is mandatory
6. **Cash flow planning** — Capital injection rules are strict
7. **Partner due diligence** — For JVs, verify everything
8. **Ignoring compliance** — Fines and operational issues

---

## 📞 Getting Help

### Professional Services

| Service | Purpose |
|---------|---------|
| **Incorporation agents** | Company setup |
| **Law firms** | Contracts, compliance, disputes |
| **Accounting firms** | Books, audit, tax |
| **HR agencies** | Hiring, payroll |
| **PR/Marketing** | Market entry |

### Recommended Approach

1. **Consult lawyer** — Before any commitment
2. **Use experienced agent** — For setup efficiency
3. **Hire local accountant** — Ongoing compliance
4. **Build relationships** — Government relations matter

---

*Last updated: February 2026*
