# 北京市科技公司财务管理Skill使用示例

## 场景1：研发费用加计扣除计算

**用户需求**：公司年度销售收入800万元，研发费用60万元，作为科技型中小企业，如何计算研发费用加计扣除？

**技能调用**：
```bash
cd /home/admin/clawd/skills/beijing-tech-finance
python scripts/calculate_rd_deduction.py 8000000 600000 tech_sme
```

**预期输出**：
```
==================================================
研发费用加计扣除计算结果
==================================================
年度销售收入: ¥8,000,000.00
研发费用总额: ¥600,000.00
实际研发费用占比: 7.50%
要求最低占比: 5.00%
要求最低金额: ¥400,000.00
是否满足要求: 是
--------------------------------------------------
加计扣除比例: 100%
可加计扣除金额: ¥600,000.00
预计节税金额: ¥150,000.00
==================================================
```

## 场景2：增值税计算（一般纳税人）

**用户需求**：月度含税销售额100万元，进项税额8万元，计算应纳增值税。

**技能调用**：
```bash
python scripts/calculate_vat.py general 1000000 80000
```

**预期输出**：
```json
{
  "output_tax": 130000.0,
  "input_tax": 80000.0,
  "payable_tax": 50000.0,
  "carry_forward": 0.0,
  "export_sales": 0.0
}
```

## 场景3：预算监控预警

**用户需求**：监控软件研发部门的月度预算使用情况。

**准备预算文件** (`budgets.json`)：
```json
{
  "rd": {
    "software": {
      "annual_budget": 1200000,
      "monthly_budget": 100000
    }
  }
}
```

**技能调用**：
```bash
python scripts/monitor_budget.py budgets.json rd software
```

**预期输出**：
```
⚠️ 中风险预警：software 预算月度使用率75.23%，年度使用率68.45%，请注意支出节奏。

详细数据:
{
  "budget_type": "rd",
  "category": "software",
  "current_month": "2026-02",
  "monthly_budget": 100000,
  "monthly_actual": 75230.45,
  "monthly_usage_rate": 75.23,
  "monthly_remaining": 24769.55,
  "annual_budget": 1200000,
  "annual_actual_estimated": 150460.9,
  "annual_usage_rate": 68.45,
  "annual_remaining": 1049539.1,
  "warning_level": "medium"
}
```

## 场景4：查询北京市高新技术企业政策

**用户需求**：了解北京市高新技术企业的认定条件和税收优惠政策。

**参考文件**：`references/beijing-tax-policies.md`

**关键信息**：
- 企业所得税优惠税率：15%（标准25%）
- 研发费用占比要求：销售收入≤5000万需≥5%
- 科技人员占比：≥10%
- 申请时间：每年3-4月

## 场景5：创建项目预算模板

**用户需求**：为新项目创建标准化的预算模板。

**模板文件**：`assets/templates/project_budget_template.xlsx`

**包含内容**：
- 人力成本预算
- 设备采购预算  
- 外包服务预算
- 差旅会议预算
- 其他运营预算
- 预算控制和审批流程

## 场景6：处理员工报销流程

**用户需求**：规范员工差旅和业务招待费报销流程。

**参考文件**：`references/workflows-templates.md`

**关键步骤**：
1. 员工提交电子报销单（附发票和说明）
2. 部门经理审批（≤5000元）
3. 财务审核合规性
4. CFO审批（>5000元）
5. 出纳付款
6. 会计入账

## 场景7：年度财务报告准备

**用户需求**：准备年度财务报表和统计报告。

**参考文件**：`references/financial-policies.md`

**必需报告**：
- 资产负债表
- 利润表  
- 现金流量表
- 所有者权益变动表
- 附注说明
- 统计局年报
- 税务局汇算清缴

## 场景8：跨境业务税务处理

**用户需求**：处理向境外客户提供的技术服务收入。

**参考文件**：`references/beijing-tax-policies.md`

**处理要点**：
- 办理跨境应税行为免税备案
- 开具增值税普通发票（备注"技术开发"）
- 在技术市场管理部门进行技术合同认定登记
- 保留外汇收入凭证和境外客户证明

---
这个skill为北京市科技公司提供了全面的财务管理解决方案，涵盖了从日常运营到战略规划的所有财务需求。