---
name: beijing-tech-finance
description: Comprehensive financial management system for Beijing-based technology companies, covering financial director workflows, budget management, accounting systems, tax optimization, expense reimbursement, customs declaration, annual reporting, and integration with business contracts, R&D budgets, project management, HR, and administrative services. Use when managing any aspect of tech company finances in Beijing including budget planning, expense processing, tax compliance, financial reporting, or cross-functional financial coordination.
---

# Beijing Technology Company Financial Management

This skill provides comprehensive financial management capabilities specifically designed for technology companies operating in Beijing, China. It covers all essential financial processes from strategic planning to operational execution.

## Core Capabilities

- **Financial Director Management**: Strategic financial planning, cash flow management, investor relations
- **Budget & Expense Management**: R&D budgets, project budgets, departmental budgets, expense reimbursement workflows
- **Accounting Systems**: Chinese GAAP compliance, double-entry bookkeeping, financial statement preparation
- **Tax Optimization**: VAT, corporate income tax, R&D tax incentives, Beijing-specific tax policies
- **Compliance & Reporting**: Annual reports, statistical reporting, customs declaration for imported equipment
- **Cross-functional Integration**: Business contract financial terms, project cost tracking, HR payroll integration, administrative expense management

## When to Use This Skill

Use this skill when you need to:
- Create or manage company budgets (R&D, projects, departments)
- Process expense reimbursements with proper documentation
- Handle tax planning and compliance for Beijing tech companies
- Prepare financial statements and reports
- Manage business contract financial terms and payment schedules
- Coordinate financial aspects across teams (engineering, sales, HR, admin)
- Handle customs declaration for imported technology equipment
- Prepare annual reports and statutory filings

## Getting Started

### 1. Financial Policies & Systems

Start with `references/financial-policies.md` for comprehensive accounting systems, internal controls, and Beijing compliance requirements.

### 2. Beijing Tax Optimization

Consult `references/beijing-tax-policies.md` for current tax incentives, R&D super deductions, VAT policies, and Beijing municipal benefits.

### 3. Budget & Project Finance

Use `references/budget-project-finance.md` for R&D budgeting, project cost tracking, and integration with business contracts.

### 4. HR & Administrative Integration

Reference `references/hr-admin-finance.md` for payroll integration, benefit costs, administrative expense management, and team coordination.

### 5. Workflows & Templates

Access `references/workflows-templates.md` for practical templates, approval workflows, and step-by-step procedures.

## Key Beijing-Specific Considerations

- **High-Tech Enterprise Certification**: Qualify for 15% corporate income tax rate (vs standard 25%)
- **R&D Expense Super Deduction**: Additional 75-100% deduction for qualified R&D expenses
- **Beijing Municipal Incentives**: Various subsidies and grants for tech companies
- **Customs Procedures**: Special procedures for importing R&D equipment and materials
- **Social Insurance**: Beijing-specific contribution rates and requirements

## Bundled Resources

This skill includes comprehensive reference materials organized by functional area:

- `references/budgeting.md` - Budget planning templates and workflows
- `references/expenses.md` - Expense reimbursement policies and procedures  
- `references/tax-compliance.md` - Tax planning and compliance guide
- `references/accounting.md` - Accounting standards and procedures
- `references/integration.md` - Cross-functional financial coordination
- `references/compliance.md` - Regulatory compliance and reporting requirements

## Usage Guidelines

1. **Always check Beijing-specific regulations** - Local policies change frequently
2. **Maintain proper documentation** - Chinese tax authorities require detailed records
3. **Leverage tech industry incentives** - Ensure proper qualification for tax benefits
4. **Coordinate with legal counsel** - For complex contractual or compliance matters
5. **Regular financial reviews** - Monthly cash flow, quarterly performance, annual planning

Load specific reference files based on your immediate needs rather than loading all content at once.