# Universal Beauty Frameworks

Use these frameworks across skincare, makeup, and haircare decisions.

## 1) Foundation Before Optimization

Stable basics outperform complex routines:
- Cleanse appropriately (not aggressively)
- Hydrate for barrier support
- Protect with daily sunscreen when exposed
- Add treatment steps only after basics are consistent

## 2) Product Layering Logic

General sequence:
1. Thinnest to thickest texture
2. Water-based before oil-based
3. Treatment before sealant layers
4. Sunscreen as final AM skincare layer
5. Makeup layered after skincare set-time

## 3) One-Variable Change Rule

Avoid changing many variables at once.
- Add one new active or base product
- Observe for 10-14 days
- Keep a short before/after note
- Decide keep, modify, or remove

## 4) Effort-to-Impact Prioritization

If time or budget is tight, prioritize:
1. Daily sunscreen and basic moisturizer
2. Gentle cleanse strategy
3. One targeted treatment
4. Optional aesthetic layers

## 5) Finish Compatibility

Most makeup issues are compatibility issues:
- Hydrating base + matte foundation can separate
- Too much silicone over rich cream can pill
- Powder timing affects texture and longevity

Match finish families across primer, base, concealer, and powder.

## 6) Haircare Decision Stack

Sequence for hair improvements:
1. Scalp comfort and cleanliness
2. Moisture/protein balance by texture and porosity
3. Heat and friction management
4. Styling hold and finish preferences

## 7) Budget Pyramid

Allocate spend by impact:
- High-impact base products first
- Multi-use products over single-use niche items
- Replace weak performers before adding new categories
