# Financial Analysis Guide

## Key Financial Metrics

### Net Worth
**Formula**: `Assets - Liabilities`

**Interpretation**:
- Positive = Solvent (own more than owe)
- Negative = Insolvent (owe more than own)
- Track changes over time to measure wealth accumulation

### Savings Rate
**Formula**: `(Income - Expenses) / Income × 100%`

**Benchmarks**:
- 0-5%: Critical - limited financial resilience
- 5-10%: Below average - vulnerable to emergencies
- 10-20%: Average - building foundation
- 20-30%: Good - strong financial position
- 30-50%: Excellent - accelerated wealth building
- 50%+: Exceptional - early retirement potential

### Expense Ratio by Category
**Formula**: `Category Expenses / Total Expenses × 100%`

**Common Healthy Ranges** (vary by location/situation):
- Housing: 25-35%
- Transportation: 10-20%
- Food: 10-15%
- Utilities: 5-10%
- Insurance: 10-15%
- Savings/Investments: 20%+
- Entertainment: 5-10%
- Personal: 5-10%

### Emergency Fund Adequacy
**Formula**: `Liquid Assets / Monthly Expenses`

**Benchmarks**:
- < 1 month: Critical risk
- 1-3 months: Minimal protection
- 3-6 months: Adequate for stable employment
- 6-12 months: Strong for less stable situations
- 12+ months: Exceptional cushion

### Debt-to-Income Ratio
**Formula**: `Total Monthly Debt Payments / Gross Monthly Income × 100%`

**Benchmarks**:
- < 20%: Excellent - manageable debt
- 20-36%: Acceptable - monitor carefully
- 36-43%: Concerning - difficulty with emergencies
- > 43%: Critical - high default risk

### Investment Allocation
**Asset Classes**:
- Stocks (Equities): Higher risk, higher return potential
- Bonds (Fixed Income): Lower risk, stable returns
- Real Estate: Moderate risk, inflation hedge
- Cash/Money Market: Lowest risk, lowest returns
- Commodities: High volatility, diversification

**Age-Based Allocation Rule of Thumb**:
- Stock allocation % ≈ 100 - Age (or 110 - Age for aggressive)
- Example: Age 30 → 70% stocks, 30% bonds/cash

**Risk-Based Allocation**:
- Conservative: 30% stocks, 70% bonds/cash
- Moderate: 60% stocks, 40% bonds/cash
- Aggressive: 80% stocks, 20% bonds/cash

## Spending Analysis

### Identify Spending Patterns

**Monthly Trends**:
- Look for seasonal variations (holidays, summer travel)
- Identify recurring unnecessary expenses
- Track impulse vs. planned purchases

**Category Deep-Dive**:
1. List top 5 expense categories
2. Within each, identify largest individual expenses
3. Classify as: Essential, Beneficial, or Discretionary
4. Target 10-20% reduction in discretionary

**Red Flags**:
- Increasing total expenses faster than income
- High percentage on discretionary items
- Frequent overdrafts or credit card debt accumulation
- Savings rate declining over time

### Optimization Strategies

**Housing** (if >35% of expenses):
- Consider refinancing mortgage
- Explore roommate options
- Evaluate relocation to lower cost area
- Negotiate rent reduction

**Transportation** (if >20% of expenses):
- Use public transit when possible
- Carpool or bike for short trips
- Consolidate errands to reduce fuel
- Consider car-free or one-car household

**Food** (if >15% of expenses):
- Meal plan weekly before shopping
- Reduce dining out frequency
- Buy generic brands for staples
- Use loyalty programs and coupons
- Reduce food waste through better storage

**Subscriptions** (often overlooked):
- Audit all monthly subscriptions
- Cancel unused services
- Rotate streaming services seasonally
- Share family plans where applicable

## Investment Analysis

### Performance Metrics

**Return on Investment (ROI)**:
```
ROI = (Current Value - Initial Investment) / Initial Investment × 100%
```

**Annualized Return**:
```
Annualized Return = (Ending Value / Beginning Value)^(1/Years) - 1
```

**Volatility/Risk**:
- Standard deviation of returns
- Maximum drawdown (largest peak-to-trough decline)
- Sharpe ratio (return per unit of risk)

### Portfolio Review Checklist

1. **Diversification**: Spread across asset classes, sectors, geographies
2. **Rebalancing**: Restore target allocation (annually or when 5%+ drift)
3. **Cost Analysis**: Minimize expense ratios and trading fees
4. **Tax Efficiency**: Use tax-advantaged accounts optimally
5. **Performance vs Benchmarks**: Compare to relevant indices
6. **Risk Alignment**: Matches current risk tolerance and timeline

### Common Investment Mistakes

- **Emotional Trading**: Buying high (greed) and selling low (fear)
- **Concentration Risk**: Too much in single stock/sector
- **Timing the Market**: Statistically unsuccessful long-term
- **High Fees**: Compound to significantly reduce returns
- **Ignoring Taxes**: Trigger unnecessary capital gains
- **Insufficient Diversification**: Over-exposure to employer stock

## Budget Creation

### Zero-Based Budget
Assign every dollar a purpose: Income - Expenses - Savings = 0

**Steps**:
1. Calculate monthly net income
2. List all fixed expenses (rent, utilities, insurance)
3. Estimate variable expenses (food, entertainment)
4. Allocate remaining to savings/debt/goals
5. Track actual spending vs. budget monthly
6. Adjust budget based on reality

### 50/30/20 Rule
Simple allocation framework:
- 50% Needs (housing, food, utilities, transportation, insurance)
- 30% Wants (entertainment, dining out, hobbies)
- 20% Savings (emergency fund, retirement, debt payoff)

### Envelope System
Physical or digital "envelopes" for spending categories:
- Allocate fixed amount per category monthly
- Spend only what's in envelope
- Forces awareness and restraint
- Particularly effective for discretionary spending

## Goal Setting

### SMART Financial Goals

**Specific**: "Save $20,000" not "Save more"
**Measurable**: Track progress numerically
**Achievable**: Realistic given income/expenses
**Relevant**: Aligned with values and priorities
**Time-bound**: "By December 2025" not "Someday"

**Examples**:
- Emergency Fund: "Save $15,000 (6 months expenses) by Dec 2025"
- Debt Payoff: "Pay off $8,000 credit card by June 2025"
- Investment: "Contribute $6,000 to retirement account in 2024"
- Purchase: "Save $5,000 for vacation by August 2024"

### Prioritization Framework

**Priority Order**:
1. Basic needs (food, shelter, utilities)
2. Minimum debt payments
3. Emergency fund ($1,000 starter, then 3-6 months expenses)
4. Employer retirement match (free money)
5. High-interest debt payoff (>7% interest)
6. Remaining retirement contributions
7. Other savings goals (house, education)
8. Low-interest debt payoff (<4% interest)
9. Additional investments

## Cash Flow Management

### Positive Cash Flow
**Income > Expenses**: Building wealth over time
- Automatically transfer surplus to savings/investments
- Increase retirement contributions
- Build sinking funds for future expenses

### Neutral Cash Flow
**Income = Expenses**: Living paycheck to paycheck
- Create buffer with small spending cuts
- Seek income increase opportunities
- Build emergency fund gradually

### Negative Cash Flow
**Income < Expenses**: Unsustainable trajectory
- **Immediate action required**
- Cut discretionary expenses completely
- Reduce essential expenses where possible
- Increase income (overtime, side gig, better job)
- Avoid new debt
- Consider financial counseling

### Irregular Income Management
For freelancers, commission-based, seasonal workers:

1. Calculate average monthly income (past 12 months)
2. Budget based on lowest monthly income
3. Save excess in buffer account during high months
4. Maintain larger emergency fund (9-12 months)
5. Prepay essential expenses during abundant periods

## Tax Optimization

### Tax-Advantaged Accounts

**Retirement Accounts**:
- Traditional 401(k)/IRA: Pre-tax contributions, taxed on withdrawal
- Roth 401(k)/IRA: After-tax contributions, tax-free growth and withdrawal
- Consider current vs. retirement tax bracket

**Health Savings Account (HSA)** (if applicable):
- Triple tax advantage: deductible contribution, tax-free growth, tax-free medical withdrawals
- Can invest for long-term growth
- Effectively a supplementary retirement account

**Education Savings**:
- 529 Plans: Tax-free growth for qualified education expenses
- Coverdell ESA: More investment flexibility, lower limits

### Tax-Loss Harvesting
- Sell investments at loss to offset capital gains
- Reduces tax liability
- Immediately reinvest in similar (not identical) asset
- Beware wash-sale rule (30 days)

### Strategic Charitable Giving
- Donate appreciated assets (stocks) instead of cash
- Avoid capital gains tax while getting deduction
- Bunch donations in high-income years

## Financial Independence Metrics

### FI Number
**Formula**: `Annual Expenses × 25`

Based on 4% safe withdrawal rate.

**Example**: If you spend $40,000/year, you need $1,000,000 to be financially independent.

### Years to FI
**Formula**: Based on savings rate

| Savings Rate | Years to FI |
|--------------|-------------|
| 10%          | 51 years    |
| 25%          | 32 years    |
| 50%          | 17 years    |
| 65%          | 10 years    |
| 75%          | 7 years     |

### Coast FI
Amount needed now to reach FI at traditional retirement age with no additional contributions.

**Formula**: `FI Number / (1 + Return)^Years`

**Example**: Need $1M at age 65 (currently 35), 7% return:
Coast FI = $1,000,000 / (1.07)^30 = $131,367

## Risk Assessment

### Risk Tolerance Questionnaire

**Investment Timeline**:
- < 3 years: Conservative (minimal stock exposure)
- 3-10 years: Moderate (balanced allocation)
- 10+ years: Can tolerate higher risk/volatility

**Emotional Capacity**:
- How would you react to 20% portfolio decline?
  - Panic sell: Low risk tolerance
  - Hold steady: Moderate risk tolerance
  - Buy more: High risk tolerance

**Financial Capacity**:
- Emergency fund: 6+ months = higher capacity
- Stable income: Higher capacity
- Major expenses coming: Lower capacity
- Other income sources: Higher capacity

### Risk vs. Return Trade-off

**General Principle**: Higher potential returns require accepting higher volatility and loss potential.

**Historical Annual Returns** (US markets, 1926-2023):
- Stocks: ~10% (with high volatility)
- Bonds: ~5-6% (with low volatility)
- Cash: ~3% (with minimal volatility)

**Inflation**: ~3% average
- Investments must outpace inflation to build real wealth
- Cash loses purchasing power over time
