# Bass Progress Tracking

Reference for file structure and logging format.

## Workspace Structure

```
~/bass/
├── repertoire.md      # Songs learned and in progress
├── sessions/
│   └── YYYY-MM.md     # Monthly practice logs
├── technique.md       # Slap, fingerstyle, exercises
└── goals.md           # Short and long-term goals
```

## Repertoire Format

```markdown
# repertoire.md

## Currently Learning
- Billie Jean — Michael Jackson, started 2024-01-15
  - Struggle: keeping ghost notes consistent
  - Next: full song with track

- Teen Town — Weather Report, started 2024-02-01
  - Working on: 16th note stamina

## Completed
- Another One Bites the Dust — Queen (1 week)
- Come Together — Beatles (2 weeks)
- Money — Pink Floyd (odd time practice)

## Want to Learn
- Portrait of Tracy — Jaco (harmonics study)
- What Is Hip — Tower of Power (funk benchmark)
```

## Technique Tracking

```markdown
# technique.md

## Fingerstyle
- Two-finger alternating: clean at 120 BPM 16ths
- Three-finger: working on evenness
- Floating thumb: comfortable on 5-string

## Slap
- Basic thumb/pop: solid
- Double thumbing: inconsistent
- Left hand slap: not started

## Exercises in Rotation
- Chromatic 16ths with metronome
- Arpeggios through cycle of 4ths
- Ghost note patterns on one note
```

## Session Log Format

```markdown
# sessions/2024-02.md

## 2024-02-15 (40 min)
- Warm-up: chromatic 16ths, 100-120 BPM
- Billie Jean: full song 3x with track
- Ghost notes getting more consistent

## 2024-02-14 (30 min)
- Slap practice: thumb technique focus
- Double thumbing still uneven at speed
- Need to slow down and build back up
```

## Goals Format

```markdown
# goals.md

## This Month
- Clean 16ths at 130 BPM
- Billie Jean performance-ready
- Learn one Motown line per week

## Longer Term
- Comfortable with slap in a jam setting
- Read chord charts and walk bass lines
- Record a cover for YouTube
```

## Logging Triggers

Prompt user to log when:
- They mention practicing or jamming
- They learn a new song or technique
- They hit a new tempo milestone
- Weekly check-in if no recent logs
