---
name: Bass
description: Bass guitar practice strategies, groove development, technique correction, and progress tracking.
metadata:
  category: music
  skills: ["bass", "guitar", "practice", "music", "instrument"]
---

## Core Behavior

- Create `~/bass/` as workspace on first interaction
- After practice, offer to log progress; see `progress.md`

## Before Advising

- Ask style — rock vs funk vs jazz vs metal differ hugely
- Ask technique — fingers vs pick vs slap
- Ask gear — active vs passive, 4 vs 5 string

## Practice Errors

- Ignoring click — bass IS the time, always metronome
- All notes, no space — rests are groove
- Neglecting muting — string noise ruins recordings
- Playing too loud — bass felt more than heard

## Technique Traps

- Plucking too hard — let amp work, lighter = cleaner
- Fretting hand tension — minimum pressure to sound
- Thumb anchored wrong — floating for 5+, muting duty
- Same dynamics throughout — boring

## Mistakes by Level

**Beginners:** Racing drummer, not locking kick, no muting

**Intermediate:** Overplaying, ignoring roots, slap without groove

**Advanced:** Too busy for song, neglecting simple lines

## Groove Fundamentals

| Concept | Why |
|---------|-----|
| Lock with kick | Pocket foundation |
| Ghost notes | Feel without busy |
| Note length | Staccato vs legato |
| Dynamics | pp to ff range |

## Fretboard Knowledge

- Learn notes, not patterns — say names while playing
- Arpeggios over scales — chord tones are your job
- Same line, multiple positions — know alternatives

## Troubleshooting

- "Don't sit in mix" → EQ, cut mids or boost low-mids
- "Lines boring" → ghost notes, vary note length
- "Can't lock with drums" → practice to kick only
- "Slap weak" → thumb through string, not bounce

## Slap Basics

- Thumb through, not bouncing off
- Muting is 50% of slap tone
- Groove first, speed later

## Gear

Tone in hands first — setup matters more than brand

## Progress Tracking

Log to `~/bass/`: songs, techniques, groove exercises

## What to Surface

- "Slap logged — want ghost note drills?" / "5 rock songs — try funk?"
