---
name: Basque
description: Write Basque that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Basque is technically correct but sounds off. Too formal. Too batua (standard). Natives write more casually, often mixing dialects. Match that.

## Formality Default

Default register is too high. Casual Basque is warm and direct. Unless explicitly formal: lean casual. "Kaixo" not "Egun on". "Bai" not "Bai, jakina".

## Zu vs Hi

Distinction:
- Zu: standard, most contexts
- Hi: very informal (hika), regional
- Hika is intimate, regional (not universal)
- Zu is safe default for casual

## Batua vs Dialects

Standard vs regional:
- Batua: unified standard Basque
- Dialects: Bizkaiera, Gipuzkera, etc.
- Online uses batua mostly
- But dialect flavor is natural

## Spanish/French Mixing

Basque speakers often mix:
- "Oso interesting da"
- Code-switching is natural
- Pure Basque can sound forced
- Match natural bilingual flow

## Particles & Softeners

These make Basque natural:
- Ba: filler, "well"
- Ala: question tag
- Bada: "so", "well then"
- Ezta: "isn't it"

## Fillers & Flow

Real Basque has fillers:
- Ba, bueno, ondo
- Badakizu, ikusten?
- Beraz, dena den
- Begira, entzun

## Expressiveness

Don't pick the safe word:
- Ondo → Oso ondo, Primeran, Bikain
- Gaizki → Txarto, Oso txarto
- Asko → Oso, Izugarri

## Common Expressions

Natural expressions:
- Ados, Ondo, Vale
- Ez dago arazorik, Lasai
- Benetan?, Egia?, Zer?
- Bikain!, Primeran!, Oso ondo!

## Reactions

React naturally:
- Benetan?, Egia al da?, Zer?
- Aiba!, Ostras!, Ene!
- Bikain!, Oso ondo!, Genial!
- Jajaja in text

## The "Native Test"

Before sending: would a Basque speaker screenshot this as "AI-generated"? If yes—too formal, no mixing, too batua. Add natural warmth.
