# Market Research via Bankr

Use Bankr's AI-powered analysis for trading decisions.

## Quick Commands

### Price Data
```bash
"What's the price of TOKEN on Base?"
"Current price of ETH"
"TOKEN price in USD"
```

### Market Data
```bash
"Show me TOKEN market data"
"What's the market cap of TOKEN?"
"Trading volume for TOKEN"
```

### Technical Analysis
```bash
"Do technical analysis on TOKEN"
"Show RSI for TOKEN"
"Is TOKEN overbought?"
"Support and resistance levels for TOKEN"
"Moving averages for TOKEN"
```

### Sentiment
```bash
"What's the sentiment on TOKEN?"
"Social metrics for TOKEN"
"Twitter mentions of TOKEN"
```

### Discovery
```bash
"What tokens are trending on Base?"
"Show top gainers today on Base"
"Top losers in the last 24 hours"
"New tokens on Base"
```

### Comparison
```bash
"Compare TOKEN1 vs TOKEN2"
"Which is better: TOKEN1 or TOKEN2?"
```

## Data Available

### Price Information
- Current USD price
- 24h / 7d / 30d change
- All-time high/low
- Historical prices

### Market Metrics
- Market cap
- Fully diluted valuation (FDV)
- 24h trading volume
- Circulating supply
- Number of holders

### Technical Indicators
- RSI (Relative Strength Index)
  - <30 = Oversold (potential buy)
  - >70 = Overbought (potential sell)
- MACD (trend momentum)
- Moving averages (50-day, 200-day)
- Support/resistance levels
- Volume analysis

### Social Metrics
- Twitter mentions
- Community sentiment
- Social volume trends

## Pre-Trade Checklist

Before any trade, run:

```bash
# 1. Current price
"What's the price of TOKEN on Base?"

# 2. Technical analysis
"Do technical analysis on TOKEN"

# 3. Market context
"What tokens are trending on Base?"

# 4. Liquidity check (via DEX)
"What's the liquidity for TOKEN on Base?"
```

## Interpreting Results

### Bullish Signals
- RSI < 30 (oversold)
- Price above 50-day MA
- Increasing volume
- Positive sentiment
- Higher lows forming

### Bearish Signals
- RSI > 70 (overbought)
- Price below 50-day MA
- Decreasing volume
- Negative sentiment
- Lower highs forming

### Neutral/Wait
- RSI 40-60
- Price at MA (testing)
- Flat volume
- Mixed sentiment

## Research Workflow

### Quick Analysis (2 min)
1. Price + 24h change
2. Quick TA (RSI, trend)
3. Trending status

### Deep Analysis (10 min)
1. Full technical analysis
2. Sentiment check
3. Compare to similar tokens
4. Check volume trends
5. Review holder data

### Due Diligence (30+ min)
1. All above plus:
2. Contract verification
3. Team research
4. Community review
5. Tokenomics analysis
6. Historical price patterns
