# User Type Adaptations

## First-Time Taker

**Context:** Recent law school grad, taking bar for first time.

**Priorities:**
- Build structured study schedule
- Don't rely on law school knowledge — bar tests differently
- Start MBE practice early
- Learn essay format (IRAC) from scratch
- Take at least 2 full simulated exams

**Common mistakes:**
- Underestimating the volume of material
- Starting essay practice too late
- Not doing enough full-length practice tests
- Burnout from 10+ hour study days

**Approach:**
- 8-10 weeks minimum prep
- 6-8 hours/day study
- Commercial course (Barbri, Themis) strongly recommended
- Weekly progress reviews

## Retaker

**Context:** Failed previous attempt, preparing to retake.

**Priorities:**
- Diagnose WHY they failed (MBE? Essays? Both?)
- Don't repeat same prep strategy that didn't work
- Target specific weak areas
- Address psychological barriers (test anxiety, burnout)

**First step:** Get score breakdown from previous attempt.

| If failed because | Focus on |
|-------------------|----------|
| Low MBE | Subject-specific drilling, timing |
| Low essays | Issue spotting, IRAC structure |
| Low MPT | Format compliance, time management |
| Barely missed | Likely all areas, build buffer |

**Approach:**
- Different prep course or method than before
- More practice tests, fewer passive lectures
- Study group or tutor for accountability
- Mental health support — retaking is stressful

## Attorney Transfer (UBE Score Transfer)

**Context:** Licensed attorney moving to new UBE jurisdiction.

**Priorities:**
- Confirm score transfers to target jurisdiction
- Check if additional requirements (MPRE, character & fitness)
- No new exam prep if score qualifies

**UBE transfer requirements:**
1. UBE score above jurisdiction threshold
2. Score typically valid 3-5 years
3. May need to meet CLE requirements
4. Character & fitness review still required

## International Attorney (Foreign-Trained)

**Context:** Lawyer trained outside US seeking US bar admission.

**Priorities:**
- Confirm eligibility (varies wildly by state)
- LLM may be required (NY, CA have pathways)
- Start early — US legal system is different
- Focus heavily on MBE subjects not tested abroad

**Unique challenges:**
- Common law vs civil law differences
- US constitutional law unfamiliar
- Legal writing style differs
- May need extra time for English legal terminology

**States with international pathways:**
- New York (LLM pathway)
- California (attorney examination)
- DC (relatively accessible)

## Bar Prep Tutor

**Context:** Tutoring others for bar exam.

**Priorities:**
- Track multiple students' progress
- Identify common weakness patterns
- Provide targeted essay feedback
- Help with time management and anxiety

**Tutor workflow:**
- Weekly check-ins per student
- Review practice test results together
- Focus feedback on issue spotting
- Adjust approach based on learning style

## Parent/Supporter

**Context:** Supporting someone preparing for bar.

**Priorities:**
- Understand the timeline and stress level
- Provide practical support (meals, quiet environment)
- Know when to encourage vs when to give space
- Recognize burnout signs

**Timeline awareness:**
- 8-12 weeks of intensive prep
- Final 2 weeks are highest stress
- Results take 8-10 weeks after exam
- Plan for emotional support either way
