# Progress Tracking System

## What to Track

### MBE Practice
```markdown
## Session Log

| Date | Subject | Questions | Correct | % | Time | Notes |
|------|---------|-----------|---------|---|------|-------|
| 2024-01-15 | Contracts | 34 | 22 | 65% | 61min | Weak on UCC |
```

### Essay Practice
```markdown
## Essay Log

| Date | Subject(s) | Score | Issues Missed | Time | Notes |
|------|------------|-------|---------------|------|-------|
| 2024-01-16 | Wills + Trusts | 4/6 | Anti-lapse | 28min | Forgot to check beneficiary predeceased |
```

### MPT Practice
```markdown
## MPT Log

| Date | Task Type | Score | Format Issues | Time | Notes |
|------|-----------|-------|---------------|------|-------|
| 2024-01-17 | Client Letter | 5/6 | Too formal | 88min | Good time management |
```

## Score Interpretation

### MBE Percentages
| Percentage | Meaning |
|------------|---------|
| < 55% | Danger zone — need major subject work |
| 55-62% | Below passing — targeted improvement needed |
| 63-68% | Passing range for most jurisdictions |
| 69-75% | Comfortable buffer |
| > 75% | Strong performance |

### UBE Score Estimation
Rough formula: `(MBE scaled score) + (Written scaled score) = UBE score`

Target: Whatever your jurisdiction requires + 10-point buffer.

## Weekly Review Questions

1. Which MBE subject has the lowest percentage?
2. How many essays have I written this week?
3. Am I hitting 30-minute essay timing?
4. What issue type do I keep missing?
5. Am I doing full-length simulated sessions?

## Red Flags

- **Same subject consistently low** — Need more time on fundamentals
- **Timing always off** — Practice under pressure, use timer
- **Essays missing issues** — Slow down, use checklist
- **MPT incomplete** — Work on document structure first
- **No simulated exams** — Can't pass without full-length practice

## Milestone Checkpoints

| Weeks Out | Target |
|-----------|--------|
| 12 weeks | Complete all subject outlines |
| 8 weeks | MBE average 60%+ |
| 6 weeks | First full simulated exam |
| 4 weeks | MBE average 65%+, essays hitting issues |
| 2 weeks | Final simulated exam, light review |
| 1 week | Rest, light review, logistics prep |
