# MPT Strategy

## What is the MPT?

Multistate Performance Test — you get a case file and must produce a legal document. Tests practical lawyering skills, not subject knowledge.

**Key advantage:** All law is provided in the materials. No memorization required.

## Task Types

| Type | What You Write |
|------|----------------|
| Persuasive brief | Argue for your client |
| Objective memo | Analyze strengths and weaknesses |
| Client letter | Explain legal situation in plain English |
| Discovery plan | Identify what evidence to gather |
| Contract/statute drafting | Write or revise legal language |
| Closing argument | Persuade fact-finder |

## Materials Provided

### File (Client Materials)
- Retainer letter or memo from partner
- Client interview transcript
- Witness statements
- Relevant documents (contracts, emails, etc.)

### Library (Legal Materials)
- Cases (usually 2-3)
- Statutes (sometimes)
- Secondary sources (occasionally)

## Critical Process

1. **Read the task memo FIRST** (5 min)
   - What document type?
   - Who is the audience?
   - What specific questions to address?
   
2. **Skim the library** (15 min)
   - Identify applicable rules
   - Note case holdings
   - Mark key statutory language
   
3. **Read the file** (15 min)
   - Connect facts to rules
   - Note which facts are disputed
   - Identify missing information
   
4. **Outline** (10 min)
   - Structure based on task requirements
   - Match facts to each rule element
   
5. **Write** (35 min)
   - Follow the format exactly
   - Cite to case names from library
   - Use facts from file
   
6. **Review** (10 min)
   - Check that all task requirements addressed
   - Verify format compliance

## Format Traps

- **Ignoring format instructions** — If memo asks for 3 sections, use 3 sections
- **Making up law** — Use ONLY the law in the library
- **Missing facts** — Every relevant fact should appear somewhere
- **Wrong audience tone** — Brief ≠ client letter
- **No case citations** — Always cite the library cases

## Scoring Reality

MPT is often the highest-ROI section because:
- Most students underestimate/underprepare
- Format compliance alone earns points
- No memorization required
- Skill transfers across any prompt

**Target:** Complete, formatted answer using all materials > perfect partial answer.

## Practice Method

1. Do MPT under timed conditions (90 min)
2. Compare to sample answers (available from NCBE)
3. Focus on: Did I use all the cases? Did I follow the format? Did I address every task element?
