# MEE Essay Strategy

## IRAC Structure (Non-Negotiable)

Every essay answer follows this structure:

```
ISSUE: [One sentence identifying the legal question]

RULE: [State the applicable rule of law]

ANALYSIS: [Apply the rule to these specific facts]

CONCLUSION: [Answer the question asked]
```

## Issue Spotting

Essays test issue spotting more than legal knowledge. Scoring breakdown:
- **Issue identification:** 40% of points
- **Rule statement:** 20% of points
- **Analysis:** 30% of points
- **Conclusion:** 10% of points

**Miss an issue = lose all points for that issue.**

## MEE Subject Coverage

| Subject | Frequency | Notes |
|---------|-----------|-------|
| Wills/Trusts | Very high | Almost every exam |
| Family Law | High | Custody, divorce, property |
| Business Associations | High | Corps, partnerships, LLCs |
| Secured Transactions | Medium | UCC Article 9 |
| Conflict of Laws | Medium | Choice of law analysis |
| Agency | Medium | Often combined with other topics |

## Writing Traps

- **Rambling rule statements** — Be concise, not comprehensive
- **Analysis without facts** — Quote specific facts from the prompt
- **Hedging conclusions** — Take a position, even if close call
- **Missing crossover issues** — Essays often combine 2-3 subjects
- **Time misallocation** — 30 minutes means 30 minutes, not 45

## Sample Analysis Flow

**Prompt:** "Did the husband breach his fiduciary duty?"

❌ Wrong: "Fiduciary duties are important in many contexts..."

✅ Right: "ISSUE: Whether H breached fiduciary duty by investing trust funds in his own business. RULE: A trustee owes a duty of loyalty and may not self-deal without beneficiary consent. ANALYSIS: H invested $50k of trust funds in his own LLC without notifying the beneficiaries. This is classic self-dealing. Even if the investment was profitable, the conflict of interest establishes breach. CONCLUSION: H breached his fiduciary duty."

## Time Management

| Task | Time |
|------|------|
| Read prompt | 3 min |
| Outline issues | 5 min |
| Write | 20 min |
| Review | 2 min |

**6 essays × 30 min = 3 hours exactly. No margin for error.**

## Essay Types

1. **Pure analysis** — Apply law to facts, reach conclusion
2. **Role-play** — Write as attorney advising client
3. **Dispute resolution** — Multiple parties, analyze each side
4. **Memorandum** — Formal memo format expected
