# MBE Strategy

## Core Approach

The MBE tests issue recognition, not memorization. Most questions test:
1. Can you spot the legal issue?
2. Do you know the rule?
3. Can you apply it to these facts?

## Subject-Specific Traps

### Contracts
- **Statute of Frauds** — Marriage, Year, Land, Executor, Goods $500+ (MYLEG)
- **UCC vs Common Law** — Goods = UCC, services/land = common law
- **Mailbox rule** — Acceptance effective on dispatch; revocation on receipt
- **Consideration trap** — Past consideration is no consideration

### Evidence
- **Hearsay within hearsay** — Both layers need exceptions
- **Character evidence** — Civil: rarely allowed. Criminal: defendant opens door
- **Present sense impression vs excited utterance** — Timing is everything
- **Expert witness** — Daubert standard, reliable methodology

### Constitutional Law
- **State action requirement** — Private actors rarely trigger constitutional claims
- **Strict scrutiny triggers** — Suspect class or fundamental right
- **Commerce clause** — If economic activity affects interstate commerce, federal power
- **Dormant commerce clause** — States can't discriminate against interstate commerce

### Property
- **Future interests** — RAP applies to contingent remainders, executory interests
- **Recording acts** — Race, notice, race-notice (know your jurisdiction)
- **Easements** — Creation: express, implied, necessity, prescription
- **Adverse possession** — OCEAN: Open, Continuous, Exclusive, Adverse, Notorious

### Torts
- **Negligence per se** — Statute violation = breach, but still need causation
- **Strict liability** — Animals, abnormally dangerous activities, products
- **Vicarious liability** — Respondeat superior requires scope of employment
- **Intentional infliction** — Extreme and outrageous, not just offensive

### Criminal Law
- **Attempt** — Substantial step toward completion
- **Conspiracy** — Agreement + overt act (in most jurisdictions)
- **Felony murder** — Inherently dangerous felony (BARRK: Burglary, Arson, Robbery, Rape, Kidnapping)
- **Mens rea matching** — Purpose vs knowledge vs recklessness vs negligence

### Civil Procedure
- **Personal jurisdiction** — Minimum contacts + fair play
- **SMJ** — Federal question or diversity (complete diversity, $75k+)
- **Erie doctrine** — Substantive state law, procedural federal law
- **Joinder** — Compulsory vs permissive counterclaims

## Practice Strategy

1. **Do questions by subject first** — Master one area before mixing
2. **Review wrong answers thoroughly** — Understand WHY the wrong answer was wrong
3. **Track patterns** — Same traps appear repeatedly
4. **Simulate full sessions** — 100 questions, 3 hours, no breaks
5. **Target 65-70%** — That's passing territory for most jurisdictions
