---
name: notion
category: minimal
---

# Notion Style

Minimalist hand-drawn line art, intellectual aesthetic.

## Element Combination

```yaml
canvas:
  ratio: portrait-3-4
  grid: single | dual

image_effects:
  cutout: clean
  stroke: none | white-solid
  filter: none | muted-tones

typography:
  decorated: none | handwritten
  tags: black-white | pill
  direction: horizontal

decorations:
  emphasis: circle-mark | underline
  background: solid-white | paper-texture
  doodles: hand-drawn-lines | arrows-curvy
  frames: none | rounded-rect
```

## Color Palette

| Role | Colors | Hex |
|------|--------|-----|
| Primary | Black, dark gray | #1A1A1A, #4A4A4A |
| Background | Pure white, off-white | #FFFFFF, #FAFAFA |
| Accents | Pastel blue, pastel yellow, pastel pink | #A8D4F0, #F9E79F, #FADBD8 |

## Visual Elements

- Simple line doodles, hand-drawn wobble effect
- Geometric shapes, stick figures
- Maximum whitespace, single-weight ink lines
- Clean, uncluttered compositions

## Typography

- Clean hand-drawn lettering
- Simple sans-serif labels
- Minimal decoration on text

## Best Layout Pairings

| Layout | Compatibility | Use Case |
|--------|---------------|----------|
| sparse | ✓✓ | Concept covers |
| balanced | ✓✓ | Standard explanations |
| dense | ✓✓ | Knowledge cards, cheat sheets |
| list | ✓✓ | Productivity tips, tool lists |
| comparison | ✓✓ | Data comparisons |
| flow | ✓✓ | Process diagrams |

## Best For

- Knowledge sharing
- Concept explanations
- SaaS content
- Productivity tips
- Tech tutorials
- Professional content
