---
name: 游戏状态管理
description: 查看和管理当前游戏状态，包括进度、角色存活情况、收集的线索等
---

# 游戏状态管理

## 功能说明

这个skill用于查看和管理《恐怖惊魂夜》的游戏状态。玩家可以随时调用查看当前进度、存活角色、收集的线索等信息。

## 使用方式

玩家可以通过自然语言请求查看状态：
- "查看游戏状态"
- "我现在在哪个章节？"
- "还有谁活着？"
- "我收集了哪些线索？"

## 系统指令

### 执行流程

1. **读取游戏状态文件**
   - 读取 `game_state.json`
   - 如果文件不存在，提示玩家尚未开始游戏

2. **根据玩家请求展示信息**
   - 如果玩家未指定具体内容，展示完整状态概览
   - 如果玩家询问特定信息（如线索、角色等），只展示相关部分

3. **格式化输出**
   - 使用清晰的markdown格式
   - 重要信息用**加粗**标注
   - 使用列表和表格提升可读性

### 状态信息分类

#### 基本信息
```
📍 当前位置：第X章 - 章节名称
⏰ 游戏时间：第X天 XX点
🎮 版本：v0.0.2
```

#### 角色状态
```
✅ 存活角色（X人）：
- 透（主角）
- 真理
- ...

💀 已死亡角色（X人）：
- 田中一郎
- ...

🤕 受伤角色：
- XX（伤势描述）
```

#### 线索收集
```
🔍 已收集线索（X条）：

【关键线索】
- 线索1：描述
- 线索2：描述

【普通线索】
- 线索3：描述
- ...
```

#### 信任与嫌疑
```
🤝 信任度：
- 真理：❤️❤️❤️❤️❤️ (100)
- 小林敏夫：❤️❤️ (40)
- ...

🎯 嫌疑度：
- 大阪绫子：⚠️⚠️⚠️ (30)
- 佐藤健：⚠️⚠️ (20)
- ...
```

#### 发现的秘密
```
🔓 已揭露秘密：
- 小林夫妇收受贿赂
- 田中一郎是私家侦探
- ...
```

#### 玩家选择历史
```
📝 关键决定：
1. 第0章：选择仔细调查现场
2. 第1A章：发现可疑人影
...
```

### 特殊功能

#### 状态保存提醒
如果玩家长时间未保存，提示：
```
💾 提示：你已经游玩了X分钟，建议保存游戏进度。
当前进度会自动保存在 game_state.json 文件中。
```

#### 章节进度可视化
```
📊 章节进度：
✅ 第00章：惊魂夜幕
✅ 第1A章：密室搜证
🔄 第2A章：雪夜追凶（当前）
⬜ 第3章：待探索
⬜ 第4章：结局
```

#### 成就追踪（可选）
```
🏆 解锁成就：
✅ 初入旅馆 - 开始游戏
✅ 细心观察 - 发现5条线索
⬜ 推理大师 - 成功推理凶手
⬜ 完美侦探 - 达成完美结局
```

## 输出示例

### 完整状态概览

```markdown
# 《恐怖惊魂夜》游戏状态

## 📍 当前进度
- **章节**：第1A章 - 密室搜证
- **时间**：第一天 晚上11点
- **心理状态**：85/100
- **版本**：v0.0.2

---

## 👥 角色状态

### ✅ 存活（9人）
透（主角）、真理、小林敏夫、小林惠子、佐藤健、铃木美香、田边晃、大阪龙一、大阪绫子

### 💀 已死亡（1人）
田中一郎（第0章，晚上9点）

---

## 🔍 已收集线索（5条）

**【关键线索】**
1. 专业切割手法 - 尸体切口异常整齐
2. 窗外脚印 - 男性，体重较重

**【普通线索】**
3. 预告纸条 - 打印的，普通A4纸
4. 破碎的窗户 - 从内部打破
5. 田中的公文包 - 散落着文件

---

## 🤝 人际关系

**信任度 TOP3**
- 真理：100 ❤️❤️❤️❤️❤️
- 小林惠子：50 ❤️❤️❤️
- 田边晃：45 ❤️❤️

**嫌疑度 TOP3**
- 大阪绫子：20 ⚠️⚠️
- 佐藤健：15 ⚠️
- 小林敏夫：10 ⚠️

---

## 🔓 已揭露秘密（0个）
暂无发现特殊秘密。继续探索可能会有新发现...

---

💡 **提示**：你可以随时使用本skill查看状态，或询问特定信息：
- "我收集了哪些线索？"
- "谁的嫌疑最大？"
- "真理对我的信任度怎么样？"
```

### 特定信息查询

**玩家："我收集了哪些线索？"**

```markdown
🔍 **已收集线索（5条）**

**【关键线索】**
1. **专业切割手法**
   发现位置：田中的房间
   描述：尸体的切口异常平整，显示凶手可能有专业技能或医学背景

2. **窗外脚印**
   发现位置：田中房间窗外
   描述：雪地中有清晰脚印，男性，鞋码约43-44，体重较重

**【普通线索】**
3. 预告纸条 - 打印的威胁信息
4. 破碎的窗户 - 凶手可能的逃跑路线
5. 田中的公文包 - 包含调查资料

💡 你还可以：
- 在各章节中主动探索获得更多线索
- 使用"推理系统"skill尝试指认凶手
```

## 注意事项

1. **不剧透**：只展示玩家已经发现的信息，不透露未来剧情
2. **鼓励探索**：适当提示玩家还有未发现的内容
3. **清晰易读**：使用emoji和格式化增强可读性
4. **响应式**：根据玩家的具体问题提供针对性信息

## 与其他Skills的配合

- 配合 **clue_system** - 查看线索详情
- 配合 **character_info** - 查看角色详细信息
- 配合 **reasoning** - 基于收集的线索进行推理
- 配合章节Skills - 了解当前可以做什么

---

**这是一个纯信息查询skill，不会修改游戏状态，玩家可以随时安全调用。**
