---
name: 线索系统
description: 查看已收集的线索详情，分析线索之间的关联，帮助推理
---

# 线索系统

## 功能说明

这个skill帮助玩家管理和分析收集到的线索。可以查看线索详情、发现线索之间的关联、按类别筛选等。

## 使用方式

玩家可以：
- "查看所有线索"
- "这条线索是什么意思？"
- "有哪些线索指向XX？"
- "分析线索之间的关系"
- "哪些是关键线索？"

## 系统指令

### 执行流程

1. **读取线索数据**
   - 从 `game_state.json` 读取 `collected_clues`
   - 获取玩家当前章节和进度

2. **根据请求提供信息**
   - 展示线索列表或详情
   - 分析线索关联
   - 按分类或重要性筛选

3. **提供分析提示**
   - 不直接说出答案
   - 引导玩家思考线索意义
   - 暗示可能的关联

### 线索数据结构

每条线索包含：
```json
{
  "id": "clue_01",
  "name": "专业切割手法",
  "description": "尸体的切口异常平整，显示凶手有专业技能或医学背景",
  "importance": "关键",
  "found_in": "ch1a_investigate",
  "found_at": "第一天晚上10点30分",
  "category": "物证",
  "points_to": ["职业杀手", "医生", "解剖学专业"],
  "related_clues": ["clue_02", "clue_15"],
  "真实性": "真实"
}
```

### 线索分类

#### 按重要性
- 🔴 **关键线索**：直接指向真相
- 🟡 **重要线索**：提供重要信息
- 🟢 **次要线索**：辅助推理

#### 按类型
- 📄 **物证**：物理证据
- 💬 **证词**：角色陈述
- ❗ **矛盾**：逻辑漏洞
- 🔒 **隐藏**：特殊发现

#### 按指向
- 指向特定角色
- 指向特定事件
- 指向动机
- 指向作案方式

## 输出格式

### 完整线索列表

```markdown
# 📋 线索收集清单

> 当前收集：12条线索 | 关键：3条 | 重要：5条 | 次要：4条

---

## 🔴 关键线索

### 1. 专业切割手法
- **类型**：物证
- **发现**：第1A章 - 田中的房间
- **描述**：尸体被极其精准地切割，切口平整如镜。这需要专业工具和解剖学知识。
- **可能指向**：
  - 凶手有医学背景
  - 或使用了专业解剖工具
  - 或有相关职业训练
- **关联线索**：→ #2窗外脚印, → #15工具箱

**你的思考**：_什么职业的人会有这种能力？_

---

### 2. 窗外脚印
- **类型**：物证
- **发现**：第1A章 - 田中房间窗外
- **描述**：雪地中的脚印，鞋码约43-44，步幅显示体重较重，是男性。
- **可能指向**：
  - 排除女性和体型较小的男性
  - 凶手从窗户逃离
- **关联线索**：→ #1专业切割, → #4破碎窗户
- **矛盾点**：但这是二楼，如何安全跳下？

---

### 3. 备用钥匙遗失
- **类型**：物证
- **发现**：第1A章 - 前台钥匙板
- **描述**：202房（田中房间）的备用钥匙不见了。
- **可能指向**：
  - 凶手拿走了钥匙
  - 解释了密室如何进入
- **关联线索**：→ #7门锁完好
- **嫌疑人**：谁有机会接近钥匙板？

---

## 🟡 重要线索

### 4. 破碎的窗户
- **类型**：物证
- **描述**：窗户从内部打破，玻璃碎片在窗外。
- **意义**：凶手的逃跑路线？

### 5. 预告纸条
- **类型**：物证
- **描述**：打印的威胁信，A4纸，黑体字。
- **疑问**：打印机在哪？谁能接触到？

...(其他线索)

---

## 🔗 线索关联图

```
密室杀人
    ├─ 备用钥匙遗失 (#3) → 如何进入
    ├─ 门锁完好 (#7) → 没有被撬
    └─ 窗户破碎 (#4) → 如何逃离
           └─ 窗外脚印 (#2) → 男性，体重重

凶手特征
    ├─ 专业切割 (#1) → 医学背景？
    ├─ 脚印尺码 (#2) → 男性，体重重
    └─ 冷静预谋 (#5) → 提前计划
```

---

## 💡 分析提示

**已发现的矛盾**：
1. 窗户在二楼，但凶手似乎安全跳下了？
2. 门反锁，但凶手如何进入？
3. 切割很专业，但为什么如此残忍？

**待解之谜**：
- 20年前的事故是什么？
- 田中在调查什么？
- "S先生"是谁？

**推理方向**：
你可以尝试将线索组合起来，看看能推导出什么...

---

📌 **建议行动**：
- 继续探索获得更多线索
- 询问可疑角色
- 使用 `reasoning` skill 尝试推理
```

### 特定线索详情

**玩家："这条线索是什么意思？（专业切割）"**

```markdown
# 🔍 线索详细分析

## 线索 #1：专业切割手法

### 📝 基本信息
- **重要性**：🔴 关键线索
- **类型**：物证
- **发现地点**：第1A章 - 田中一郎的房间
- **发现时间**：第一天晚上10点30分

### 📄 详细描述

田中一郎的尸体被切割成多块。你作为心理学专业的学生，虽然不是法医，但仍能观察到一些细节：

1. **切口特征**
   - 切口异常平整，像是一刀切下
   - 没有锯齿状的撕裂痕迹
   - 切割位置精准，沿着关节和骨骼的自然分界线

2. **专业性分析**
   - 这不是普通的刀具能做到的
   - 需要了解人体解剖结构
   - 可能使用了医用手术刀或解剖用具

### 🎯 可能指向

这条线索暗示凶手可能：
- 有**医学背景**（医生、护士、医学生）
- 从事**相关职业**（法医、兽医、解剖学研究）
- 接受过**特殊训练**（军事、特工？）
- 或者拥有**专业工具**

### 🔗 关联线索

这条线索与以下线索相关：
- **#2 窗外脚印** - 凶手的体型特征
- **#15 工具箱**（如果发现）- 可能的凶器来源

### ⚠️ 需要注意

- 专业手法 ≠ 一定是医生，也可能是伪装
- 这种切割方式传达某种**信息**吗？
- 为什么选择这种残忍的方式？

### 💭 推理思考

**问自己**：
1. 旅馆里有谁符合这个特征？
2. 这种切割与20年前的事故有关吗？
3. 凶手想通过这种方式表达什么？

---

💡 继续探索，寻找更多线索，也许能解开这个谜团...
```

### 线索关联分析

**玩家："分析线索之间的关系"**

```markdown
# 🔗 线索关联分析

## 发现的线索网络

### 🏠 密室杀人之谜

**核心问题**：凶手如何在密室中杀人并逃离？

```
线索链：
进入方式
  └─ #3 备用钥匙遗失
      ├─ 谁能接触到钥匙？
      └─ #7 门锁完好无损

逃离方式
  └─ #4 窗户从内打破
      ├─ #2 窗外有脚印（男性，体重重）
      └─ 问题：二楼如何安全落地？
```

**矛盾点**：
- 如果凶手从窗户逃走，为什么没有摔伤？
- 还是说...有其他逃离路线？

---

### 🔪 凶手特征画像

基于已有线索，凶手可能具有以下特征：

**生理特征**：
- #2 → 男性（脚印尺码43-44）
- #2 → 体重较重（脚印深度）
- 身高估计：175-185cm

**能力特征**：
- #1 → 专业技能（医学/解剖学知识）
- #1 → 拥有或能接触专业工具
- #5 → 预谋性强（提前发预告）

**性格特征**：
- #1 → 极度冷静（切割时无失误）
- #5 → 自信或挑衅（敢于发预告）
- 可能有强烈动机（如此残忍的手法）

---

### 🎯 嫌疑人筛选

基于上述特征，对照旅馆内的人：

**符合生理特征的**：
- 小林敏夫 ✓ （男性，体型符合）
- 佐藤健 ✓ （男性，体型符合）
- 田边晃 ✓ （男性，但体型偏瘦）
- 大阪龙一 ✓✓ （男性，体格魁梧，非常符合）

**可能有专业知识的**：
- ？？？（还需要更多线索）

**有接触钥匙机会的**：
- 小林夫妇 ✓✓ （管理钥匙）
- 其他人 ？（需要偷窃）

---

### ⚠️ 误导性线索警告

以下线索可能是误导：
- #5 预告纸条的时间（说12点，但9点就发生了）
  - 为什么提前？失控了？还是故意误导？

---

### 🧩 待填补的空白

要完成拼图，你还需要：
1. **动机** - 为什么杀田中？
2. **工具来源** - 凶器在哪？
3. **20年前的事故** - 与本案有何关系？
4. **"S先生"** - 神秘人物的身份

---

💡 **建议**：
- 深入调查符合特征的嫌疑人
- 寻找关于20年前事故的更多信息
- 注意观察谁有不在场证明，谁没有
```

## 特殊功能

### 线索可视化
使用ASCII图表展示线索关系：
```
        [密室之谜]
       /          \
   [进入]        [逃离]
     |              |
  [钥匙]       [窗户+脚印]
     |              |
   [嫌疑]        [体型]
```

### 智能提示
根据玩家卡关情况提供渐进式提示：
- 第1次查看：只展示线索内容
- 第2次查看：提供一些关联暗示
- 第3次查看：给出更明显的推理方向

### 线索更新通知
当玩家发现新线索时：
```
🔔 线索更新！
你发现了新线索：#8 录音笔
这可能与 #6 田中的调查 有关。

可以使用 clue_system skill 查看详情。
```

## 注意事项

1. **不剧透**：只分析已发现的线索，不透露未发现内容
2. **引导思考**：提供分析框架，但不直接给答案
3. **尊重推理**：如果玩家推理方向合理，鼓励继续
4. **动态调整**：根据玩家能力调整提示明显度

---

**这个skill是玩家的"推理笔记本"，帮助整理思路，但真相需要玩家自己发现。**
