---
name: 角色信息
description: 查看旅馆中每个角色的详细信息、背景故事、当前状态和你对他们的了解
---

# 角色信息

## 功能说明

这个skill提供旅馆中所有角色的信息查询功能。信息会根据玩家的探索进度动态更新——你了解得越多，看到的信息就越详细。

## 使用方式

玩家可以：
- "查看所有角色"
- "XX是什么人？"
- "告诉我关于XX的信息"
- "谁还活着？"
- "谁最可疑？"

## 系统指令

### 信息披露原则

**重要**：不要一次性展示所有信息！

信息分层：
1. **基本层**（初见）：姓名、年龄、外貌、第一印象
2. **了解层**（对话后）：性格、关系、表面背景
3. **深入层**（深度互动）：秘密暗示、可疑行为
4. **真相层**（特定剧情后）：完整背景、真实动机

根据 `game_state.json` 中的 `trust_levels` 和 `discovered_secrets` 判断展示哪一层。

### 执行流程

1. **读取游戏状态**
   - 获取当前章节和进度
   - 读取已解锁的角色信息
   - 读取信任度和嫌疑度

2. **根据请求展示信息**
   - 查看全部 → 列表概览
   - 查看特定角色 → 详细档案
   - 查看存活状态 → 存活/死亡列表

3. **动态更新提示**
   - 如果有新信息解锁，标注"🆕"
   - 如果某人有可疑行为，标注"⚠️"
   - 如果已死亡，标注"💀"

## 角色档案格式

### 完整角色列表

```markdown
# 👥 旅馆人物志

> 当前存活：9人 | 已死亡：1人

---

## 主要角色

### 透（主角）✨
**身份**：你自己
**心理状态**：85/100
**专长**：心理学分析

---

### 真理 ❤️
**关系**：你的女友
**信任度**：100/100 ❤️❤️❤️❤️❤️
**状态**：✅ 存活

初见印象：温柔善良，对你很依赖
已知信息：小时候常来旅馆，叔叔叔母经营这里
🔒 更多信息：需要深入对话解锁

---

### 小林敏夫 🤔
**身份**：旅馆老板
**信任度**：40/100 ❤️❤️
**嫌疑度**：15/100 ⚠️
**状态**：✅ 存活

初见印象：憨厚老实，沉默寡言
已知信息：似乎在回避某些话题，对地下室很敏感
🆕 新发现：录音中承认收受贿赂
⚠️ 可疑行为：提到旅馆历史时会迅速转移话题

_需要更多互动了解更多..._

---

### 小林惠子
**身份**：旅馆老板娘，真理的叔母
**信任度**：50/100
**状态**：✅ 存活

初见印象：热情好客，话多健谈
已知信息：容易紧张，总想转移话题
⚠️ 可疑：说话时眼神闪烁

---

### 佐藤健 🎭
**身份**：IT公司项目经理
**信任度**：25/100
**嫌疑度**：20/100 ⚠️⚠️
**状态**：✅ 存活

初见印象：领导型人格，总想控制局面
已知信息：来旅馆似乎是为了躲避什么
⚠️ 可疑：对现场调查异常积极
🔒 隐藏秘密：未解锁

---

### 铃木美香
**身份**：行政主管
**信任度**：40/100
**状态**：✅ 存活

初见印象：精明能干，观察力强
已知信息：似乎知道一些秘密
⚠️ 发现预告纸条的人

---

### 田边晃 🔧
**身份**：技术工程师
**信任度**：45/100
**嫌疑度**：18/100 ⚠️
**状态**：✅ 存活

初见印象：内向谨慎，技术宅
已知信息：暗恋铃木，对机械设备很在行
⚠️ 可疑：行为有时很神秘
🔒 重大秘密：未解锁（需要特定剧情）

---

### 大阪龙一 🍶
**身份**：建筑公司社长
**信任度**：30/100
**嫌疑度**：25/100 ⚠️⚠️⚠️
**状态**：✅ 存活

初见印象：豪爽大方，关西腔
已知信息：喜欢喝酒，但喝酒时手颤抖
🆕 新发现：他的公司承建了20年前的工程
⚠️ 高度可疑：与事故直接相关

---

### 大阪绫子 💊
**身份**：家庭主妇，大阪龙一的妻子
**信任度**：35/100
**嫌疑度**：30/100 ⚠️⚠️⚠️⚠️
**状态**：✅ 存活

初见印象：优雅端庄，但神经质
已知信息：常服用镇定剂，经常发呆
⚠️ 非常可疑：多项线索指向她
🔒 核心秘密：未完全解锁

---

### 田中一郎 💀
**身份**：私家侦探（伪装成自由职业者）
**状态**：💀 已死亡（第一天晚上9点）

生前印象：沉默冷酷，戴墨镜，生人勿近
已知真相：正在调查20年前的事故，是死者田中健司的弟弟
死因：被残忍切割，密室杀人

_他的死亡揭开了这场惨案的序幕..._

---

## 📊 关系图谱

```
修普尔旅馆
    ├─ 小林夫妇（经营者）
    │   └─ 真理（侄女）─ 透（男友）
    │
    ├─ 白领三人组
    │   ├─ 佐藤健（领导）
    │   ├─ 铃木美香 ← 田边晃（暗恋）
    │   └─ 田边晃
    │
    ├─ 关西夫妇
    │   ├─ 大阪龙一（丈夫）
    │   └─ 大阪绫子（妻子）
    │
    └─ 田中一郎（独行侦探）💀

20年前事故关联：
    大阪龙一 ─┐
    小林夫妇 ─┼─ 掩盖真相
    ???（S先生）─┘
              ↓
    田中健司（死者）→ 田中一郎（复仇者）
```

---

💡 **提示**：
- 提高信任度可以解锁更多信息
- 深入对话可能揭露隐藏秘密
- 观察可疑行为可能发现重要线索
```

### 特定角色详细档案

**玩家："告诉我关于大阪绫子的信息"**

```markdown
# 📋 角色档案：大阪绫子

## 基本信息

**姓名**：大阪绫子（Osaka Ayako）
**年龄**：53岁
**身份**：家庭主妇
**关系**：大阪龙一的妻子

---

## 外貌特征

- 身高约160cm，体态苗条
- 优雅端庄，穿着考究
- 头发梳得一丝不苟
- 但眼神时常空洞，像在思考或回忆什么

---

## 性格特点

**表面**：优雅、安静、有教养
**实际**：（根据探索进度逐步揭示）

- 敏感、神经质
- 容易受惊
- 似乎承受着巨大的心理压力

---

## 🔍 你对她的了解

### 初次见面（第0章）
你注意到她：
- 在晚餐时吃得很少
- 经常看向窗外，眼神空洞
- 手边有一个小药瓶——镇定剂
- 当有人提到"过去的事"时，她会明显紧张

### 深入观察（第1章+）
🆕 **新发现**：
- 她常常在深夜无法入睡
- 对田中一郎的死亡反应异常强烈
- 说梦话时提到"健司"这个名字（谁是健司？）

### 关键线索（第2章+）
⚠️ **重要信息**：
- 惠子的日记暗示：20年前有个女孩目睹了事故
- 那个女孩...会不会就是绫子？
- 如果是，她当时是旅馆的雇工？

### 真相（需要特定剧情解锁）
🔒 **核心秘密**（未完全解锁）
_继续探索以了解更多..._

---

## 📊 状态数据

**信任度**：35/100 ❤️❤️
- 她对你保持礼貌但疏离
- 不太愿意深入交谈
- 总是用"我身体不好"来回避问题

**嫌疑度**：30/100 ⚠️⚠️⚠️⚠️
- 多项线索指向她
- 行为异常
- 有接触钥匙的机会
- 与20年前事故可能有关

**心理状态**：估计低于50
- 长期服用镇定剂
- 情绪不稳定
- 可能有创伤后应激障碍

---

## 🤔 疑点分析

**支持她是凶手的证据**：
1. 可以接触备用钥匙（作为长期客人）
2. 与20年前事故可能有关联
3. 心理状态不稳定，有暴力倾向的可能
4. 服用镇定剂→ 可能用来迷晕受害者

**对她不利的行为**：
- 在田中死后异常紧张
- 避免谈论过去
- 丈夫提到旅馆历史时，她会打断

**但也有疑点**：
- 体型瘦小，能制造那些脚印吗？
- 有力气切割尸体吗？
- 动机到底是什么？

---

## 💭 心理分析（透的专业视角）

作为心理学学生，你的分析：

**可能的心理创伤**：
绫子表现出典型的PTSD症状——回避、过度警觉、情绪麻木。她可能在20年前目睹或经历了什么可怕的事。

**药物依赖**：
长期服用镇定剂说明她的焦虑已经非常严重。这种状态下，她的判断力可能受损。

**可能的动机**：
如果她真的与20年前的事故有关，田中一郎的出现可能触发了她的创伤记忆，导致...

但你需要更多证据来支持这个推测。

---

## 🎯 建议行动

想要了解更多关于绫子的信息，你可以：

1. **与她对话**
   - 选择合适的时机私下交谈
   - 用温和的方式询问她的过去
   - 观察她的反应和微表情

2. **调查她的物品**
   - 镇定剂的处方（医生是谁？）
   - 她的房间可能有日记或照片？

3. **询问其他人**
   - 问大阪龙一关于妻子的事
   - 问小林夫妇他们是否认识年轻时的绫子

4. **查找20年前的线索**
   - 那个目睹事故的女孩到底是谁
   - 她和死者田中健司的关系

---

**当前建议**：绫子是高度可疑对象，但不要过早下结论。继续收集证据。

🔍 使用 `clue_system` 查看与她相关的所有线索
⚖️ 使用 `reasoning` 进行推理（如果你认为已经有足够证据）
```

## 特殊功能

### 角色对比
**玩家："对比大阪绫子和小林惠子"**

```markdown
# ⚖️ 角色对比：大阪绫子 vs 小林惠子

## 共同点
- 都是女性
- 都与20年前的事故有可能的关联
- 都表现紧张
- 都有接触钥匙的机会

## 差异点

| 特征 | 大阪绫子 | 小林惠子 |
|------|----------|----------|
| **年龄** | 53岁 | 48岁 |
| **性格** | 优雅、神经质 | 热情、健谈 |
| **心理状态** | 极差（需药物） | 焦虑但可控 |
| **嫌疑度** | ⚠️⚠️⚠️⚠️ 30 | ⚠️⚠️ 10 |
| **可疑行为** | 多次异常表现 | 主要是紧张 |
| **动机** | 可能有强烈动机 | 动机不明确 |
| **能力** | 体型小，存疑 | 熟悉旅馆布局 |

## 分析
绫子的嫌疑明显更大，但惠子也不能完全排除...
```

### 关系网查询
**玩家："谁和田中一郎有关系？"**

```markdown
# 🕸️ 与田中一郎相关的人物

## 直接关系

### 田中健司（已故）
- **关系**：田中一郎的哥哥
- **情况**：20年前死于工程事故
- **影响**：田中一郎成为侦探，追查20年

## 间接关系（通过20年前事故）

### 小林夫妇
- **关系**：事故发生在他们的旅馆工地
- **涉及**：收受贿赂，掩盖真相
- **对田中的态度**：紧张、回避

### 大阪龙一
- **关系**：他的公司承建工程，事故责任方
- **涉及**：支付封口费
- **对田中的态度**：有些防备

### 大阪绫子
- **关系**：可能是事故目击者
- **情况**：传闻20年前是旅馆雇工
- **对田中的态度**：极度恐惧？

### 佐藤健
- **关系**：20年前是实习生（如果传闻属实）
- **涉及**：可能参与伪造报告
- **对田中的态度**：承认见过他，但说不是"S"

### 田边晃
- **关系**：神秘的"S先生"的儿子？
- **情况**：这个身份未确认
- **对田中的态度**：？？？

---

💡 围绕田中一郎的关系网非常复杂，几乎所有人都可能有动机！
```

### 嫌疑排行
**玩家："谁最可疑？"**

```markdown
# 🎯 嫌疑度排行

## TOP 5 可疑人物

### 🥇 第1名：大阪绫子
**嫌疑度**：30/100 ⚠️⚠️⚠️⚠️
**主要疑点**：
- 与20年前事故可能深度相关
- 心理状态极差
- 多项异常行为
- 有作案机会

### 🥈 第2名：大阪龙一
**嫌疑度**：25/100 ⚠️⚠️⚠️
**主要疑点**：
- 事故责任人
- 体型符合脚印
- 有灭口动机

### 🥉 第3名：佐藤健
**嫌疑度**：20/100 ⚠️⚠️
**主要疑点**：
- 可能的"S"号人物
- 行为过于冷静
- 经济犯罪逃避中

### 第4名：田边晃
**嫌疑度**：18/100 ⚠️
**主要疑点**：
- 神秘的背景
- 技术能力强
- 可能是S先生的儿子

### 第5名：小林敏夫
**嫌疑度**：15/100 ⚠️
**主要疑点**：
- 收受贿赂
- 熟悉旅馆
- 但似乎太胆小

---

⚠️ **注意**：嫌疑度高≠一定是凶手！
有时真凶会故意降低存在感...
```

## 注意事项

1. **渐进披露**：不要一次展示所有信息
2. **动态更新**：根据游戏进度实时更新
3. **引发思考**：提供信息但不直接给答案
4. **尊重探索**：鼓励玩家主动探索获取信息

---

**这个skill是你的"人物笔记本"，帮助你了解每个人，但真相需要你自己揭开。**