---
name: 第4章：多重结局
description: 根据玩家的选择与表现,体验不同的故事结局
---

# 第4章：多重结局

## 系统指令（v0.0.2）

**严格遵循AI交互式游戏设计原则**（详见CLAUDE.md）

这是游戏的最终章节。根据玩家的游戏状态呈现对应的结局。

### 结局判断流程

读取 `game_state.json`，根据以下关键参数判断结局：

1. **case_solved**: 是否正确破案
2. **murderer_caught**: 是否抓获凶手
3. **alive_characters**: 存活角色数量
4. **player_alive**: 主角是否存活
5. **真理_alive**: 真理是否存活
6. **team_victory**: 是否团队协作胜利
7. **solo_mode**: 是否独行模式
8. **truth_revealed**: 20年前真相是否完全揭露

### 核心执行原则
- ✅ 渐进式叙事（200-400字/段）
- ❌ 禁止"选项ABC"
- ✅ 场景式互动
- ✅ 根据状态动态展开
- ❌ 禁止一次性输出全部结局

---

## 结局系统

### 【场景1：黎明来临】

第二天清晨。

暴风雪终于停了。

阳光穿透云层，洒在"修普尔"旅馆的白雪上。

这漫长的惊魂夜...终于结束了。

💭 **回顾这一夜...你经历了什么？**

---

### 【场景2：结局判定】

<sup>⚠️ 系统根据game_state自动判定结局类型</sup>

根据你的选择和行动，系统会展开对应的结局场景。

以下是7种可能的结局：

---

## 结局A：真相大白（完美结局）✨

**触发条件**：
- case_solved = true
- murderer_caught = true
- alive_characters ≥ 8
- truth_revealed = true
- team_victory = true

### 剧情展开

【第一层：救援到来】

警车沿着清理出的道路驶来。

你站在旅馆门口，看着绫子被警察带走。

她回头看了你一眼，眼中是解脱："谢谢你...让真相大白..."

💭 **对她说什么？还是沉默？**

【第二层：后续处理】

- 绫子接受审判，考虑到她的受害者身份，从轻判决
- 大阪龙一和小林夫妇因20年前的隐瞒被追究责任
- 佐伯俊夫的罪行被公开
- 田中健司的墓前，众人献上鲜花

真理握着你的手："小透，你做到了...你找到了真相。"

【第三层：尾声】

一个月后，你完成了关于这次事件的心理学论文《创伤、复仇与正义》。

指导教授评价："这是我见过最深刻的案例分析。"

但你知道，有些伤痕永远无法愈合。

你只是...让真相不被埋没。

**标题卡**：
```
真相大白

"正义或许会迟到，但真相永远不会缺席。"

完美结局
```

---

## 结局B：绝望深渊（最坏结局）💀

**触发条件**：
- alive_characters ≤ 3
- case_solved = false
- 或 player_alive = false

### 剧情展开

【第一层：惨状】

<sup>⚠️ 如果主角存活</sup>

旅馆已经变成了尸横遍野的地狱。

你和真理（如果她还活着）躲在房间里，听着外面的脚步声...

<sup>⚠️ 如果主角死亡</sup>

真理抱着你的尸体，无声地哭泣。

"为什么...为什么会变成这样..."

【第二层：警方发现】

警察在暴风雪后赶到，发现的是人间炼狱。

新闻报道：《雪山旅馆惨案，多人死亡，真相成谜》

绫子在审判时精神失常，被送入精神病院。

20年前的秘密，再次被埋葬。

【第三层：余波】

真理（如果存活）每年都会来到雪山，在墓前献花。

"对不起...我没能保护你..."

**标题卡**：
```
绝望深渊

"有些黑暗，吞噬一切光明。"

最坏结局
```

---

## 结局C：各个击破（分裂悲剧）😈

**触发条件**：
- team_split = true
- alive_characters ≤ 5
- 来自ch3c路线

### 剧情展开

【第一层：惨重代价】

团队的分裂让绫子有机可乘。

她利用暴风雪和旅馆地形，逐个击破了落单的人。

田边、小林夫妇...一个个倒下。

【第二层：险胜】

最后，你们终于制服了她。

但代价太大了。

大阪："如果当时我们团结...他们就不会死..."

【第三层：终生愧疚】

幸存者们终生活在愧疚中。

"如果当时我们选择相信彼此..."

**标题卡**：
```
各个击破

"分裂的团队，是凶手最好的帮凶。"

悲剧结局
```

---

## 结局D：险中求胜（好结局）⚔️

**触发条件**：
- case_solved = true
- murderer_caught = true
- alive_characters = 6-7

### 剧情展开

【第一层：付出代价】

虽然成功破案，但有2-3人牺牲。

在死者的墓前，幸存者们沉默不语。

佐藤："我们赢了...但这算什么胜利？"

你："至少...真相被揭开了。逝者可以安息。"

【第二层：友谊】

幸存者们成为终生的朋友，被共同的创伤联系在一起。

每年，你们都会聚会，纪念那个惊魂之夜。

【第三层：继续前行】

真理牵着你的手："虽然很艰难...但我们一起走过来了。"

**标题卡**：
```
险中求胜

"代价惨重，但正义终将到来。"

好结局
```

---

## 结局E：雪山逃生（中性结局）🚗

**触发条件**：
- escaped = true
- case_solved = false
- 来自ch3e路线

### 剧情展开

【第一层：逃离成功】

你们冒险在暴风雪中驾车逃离，到达山下小镇。

报警后，警察上山，逮捕了凶手。

【第二层：永恒的疑问】

但你始终有一个疑问：真凶到底是谁？

警方公布是绫子，但你总觉得有些疑点...

你选择了生存，但放弃了真相。

【第三层：噩梦】

接下来的日子，你时常做噩梦。

真理："不要再想了，我们活下来了。"

但有些疑问会永远萦绕...

**标题卡**：
```
雪山逃生

"活着，但真相永远成谜。"

中性结局
```

---

## 结局F：正义审判（正义结局）⚖️

**触发条件**：
- truth_revealed = true
- 来自ch3f路线
- 选择"移交法律"

### 剧情展开

【第一层：法庭】

你不仅抓住了绫子，还揭露了20年前所有犯罪者。

法庭上：
- 绫子：故意杀人罪
- 大阪龙一：过失致死、贿赂
- 小林夫妇：隐瞒证据
- 佐伯俊夫（已故）：罪行被追认

【第二层：公道】

田中一郎的墓前，你放上判决书。

"您的哥哥，终于得到了公道。"

【第三层：新生】

你成为知名犯罪心理学家，真理成为你的终生伴侣。

多年后，你出版了《修普尔旅馆事件》一书。

**标题卡**：
```
正义审判

"法律的正义，不仅惩罚凶手，更要还原真相。"

正义结局
```

---

## 结局G1：孤胆英雄（英雄结局）🦸

**触发条件**：
- solo_mode = true
- player_alive = true
- solo_success = true

### 剧情展开

【第一层：英雄诞生】

你凭一己之力破解密室，独自制服凶手。

众人赶到时，发现你已经完成了一切。

真理泪流满面："你这个笨蛋...但你是英雄..."

【第二层：传奇】

"雪山孤狼侦探"的称号不胫而走。

但你知道，孤独调查的代价有多大。

真理："下次，让我陪在你身边好吗？"

你点头："好。"

【第三层：不再孤单】

一年后，你和真理结婚。

佐藤致辞："这个人，曾经独自对抗黑暗...现在，他终于不再孤单。"

**标题卡**：
```
孤胆英雄

"有些真相，需要孤独的勇者去揭露。"

英雄结局
```

---

## 结局G2：英雄永存（烈士结局）💀

**触发条件**：
- solo_mode = true
- player_alive = false

### 剧情展开

【第一层：牺牲】

你在与绫子的搏斗中牺牲。

真理发现你的尸体，尖叫回荡整个旅馆...

绫子精神崩溃，被其他人制服。

【第二层：墓碑】

```
透
心理学专业学生
为追寻真相献出生命
永远的英雄
```

真理的独白："小透...我知道你选择了正义...但我宁愿你活着..."

【第三层：遗产】

你的牺牲让真相大白。

虽然你不在了，但正义得到了伸张。

**标题卡**：
```
英雄永存

"有些英雄，以生命为代价，守护真相。"

烈士结局
```

---

## 结局后内容

### 【统计数据】

💭 **查看游戏统计？**

如果查看：
- 存活角色：X/10
- 收集线索：X条
- 游玩时间：X小时
- 章节路径：[显示玩家走过的路线]

### 【角色命运】

💭 **查看每个角色的最终结局？**

如果查看：
详细展示每个角色的命运结局

### 【真相解析】

💭 **查看完整真相？**

如果查看：
完整披露所有谜题的答案

### 【新游戏+】

💭 **开始新的游戏？探索其他路线？**

如果选择：
可以从任意章节开始，或完全重新开始

---

## 结束语

"感谢您游玩《恐怖惊魂夜》。

每一个选择，都通往不同的命运。
每一条真相，都值得被追寻。

如果您愿意，可以重新开始，探索其他可能性。
在雪山的深处，还有更多秘密等待被发现...

再见，侦探。"

---

## 互动指南

### 结局展现

**自动判定**：
- 读取game_state.json
- 根据条件展开对应结局
- 不显示其他结局（除非玩家询问）

**玩家主导**：
- 可以查看统计
- 可以回顾剧情
- 可以重新游玩

**禁止事项**：
- ❌ 一次性展示所有结局
- ❌ 使用"选项ABC"
- ❌ 忽略玩家的游戏状态

---

**只展开玩家达成的结局，其他结局保密，增加重玩价值。**