---
name: 第1C章：独自调查
description: 选择不信任任何人，独自展开调查，这是最危险但也可能最接近真相的道路
---

# 第1C章：独自调查

## 系统指令（v0.0.2）

**严格遵循AI交互式游戏设计原则**（详见CLAUDE.md）

### 核心执行原则
- ✅ 渐进式叙事（200-400字/段）
- ❌ 禁止"选项ABC"
- ✅ 场景式互动（15-25分钟）
- ✅ 三层信息披露
- ❌ 禁止直接说skill名称
- ✅ 强调孤独感和内心独白

### 执行流程
1. 读取 `game_state.json`，确认前置为ch00_start
2. 从"场景1-1"开始，分段展开
3. 强调独自调查的压力和洞察力
4. 自然引导至ch2e_alone

---

## 剧情内容（渐进式分段）

### 【场景1-1：孤独的决定】

你环顾四周，看着这些人。

作为心理学专业的学生，你知道在危机时刻，人的真面目会暴露。

小林夫妇过度紧张...佐藤太冷静...大阪在颤抖...

甚至真理，你最信任的人，她说小时候来过这里...她知道多少？

**内心独白**：
每个人都可能在撒谎。每个人都可能是凶手。
在这种情况下，唯一能信任的，只有自己的观察和判断。

你对众人说："我需要静一静。大家也早点休息吧。"

真理拉住你的手："一个人...真的没问题吗？"

---

💭 **如何回应真理？告诉她实话，还是隐瞒你的计划？**

---

### 【场景1-2：深夜独行】

<sup>⚠️ 根据玩家选择展开</sup>

你回到房间，但没有睡觉。

躺在床上，等待...倾听...

窗外暴风雪的呼啸，走廊里偶尔传来的声响。

晚上11点，旅馆逐渐安静下来。

你悄悄打开房门，走入走廊。

地板发出轻微的吱呀声。你的心跳加速，但你强迫自己保持冷静。

**心理学训练**在这一刻派上用场——你学会了控制恐惧，专注观察。

---

💭 **你想先去哪里调查？前台？地下室？还是其他地方？**

---

### 【场景2：自由探索阶段】

<sup>⚠️ 开放场景，玩家可自由选择调查地点</sup>

**玩家可以说**：
- "我要去前台"
- "我想看看地下室"
- "我要检查田中的房间"
- "我想听听走廊的动静"
- 或任何其他调查行动

#### 如果玩家去前台

你来到一楼前台，月光从窗户透进来。

【第一层信息】
钥匙板上挂着各个房间的备用钥匙。
你数了数...等等，202房的钥匙呢？

💭 **仔细检查钥匙板？**

【第二层 - 玩家说"我要仔细检查"】
202房的钥匙确实不见了！
这是关键线索——有人拿走了备用钥匙！

谁有机会拿走？
小林夫妇管理钥匙，最容易。
其他人需要趁小林不注意时偷走...

突然——楼上传来脚步声！有人也在走动！

💭 **躲起来观察？还是跟上去？**

#### 如果玩家去地下室

你发现厨房后面有一扇通往地下室的门。

小林说过很少去那里...

【第一层】
门没有锁。推开门，一股霉味扑面而来。
木质楼梯通往黑暗的地下。

💭 **下去看看？**

【第二层 - 玩家选择下去】
你打开手机手电筒，小心翼翼地走下楼梯。

地下室阴冷潮湿，堆满杂物。
左侧是储藏室，右侧是锅炉房，还有更深的区域...

💭 **探索储藏室？还是锅炉房？**

【第三层 - 玩家探索储藏室】
在杂物中，你发现了...

**旧报纸**：20年前的地方报纸
头条：《建筑工地事故，一名工人死亡》
内容简报了田中健司的死亡，定性为"个人违规操作"
但副标题被红笔圈出："死因可疑？"

**一本日记**：积满灰尘，是小林惠子的笔迹
某一页："我们做了错事...接受了那笔钱...但那个工人真的只是意外吗？我看到了血...太多血了...龙一先生和一个穿西装的男人在吵架...那个男人是谁？"

**一张照片**：20年前的工地照片
可以看到年轻的大阪龙一、小林夫妇、田中健司
还有一个穿西装的中年男人，面容严肃
照片背面写着："S先生、龙一、敏夫、健司，施工第一天"

**S先生！**

---

### 【场景3：地下室对峙】

<sup>⚠️ 玩家深入调查后触发</sup>

就在你研究这些发现时——

身后传来声音！

"你在这里做什么？"

转身，你看到...

【根据剧情需要，可以是小林敏夫或佐藤健】

#### 如果是小林敏夫

小林站在楼梯口，手里拿着手电筒，脸色苍白。

"你...你怎么来地下室了？"

他的语气很紧张，但不像威胁，更像是恐惧。

💭 **如何应对？质问他？试探他？还是保持沉默观察反应？**

【如果玩家质问】
"我发现了日记和照片。20年前到底发生了什么？"

小林的脸更白了，开始颤抖：
"你都知道了...是，我们隐瞒了真相...但我们不是杀人凶手！"

"那次事故不是简单的意外...是S先生...他逼大阪做了偷工减料..."

"田中健司死后，S先生给了我们一大笔钱，让我们闭嘴..."

"这20年我一直活在愧疚里...现在报应来了..."

💭 **追问S先生是谁？**

#### 如果是佐藤健

佐藤站在楼梯口，表情严肃。

"深夜调查？看来你也睡不着。"

他太冷静了。而且...他怎么知道你在地下室？是跟踪你吗？

💭 **如何应对？坦白部分信息试探他？还是反问他为什么跟踪？**

【如果玩家反问】
"你为什么跟着我？"

佐藤沉默几秒："我没有跟着你。我也在调查。"

"田中死前，我见过他。"

这是爆炸性的信息！

"他问我是不是'S'。我告诉他我不是，但他不相信。"

"我确实叫Sato，但我跟20年前的事故无关。我那时才15岁。"

---

### 【场景4：突发停电】

<sup>⚠️ 对峙进行到关键时刻</sup>

就在你准备追问下去时——

整个旅馆的灯全灭了！

一片黑暗！

小林/佐藤发出惊呼："停电了！"

不，不对。这不是普通停电。

这是有人故意切断了电源！

楼上传来惊叫声！

💭 **冲上楼？**

---

### 【场景5：黑暗中的危机】

你和[小林/佐藤]冲上楼。

大堂里，其他人都从房间跑出来，惊慌失措。

"发生什么了？"
"为什么停电？"
"凶手要再次下手了！"

混乱中，你清点人数：
真理、铃木、田边、大阪夫妇、惠子...

【第一层观察】
等等，少了一个人！

💭 **仔细数人数？**

【第二层 - 玩家清点】
如果刚才在地下室的是小林，那么少了佐藤
如果刚才在地下室的是佐藤，那么少了小林敏夫

不，不对——仔细数，少了**两个人**！

【第三层】
有人打开备用发电机，灯光恢复。

在这瞬间，所有人看到——

**二楼楼梯口，一个人倒在血泊中！**

是大阪龙一！胸口被刺，还在喘息...

他艰难地说："是...是S先生...他..."然后昏迷。

---

### 【场景6：孤立无援】

绫子崩溃大哭，其他人陷入恐慌和互相指责。

因为你选择了独自调查，没有建立盟友。

现在情况更危急：
- 已有2人死亡/重伤
- 通讯中断
- 凶手身份不明
- 团队互相怀疑

真理走过来，伸出手："小透...我们必须合作了。"

---

💭 **接受真理的合作？还是继续独自调查？或者向所有人公开地下室的发现？**

---

### 【场景7：章节自然过渡】

根据玩家选择：

**如果接受真理合作**：
"你不再孤军奋战，但独自调查带来的洞察让你比任何人都更接近真相..."

**如果继续独行**：
"你坚持孤独的道路。压力更大，但视角更清晰。S先生...20年前的秘密...真相就快浮现..."

**如果公开发现**：
"你决定分享地下室的发现。也许，共同的敌人能让大家团结..."

💭 **你准备好面对接下来的挑战了吗？**

玩家确认后，自然进入下一章节（不说skill名称）。

---

## 互动指南

### 独自调查响应模板

**强调孤独感**：
- 大量内心独白
- 心理学专业视角分析
- 没有同伴交流，只有自己推理

**玩家主动调查**：
- 详细展开探索过程
- 提供三层信息披露
- 记录重要线索

**玩家卡住**：
- 第1-2次：内心独白，思考线索
- 第3次：环境暗示"也许可以去..."

### 线索记录

自动记录关键线索：
```json
{
  "name": "S先生照片",
  "description": "20年前工地照片，穿西装的中年男人",
  "found_in": "ch1c_solo",
  "importance": "关键"
}
```

### 禁止事项
- ❌ "选项A：质问小林"
- ❌ "→ 进入ch2e"
- ❌ 一次性输出超过500字
- ❌ 忽略孤独主题

---

**开始时只输出【场景1-1】，等待玩家输入后逐步展开。强调独自调查的孤独感和洞察力。**