---
name: 第1A章：密室搜证
description: 选择仔细调查田中一郎的死亡现场，寻找密室杀人背后的真相与线索
---

# 第1A章：密室搜证

## 系统指令（v0.0.2）

**严格遵循AI交互式游戏设计原则**（详见CLAUDE.md）

### 核心执行原则
- ✅ 渐进式叙事（200-400字/段）
- ❌ 禁止"选项ABC"
- ✅ 场景式互动（15-25分钟）
- ✅ 三层信息披露
- ❌ 禁止直接说skill名称

### 执行流程
1. 读取 `game_state.json`，确认前置为ch00_start
2. 从"场景1-1"开始，分段展开
3. 玩家每次行动后更新状态
4. 根据探索方向自然引导至ch2a或ch2b

---

## 剧情内容（渐进式分段）

### 【场景1-1：重返现场】

你深吸一口气，决定再次进入那个房间。

真理担心地拉着你："小透...真的要进去吗？"

她的眼神里满是担忧。你可以感觉到她在颤抖。

周围其他人的反应各异——佐藤似乎也想跟进来，小林敏夫则脸色发白，想说什么又咽了回去。

---

💭 **你想让真理陪你一起，还是让她留在外面？或者有其他想法？**

---

### 【场景1-2：进入房间】

<sup>⚠️ 根据玩家选择展开</sup>

推开房门，血腥味扑面而来。

寒风从破碎的窗户呼啸而入，雪花飘进房间。尸体已被白布覆盖，但形状依然清晰可见。

墙上的血迹已经凝固变黑。地板上，到处是...

你强迫自己不去想那些细节，开始用心理学专业训练的冷静观察力审视现场。

**房间里有很多东西可以调查**：
- 被白布覆盖的尸体
- 破碎的窗户和窗外
- 散落的黑色公文包和文件
- 房间的门锁
- 其他家具和物品

---

💭 **你想从哪里开始调查？**

---

### 【场景2：自由调查阶段】

<sup>⚠️ 这是开放场景，玩家可自由探索</sup>

**玩家可以说**：
- "我要检查尸体"
- "我想看看窗户外面"
- "让我检查那些文件"
- "我要看看门锁"
- 或任何其他合理的调查行动

#### 如果玩家检查尸体

你掀开白布的一角...

【第一层信息】
切口...太整齐了。不像是砍的，更像是...精密切割。

💭 **继续仔细观察，还是先看别的？**

【第二层 - 玩家说"我要仔细检查切口"】
切口的角度和深度显示使用了极其锋利的工具。断面很平整，几乎没有撕裂的痕迹。

这需要专业知识。凶手可能有医学背景，或者...

【第三层 - 玩家提出专业问题】
作为心理学学生，你虽然不是法医，但能判断：这种切割方式显示凶手极其冷静，有预谋，可能在传达某种信息...

#### 如果玩家检查窗户

你走向破碎的窗户。

【第一层】
玻璃碎片...大部分在窗外的雪地上。窗户是从里面打破的。

💭 **探头看向窗外？**

【第二层 - 玩家探头看】
这是二楼。下方是厚厚的积雪。

等等...雪地上有脚印！

【第三层 - 玩家说"我要下楼查看脚印"】
（引导玩家到室外查看，给予详细的脚印信息）

#### 如果玩家检查文件

黑色公文包敞开着，文件散落一地。

【第一层】
有些文件，照片，还有...一支录音笔？

💭 **仔细翻阅文件？还是先拿起录音笔？**

【第二层 - 翻阅文件】
文件显示...田中一郎是私家侦探。他在调查某个事故...

【第三层 - 播放录音笔】
（展开录音内容，揭露小林的供述）

#### 如果玩家检查门锁

门锁完好无损，没有被撬的痕迹。

【第一层】
这是标准的旅馆门锁，从外面需要钥匙才能开。

💭 **询问小林关于钥匙？**

【第二层 - 询问后】
小林说每个房间有两把钥匙，一把给客人，一把是备用的，挂在前台...

你可以去前台检查钥匙板。

---

### 【场景3：发现关键线索】

<sup>⚠️ 当玩家探索一定程度后展开</sup>

经过仔细调查，你已经发现了不少线索。

**你了解到**：
- 切割手法专业（医学背景？）
- 窗户从内打破，外面有脚印
- 田中是侦探，在调查某个事故
- 门锁完好，但备用钥匙...

**突然**——

根据玩家的探索方向，触发不同事件：

#### 分支A：如果玩家去查看脚印或窗外
你在窗外雪地中跟踪脚印时，突然看到树林里有个黑影闪过！

有人在那里！

💭 **追过去？还是先回旅馆？**

【如果追】→ 自然过渡到ch2a_chase

#### 分支B：如果玩家询问众人证词
回到大堂，你开始询问大家下午的行踪。

但你发现...几个人的说法对不上！

小林说下午一直在厨房，但惠子说他出去了。
大阪说在房间休息，但铃木说看到他在走廊徘徊。

有人在撒谎！

💭 **当面质问？还是暗中观察？**

【如果质问】→ 自然过渡到ch2b_suspect

---

### 【场景4：章节自然过渡】

根据玩家的探索和选择，给予相应暗示：

**如果选择追踪线索（ch2a方向）**：
"夜色更深了。你意识到必须抓住那个神秘的黑影，也许他就是关键..."

💭 **你准备好追踪了吗？**

**如果选择对质证词（ch2b方向）**：
"太多谎言了。你决定不能再被动，必须逼他们说出真相..."

💭 **你准备好对质了吗？**

玩家确认后，自然进入下一章节（不说skill名称）。

---

## 互动指南

### 调查响应模板

**玩家主动调查**：
- "我要检查XX" → 提供第一层信息，询问是否深入
- "仔细检查XX" → 提供第二层信息
- 提出专业问题 → 提供第三层信息

**玩家询问角色**：
- 展开对话，根据角色性格回答
- 记录信任度变化

**玩家卡住**：
- 第1-2次：保持沉默或"环顾四周，你还可以检查..."
- 第3次：提示"也许可以检查窗户/文件/门锁..."

### 线索记录（示例）

玩家发现线索时，自动记录到collected_clues：
```json
{
  "name": "专业切割手法",
  "description": "切口平整，显示专业技能",
  "found_in": "ch1a_investigate",
  "importance": "关键"
}
```

不在对话中说"线索#01"，而是自然描述。

### 禁止事项
- ❌ "选项A：检查尸体"
- ❌ "→ 进入ch2a_chase"
- ❌ "线索#03：窗外脚印"
- ❌ 一次性输出超过500字

---

**开始时只输出【场景1-1】，等待玩家输入后逐步展开。**