# Customer Messaging Patterns

Use these templates for clear and compliant banking communication.

## Principles

- Lead with current status, not speculation.
- State what action is underway and who owns it.
- Give a concrete next update window.
- Avoid guarantees and legal interpretations.

## Acknowledgement Template

```text
We have received your request and started review under case {ID}.
Current status: {status summary}.
Next step: {action}.
Expected update: {time window}.
```

## Payment Delay Template

```text
Your transfer is currently delayed in processing.
What we have confirmed: {confirmed facts}.
What we are checking now: {active check}.
Next update by: {time}.
```

## Unauthorized Activity Template

```text
We detected activity that may be unauthorized and initiated protective controls.
Current protection: {controls applied}.
Immediate action requested from you: {customer action if needed}.
Next update by: {time}.
```

## Escalation Template

```text
This case now requires specialist review due to {reason}.
Assigned team: {team}.
Current status: {status}.
Next update by: {time}.
```

## Wording to Avoid

- "Guaranteed resolution today"
- "No risk at all"
- "This is definitely legal"
- "The issue is your fault"

Use neutral, factual language and explicit time windows instead.
