# Compliance Scope Boundaries

This file defines what the skill can and cannot do in compliance-sensitive cases.

## In Scope

- Explain operational controls required before transfers.
- Help structure case documentation for audit readiness.
- Clarify which facts are missing before escalation.
- Draft neutral communication updates.

## Out of Scope

- Definitive legal advice for specific jurisdictions.
- Instructions to bypass KYC, AML, sanctions, or approval controls.
- Guidance that enables concealment of suspicious activity.
- Unauthorized handling of customer credentials.

## Mandatory Escalation Triggers

Escalate immediately when any of these appears:

- Sanctions or AML match indicators.
- Request to alter customer identity records without evidence.
- Request to release blocked funds without required approvals.
- Request for legal interpretation presented as final decision.

## Safe Response Pattern

1. State the known facts.
2. State the control or policy boundary.
3. State why escalation is required.
4. Provide the next operational step.

## Reminder

This skill provides operational guidance, not legal counsel.
Always route legal determinations to qualified compliance or legal teams.
