---
name: bank-analysis
displayName: 银行流水财务分析
description: 分析公司银行流水，输出集团总体、收入、支出、应收应付、重大款项及风险分析报告
version: 1.0.0
type: skill
tags: ["财务", "分析", "银行", "流水", "报表"]
---

# 🏦 银行流水财务分析技能

## 功能模块

### 1. 集团总体分析
- 总收入、总支出、净利润
- 资金流入/流出趋势
- 账户余额变化

### 2. 收入分析
- 收入构成（按客户/项目分类）
- 收入同比增长分析
- 主要收入来源

### 3. 支出分析
- 支出类型分布（工资、租金、采购等）
- 成本结构分析
- 各项支出占比

### 4. 应收应付分析
- 应收账款账龄分析
- 应付账款账龄分析
- 资金占用情况

### 5. 重大款项往来
- 大额交易识别（设定阈值）
- 关联方交易
- 异常交易预警

### 6. 风险分析
- 资金流动性风险
- 经营风险预警
- 财务健康度评分

## 输入格式

支持 Excel (.xlsx) 或 CSV 格式，包含以下字段：
- 日期
- 交易金额（收入为正，支出为负）
- 对方账户
- 摘要/用途
- 公司名称（如有多家公司）

## 使用方法

```bash
# 分析银行流水
node bank-analysis/index.js "分析 ./data/银行流水.xlsx"

# 生成报告
node bank-analysis/index.js "生成财务分析报告"
```

## 输出

- 完整的财务分析报告（Markdown格式）
- 关键指标汇总
- 风险预警建议