# Bangkok Visitor Tips

## Arrival

### Airports

**Suvarnabhumi (BKK)** — Main international airport
- **To city center**: Airport Rail Link (45 min, 45 THB to Makkasan, connect to MRT)
- **Alternative**: Grab/taxi (300-400 THB, 45-90 min depending on traffic)
- **Avoid**: Airport taxis at desk — use Grab or metered taxi from level 1
- **SIM card**: True, AIS, or DTAC booths in arrivals (300-400 THB for tourist SIM with data)

**Don Mueang (DMK)** — Budget airlines (AirAsia, Nok Air)
- **To city center**: A1/A2 bus to BTS Mo Chit (30 THB) or taxi
- **No rail link** — plan for traffic

### First Hour Essentials
1. Get SIM card at airport (AIS or True recommended)
2. Download **Grab** app (your transport lifeline)
3. Get 2,000-3,000 THB cash from airport ATM
4. Connect to airport WiFi to book Grab if needed

## Getting Around

### Grab (Essential App)
- Works like Uber: cars, motorbike taxis, food delivery
- **GrabCar**: Most common, price fixed upfront
- **GrabBike**: Motorcycle taxi, faster in traffic, wear helmet
- Always confirm destination in app — drivers often don't speak English
- Payment: Cash or card (register card in app)

### BTS Skytrain
- **Hours**: 6:00 AM - midnight
- **Cost**: 17-62 THB per trip
- **Rabbit Card**: Refillable card, skip ticket queues (200 THB purchase, 100 THB refundable)
- **Lines**: Sukhumvit (green), Silom (dark green)
- Clean, efficient, air-conditioned — use whenever possible

### MRT
- **Hours**: 6:00 AM - midnight
- **Cost**: 17-42 THB
- **Separate card from BTS** (annoying, yes)
- Covers: Chinatown, Hua Lamphong (train station), Chatuchak

### Taxis
- **Metered only**: Insist on "meter" — "TAXI-METER" sign on roof
- **Flag fall**: 35 THB
- **Traffic**: Can take 2+ hours for 10km in rush hour
- **Tip**: Round up to nearest 10-20 THB
- **Scam**: If driver refuses meter at tourist spots, walk away

### Boats
- **Chao Phraya Express**: Orange flag boat, 15-16 THB, covers riverside temples
- **Tourist boats**: Blue flag, 50 THB single/180 THB day pass, hop-on/hop-off
- **Khlong boats**: Canal boats, 10-20 THB, local commuter routes

### Motorbike Taxis
- **Orange vests** at most sois
- Negotiate price before riding (20-50 THB for short trips)
- Fast but risky — only for confident riders
- Helmets should be provided

## Money

### Currency
- **Thai Baht (THB/฿)**
- Rough conversion: 35 THB = $1 USD

### ATMs
- **220 THB fee per withdrawal** (unavoidable)
- **Tip**: Withdraw max (usually 20,000-30,000 THB) to minimize fees
- Use Charles Schwab, Wise, or other fee-reimbursing cards
- Decline "conversion" — always charge in THB

### Cash vs Card
- **Street food, markets, taxis**: Cash only
- **Malls, hotels, restaurants**: Cards accepted (sometimes 3% fee)
- **Grab**: Links to international cards

### Tipping
- **Not expected** in local places
- **Restaurants**: Round up or 20-50 THB
- **Massage**: 50-100 THB
- **Hotel staff**: 20-50 THB

## Communication

### Language
- **English**: Widely spoken in tourist areas, hotels, malls
- **Basic Thai helps**:
  - Sawasdee (hello)
  - Khop khun (thank you)
  - Mai ao (I don't want)
  - Tao rai (how much)
  - Phet/Mai phet (spicy/not spicy)

### Essential Apps
| App | Use |
|-----|-----|
| **Grab** | Transport, food delivery |
| **Google Maps** | Navigation (better than Apple Maps here) |
| **Google Translate** | Camera mode for menus |
| **LINE** | Thai messaging app (some businesses use it) |
| **Agoda** | Last-minute hotels |
| **Foodpanda** | Food delivery alternative |

## Safety

### Generally Safe
Bangkok is very safe for tourists. Violent crime against visitors is rare.

### Main Risks
- **Scams**: #1 concern — see below
- **Traffic**: Look both ways, multiple times
- **Pickpockets**: Rare but possible on crowded BTS
- **Motorbike accidents**: Don't ride drunk

### Common Scams
- **"Temple closed today"**: It's not. They want to take you to gem shops.
- **Tuk-tuk "tours"**: Free/cheap rides that stop at commission shops.
- **Gem scams**: "Government sale" or "special price" — always fake.
- **Jet ski damage**: Operators claim pre-existing damage. Avoid jet skis.
- **Ping pong show overcharging**: ฿5,000+ bills for "mandatory drinks."
- **Fake taxis**: No meter, inflated prices. Use Grab.

### Rule of Thumb
If a stranger approaches YOU offering help or deals, be very skeptical.

## Weather & Packing

### What to Expect
- **Always hot**: 30-35°C year-round
- **Always humid**: 70-90%
- **Rainy season (Jun-Oct)**: Daily afternoon showers, usually 30-60 min
- **"Cool" season (Nov-Feb)**: Still 25-30°C, just less oppressive

### Packing Essentials
- Light, breathable clothing (cotton, linen)
- Cover-ups for temples (no shorts, shoulders covered)
- Comfortable walking sandals
- Small umbrella (for sun AND rain)
- Sunscreen, hat
- Small daypack
- Hand sanitizer for street food adventures
- Pepto-Bismol/Imodium just in case

## Temple Etiquette

### Dress Code
- **Shoulders covered**
- **Knees covered**
- **No see-through clothing**
- Can rent/buy cover-ups outside major temples

### Behavior
- **Remove shoes** before entering buildings
- **Never point feet** at Buddha images
- **Women cannot touch monks** or hand things directly to them
- **Don't climb on anything**
- **Ask before photographing** people or inside temples

## Food Safety

### General Rules
- **Busy stalls = safe stalls** (high turnover)
- **Cooked food > raw food** initially
- **Ice is usually safe** in Bangkok (machine-made)
- **Tap water**: Don't drink it. Bottled water everywhere.
- **Street food**: Generally safe. Start mild, work up to spicy.

### If You Get Sick
- **Pharmacies**: Everywhere, staff speak English
- **Imodium**: Readily available
- **Rehydration salts**: Essential for food poisoning
- **Hospital**: If severe, Bangkok has excellent private hospitals

## Useful Info

### Electricity
- **220V, 50Hz**
- Plugs: Types A, B, C (US and European fit most outlets)

### Business Hours
- **Malls**: 10 AM - 10 PM
- **Street food**: 6 AM - midnight (varies)
- **Temples**: 8 AM - 5 PM
- **Banks**: 9 AM - 3:30 PM (weekdays)
- **Government**: 8:30 AM - 4:30 PM (weekdays)

### Emergencies
- **Tourist Police**: 1155 (English speaking)
- **Emergency**: 191
- **Ambulance**: 1669
- **Your embassy**: Save number before arriving

### Time Zone
- **GMT+7** (no daylight saving)
- Same zone as Vietnam, Indonesia (WIB)
