# Bangkok Attractions Guide

## Must-See (Worth the Crowds)

### Grand Palace & Wat Phra Kaew
- **What**: Royal palace complex with Temple of Emerald Buddha
- **Why go**: Thailand's most sacred site, stunning architecture
- **Time needed**: 2-3 hours
- **Cost**: 500 THB (~$14)
- **Tips**: Go at 8:30 AM opening to beat heat and crowds. Strict dress code (no shorts, shoulders covered — can rent cover-ups outside). No photography inside Wat Phra Kaew.
- **Skip if**: You hate crowds and have limited time — it's always packed

### Wat Arun (Temple of Dawn)
- **What**: Iconic riverside temple with climbable prang (spire)
- **Why go**: Best temple for photos, beautiful at sunset
- **Time needed**: 1 hour
- **Cost**: 100 THB (~$3)
- **Tips**: Cross from Tha Tien pier (4 THB boat). Climb the steep stairs for river views. Return at night to see it illuminated from the other side.

### Wat Pho (Reclining Buddha)
- **What**: Massive reclining Buddha, oldest/largest temple in Bangkok
- **Why go**: More impressive than Grand Palace for many, less crowded
- **Time needed**: 1-2 hours
- **Cost**: 200 THB (includes water bottle)
- **Tips**: Also home to traditional Thai massage school — get a legit massage here (300-500 THB). Come early or late afternoon.

### Chatuchak Weekend Market
- **What**: World's largest weekend market, 15,000+ stalls
- **Why go**: Everything exists here — clothes, art, antiques, food, plants, pets
- **Time needed**: 3-5 hours
- **Cost**: Free entry
- **Tips**: Go early (9 AM) to beat afternoon heat. Sections 2-4 for clothes, 7 for antiques, 25-27 for art. Get lost intentionally. Download map but accept you'll need it.
- **When**: Saturday-Sunday only, 9 AM - 6 PM

### Chinatown (Yaowarat)
- **What**: Old Chinese district, best street food in Bangkok
- **Why go**: Food. Just go for the food.
- **Time needed**: 2-4 hours (evening best)
- **Cost**: Meals 50-200 THB
- **Tips**: Peak is after 6 PM when neon signs light up. Must-eat: Yaowarat seafood (Soi Texas), dim sum, bird's nest soup if brave. Walk from MRT Hua Lamphong.

## Worth Doing

### Jim Thompson House
- **What**: Traditional Thai house museum, silk merchant's collection
- **Why go**: Peaceful oasis, beautiful architecture, interesting history
- **Time needed**: 1.5 hours
- **Cost**: 200 THB (mandatory guided tour)
- **Location**: Near BTS National Stadium

### Lumphini Park
- **What**: Central park of Bangkok
- **Why go**: Morning tai chi, monitor lizards, escape from chaos
- **Time needed**: 1-2 hours
- **Cost**: Free
- **Tips**: Come at 5-6 AM to see locals exercising. Paddleboats available. Monitor lizards are harmless (usually).

### Asiatique Night Market
- **What**: Upscale riverside night market
- **Why go**: Tourist-friendly, good intro to Thai shopping, riverfront views
- **Time needed**: 2-3 hours
- **Cost**: Free entry
- **Tips**: Take free boat from Sathorn pier (BTS Saphan Taksin). More expensive than other markets but well-organized. Has Muay Thai and Calypso cabaret shows.

### Wat Saket (Golden Mount)
- **What**: Temple on artificial hill with 360° Bangkok views
- **Why go**: Best accessible viewpoint in old town, peaceful climb
- **Time needed**: 1 hour
- **Cost**: 50 THB
- **Tips**: 318 steps with bells along the way. Best at sunset. Less crowded than major temples.

### Khlong (Canal) Boat Tours
- **What**: Longtail boat through old Bangkok canals
- **Why go**: See non-tourist Bangkok, local life, old wooden houses
- **Time needed**: 1-2 hours
- **Cost**: 1,000-1,500 THB (private boat) or 20 THB (public khlong boats)
- **Tips**: Charter from Tha Tien or Tha Phra Athit. Negotiate price. Include Khlong Bangkok Noi area.

### Rooftop Bars
- **What**: High-rise bars with Bangkok views
- **Best**: Lebua Sky Bar (famous from Hangover 2), Octave, Vertigo
- **Cost**: Drinks 300-600 THB
- **Tips**: Dress code enforced (no sandals, shorts). Go for sunset. Lebua is overpriced but view is unmatched.

## Skip or Save Time

### Khao San Road
- **Reality**: Backpacker ghetto, not authentic Bangkok
- **Who it's for**: 20-somethings wanting cheap beer and parties
- **Alternative**: Sukhumvit Soi 11 for better nightlife, Chinatown for real culture

### Safari World
- **Reality**: Overpriced, animal welfare concerns, far from center
- **Alternative**: If you need animals, go to Elephant Nature Park in Chiang Mai

### Gem/Tailor Tours
- **Reality**: 100% scams. Anyone offering to take you is getting commission.
- **Rule**: Never follow strangers to "special sales"

### Snake/Tiger Temples/Shows
- **Reality**: Animal abuse. Drugged tigers for photos.
- **Alternative**: See wildlife ethically at Khao Yai National Park (2h away)

### Floating Markets Near Bangkok
- **Reality**: Damnoen Saduak and Amphawa are tourist traps, 1.5h+ drive
- **Alternative**: Khlong Lat Mayom (Saturdays) is more authentic and closer

## Beyond Bangkok (Day Trips)

### Ayutthaya (1-2 hours north)
- **What**: Ancient capital ruins, UNESCO World Heritage
- **Why go**: Spectacular temples, best day trip from Bangkok
- **How**: Train from Hua Lamphong (20 THB, 2h) or minivan
- **Time needed**: Full day

### Kanchanaburi (2-3 hours west)
- **What**: Bridge on River Kwai, WWII history, waterfalls
- **Why go**: History, nature, escape the city
- **Time needed**: Full day or overnight

### Khao Yai National Park (3 hours northeast)
- **What**: Thailand's most accessible national park
- **Why go**: Real jungle, wild elephants, waterfalls
- **Time needed**: Overnight recommended

### Hua Hin (2.5 hours south)
- **What**: Beach town, royal palace, night market
- **Why go**: Quick beach escape without flying
- **Tips**: Van from Victory Monument or train from Hua Lamphong
