# Thailand Visa Guide

## Visa Overview

Thailand's visa system is complex and changes frequently. This covers common scenarios as of 2026.

## Short-Term Options

### Visa Exemption (Most Western Countries)

**Duration**: 30 days (air) / 15 days (land)

**Requirements**:
- Passport valid 6+ months
- Proof of onward travel
- Sufficient funds (~10,000 THB)

**Extension**: +30 days at immigration (฿1,900)

**Countries**: USA, UK, EU, Australia, Canada, Japan, etc.

**Reality**: Most tourists use this. Fine for vacation.

### Tourist Visa (TR)

**Duration**: 60 days + 30-day extension = 90 days total

**Get From**: Thai embassy/consulate in home country or nearby country (Vientiane, Kuala Lumpur, etc.)

**Requirements**:
- Passport + photos
- Application form
- Proof of accommodation
- Proof of finances
- Flight itinerary

**Cost**: $40-60 depending on country

**Multiple Entry**: 6-month validity, 60 days per entry

### Special Tourist Visa (STV)

Created during COVID, may still be available.
- 90 days
- Two 90-day extensions possible
- Total: 270 days
- Requires quarantine documentation (COVID legacy)

---

## Long-Term Options

### Non-Immigrant B (Business/Employment)

**For**: Working in Thailand

**How It Works**:
1. Employer sponsors you
2. Apply for Non-B visa at Thai embassy
3. Enter Thailand
4. Employer processes work permit
5. Convert to 1-year extension

**Initial Duration**: 90 days
**Extension**: 1 year (renewable)

**Requirements**:
- Job offer from Thai company
- Company meets criteria (registered capital, Thai employee ratio)
- Your qualifications match position

### Non-Immigrant O (Multiple Uses)

**Varieties**:
- **O (Retirement)**: 50+, retired
- **O (Marriage)**: Married to Thai national
- **O (Family)**: Dependent of visa holder
- **O (Volunteer)**: Volunteer work

#### Retirement Visa (Non-O)

**Requirements**:
- Age 50+
- 800,000 THB in Thai bank account OR
- Monthly income of 65,000 THB OR
- Combination totaling 800,000 THB/year
- Health insurance

**Duration**: 1 year, renewable

**Cannot Work**: Even remotely (technically)

#### Marriage Visa (Non-O)

**Requirements**:
- Married to Thai national
- 400,000 THB in Thai bank OR
- Monthly income 40,000 THB
- Marriage certificate

**Duration**: 1 year, renewable

### Education Visa (Non-ED)

**For**: Studying Thai language, martial arts, cooking, etc.

**How It Works**:
1. Enroll in approved school
2. School provides documents
3. Apply for Non-ED visa
4. Attend minimum classes (varies by school)

**Duration**: 90 days, renewable up to 1 year

**Cost**: School + visa + extensions = ฿30,000-80,000/year

**Popular Schools**:
- Union Language School
- AAA Thai Language
- Pro Language
- Various Muay Thai camps

**Reality**: Common for digital nomads who want to stay legal while working remotely (gray area — technically can't work).

---

## Premium Options

### Thailand Elite Visa

**What**: Long-term membership visa program

**Tiers**:
| Package | Duration | Cost |
|---------|----------|------|
| Elite Easy Access | 5 years | ฿600,000 (~$17,000) |
| Elite Privilege Access | 10 years | ฿1,000,000 (~$28,500) |
| Elite Superiority Extension | 20 years | ฿2,000,000 (~$57,000) |

**Perks**:
- Multiple entry
- Airport fast-track
- VIP lounge access
- Concierge services
- No 90-day reporting

**Who It's For**:
- Long-term expats
- Digital nomads with steady income
- Retirees who don't meet financial requirements
- Anyone who values convenience

**Cannot Work**: No work permit included

### Long-Term Resident Visa (LTR)

**New visa (launched 2022)** for high earners.

**Categories**:
1. **Wealthy Global Citizen**: $1M+ assets, $80K+/year income
2. **Wealthy Pensioner**: $80K+/year pension, $250K+ invested
3. **Work-from-Thailand Professional**: $80K+/year, 5+ years experience
4. **Highly-Skilled Professional**: Specific sectors, invited by Thai company

**Benefits**:
- 10-year visa
- **Can work remotely legally** (Work-from-Thailand category)
- 17% personal income tax (vs 35% top rate)
- No 90-day reporting (1-year instead)
- Digital work permit

**Cost**: ฿50,000 application fee

**Game Changer**: First visa that explicitly allows remote work.

---

## Digital Nomad Reality

### The Gray Area

Technically:
- Working in Thailand requires work permit
- Remote work for foreign employer = still working
- Tourist/ED visa holders can't legally work

Practically:
- Enforcement on laptop workers is minimal
- Don't advertise you're working
- Don't work for Thai clients
- Don't take money from Thai sources

### Best Options for Nomads

1. **LTR Visa** (if you qualify with $80K income) — Fully legal
2. **Thailand Elite** (5-20 years) — Stay legal, don't flaunt work
3. **ED Visa** (language school) — Renewable, somewhat legal cover
4. **Tourist visa + extensions** — Most common, shortest legal stay

### Visa Runs

**What**: Leave Thailand, re-enter for new stamp

**Where**:
- Vientiane (Laos) — Get tourist visa at embassy
- Penang (Malaysia) — Same
- Phnom Penh (Cambodia) — Same

**Warning**: Immigration tracking multiple entries. Too many = questioned or denied entry.

---

## 90-Day Reporting

**Required for**: Anyone on long-term visa (1-year extensions)

**What**: Report your address to immigration every 90 days

**Options**:
1. **In person**: Immigration office (free, time-consuming)
2. **Online**: immigration.go.th (when working)
3. **Mail**: Send forms + stamped envelope
4. **Agent**: ฿500-1,500

**Penalty for Late**: ฿2,000 fine

---

## Re-Entry Permits

**If you leave Thailand** on a 1-year visa, you need re-entry permit or visa is cancelled.

**Types**:
- **Single**: ฿1,000 — one exit/entry
- **Multiple**: ฿3,800 — unlimited exits during visa validity

**Where**: Immigration office or airport (before departure)

**Don't Forget**: Common mistake that costs your visa.

---

## Visa Agents

**What They Do**:
- Handle paperwork
- Navigate immigration
- Accompany you or go on your behalf
- Resolve issues

**Cost**: ฿500-5,000 depending on complexity

**When Useful**:
- First time extending visa
- Complex situations
- Don't speak Thai
- Value your time

**Finding One**:
- Ask at language school (ED visa)
- Facebook expat groups
- Thai Visa forum

---

## Common Mistakes

1. **Overstaying**: ฿500/day fine, potential ban, detention if long
2. **Forgetting 90-day report**: ฿2,000 fine
3. **No re-entry permit**: Visa cancelled when you leave
4. **Insufficient funds**: Can be asked to prove at border
5. **Expired passport**: Need 6+ months validity
6. **Working on tourist visa**: Deportation if caught

---

## Embassy/Consulate Tips

**For Tourist Visa Application**:
- Apply 1-2 weeks before travel
- Some consulates easier than others
- Have all documents ready
- Dress appropriately
- Be polite

**Bangkok Immigration Office**:
- Chaengwattana Government Complex
- Go early (7-8 AM)
- Bring all possible documents
- Photos: 4x6 cm, white background
- Dress conservatively
- Long wait typical
