# Bangkok Transport Guide

## Overview

Bangkok's traffic is legendary — among the worst in the world. Public transit (BTS/MRT) is excellent but limited in coverage. Most residents use a combination.

### Transit Modes

| Mode | Best For | Cost |
|------|----------|------|
| **BTS Skytrain** | Sukhumvit/Silom corridors | ฿17-62 |
| **MRT** | Chinatown, connecting areas | ฿17-42 |
| **Grab/Taxi** | Door-to-door, off-rail areas | ฿60-300+ |
| **Motorbike taxi** | Short hops, beating traffic | ฿20-100 |
| **Buses** | Budget, willing to be slow | ฿8-25 |
| **Boats** | Riverside, old town | ฿10-50 |

---

## BTS Skytrain

The backbone of Bangkok transit.

### Lines

**Sukhumvit Line (Light Green)**
- Mo Chit ↔ Kheha (extended)
- Key stations: Siam, Asok, Phrom Phong, Thong Lo, On Nut

**Silom Line (Dark Green)**
- National Stadium ↔ Bang Wa
- Key stations: Siam (interchange), Sala Daeng, Saphan Taksin

**Gold Line**
- Krung Thon Buri ↔ Khlong San (short, Icon Siam access)

### Operations
- **Hours**: 6:00 AM - midnight
- **Frequency**: 3-5 min peak, 5-8 min off-peak
- **Crowds**: Brutal at rush hour (7-9 AM, 5-7 PM)

### Tickets

**Single Journey**
- Buy at machines (coins or small notes)
- ฿17-62 depending on distance

**Rabbit Card (Recommended)**
- Refillable stored-value card
- ฿200 (฿100 deposit + ฿100 credit)
- Skip ticket queues
- Also works at some shops
- Buy at BTS ticket offices

### Tips
- Stand right on escalators
- Let passengers off before boarding
- Rush hour = sardine can (consider waiting for next train)
- Last trains fill up — don't miss connections

---

## MRT (Metro)

Underground system complementing BTS.

### Lines

**Blue Line (Circular)**
- Tha Phra ↔ Lak Song (full loop)
- Key stations: Sukhumvit (connects BTS Asok), Hua Lamphong, Wat Mangkon (Chinatown)

**Purple Line**
- Tao Poon ↔ Khlong Bang Phai
- Connects to Blue Line at Tao Poon

### Operations
- **Hours**: 6:00 AM - midnight
- **Frequency**: Similar to BTS

### Tickets
- **Different card from BTS** (annoying, yes)
- Single journey tokens: ฿17-42
- MRT Card available (separate from Rabbit)

### Key Connections
- **Asok (BTS)** ↔ **Sukhumvit (MRT)**: Same station, underground connection
- **Sala Daeng (BTS)** ↔ **Silom (MRT)**: Short walk
- **Mo Chit (BTS)** ↔ **Chatuchak Park (MRT)**: Adjacent

---

## Grab

Essential app. Works like Uber.

### Services
- **GrabCar**: Standard car, A/C, meter-like pricing
- **GrabBike**: Motorcycle taxi, faster, cheaper
- **GrabTaxi**: Book licensed taxis through app
- **GrabFood**: Food delivery

### Pricing
- Fixed price shown upfront
- Surge pricing during rush hour/rain
- Generally fair, often cheaper than metered taxi
- **GrabBike**: ฿25-80 for typical trips

### Tips
- Download before arriving
- Register card for cashless payments
- Set pickup point precisely (use pin)
- Message driver if location is confusing
- Thai phone number helps for driver contact

---

## Taxis

Metered taxis are everywhere and cheap.

### Finding One
- Hail on street (roof light on = available)
- Taxi stands at malls
- Grab/Bolt apps

### Meters
- **Flag fall**: 35 THB
- **Per km**: ~6-7 THB
- **Traffic waiting**: Adds up fast

### Common Issues
- **Refusing meter**: Walk away, especially near tourist spots
- **"Traffic, flat rate"**: Scam. Insist on meter.
- **Wrong route**: Use Google Maps to verify
- **No change**: Keep small bills

### Typical Costs (No Traffic)
- Siam to Thonglor: ฿80-120
- Asok to airport: ฿250-350
- With traffic: Double or more

### Tips
- Early morning/late night: Fastest times
- Rush hour: Prepare to wait or take BTS
- Airport: Use designated taxi stand, pay tolls on top
- Tip: Round up ฿10-20

---

## Motorbike Taxis

Orange vest riders at most sois.

### How It Works
- Find orange vest cluster at soi entrance
- State destination
- Negotiate price before getting on
- Helmet should be provided (often just one)

### Pricing
- Short hops (within soi): ฿20-40
- Longer rides (1-2 km): ฿40-80
- Further: ฿80-150

### When to Use
- Beating traffic for short distances
- Getting into long sois quickly
- BTS station to home
- Not for long distances (unsafe, uncomfortable)

### Safety
- Wear helmet
- Hold on
- Not recommended in heavy traffic
- Avoid during rain
- Don't use if carrying luggage

---

## Boats

Scenic and practical along the river.

### Chao Phraya Express Boat

**Route**: Runs along Chao Phraya River
**Useful stops**: Saphan Taksin (BTS), Tha Tien (Wat Pho), Tha Chang (Grand Palace), Phra Athit (Khao San)

**Flag Colors**:
- **No flag**: Local, stops everywhere (slow)
- **Orange flag**: Express, major stops (฿15-16)
- **Yellow/Green flag**: Rush hour specials
- **Blue flag**: Tourist boat (฿50/180 day pass, hop on/off)

**Hours**: ~6 AM - 7:30 PM (varies by line)

### Khlong (Canal) Boats

**Khlong Saen Saep**
- Crosses central Bangkok east-west
- Connects to Pratunam, Golden Mount
- ฿10-20
- Wet and chaotic but fast

**Tips**
- Cover backpack
- Hold on tight
- Watch for splashing
- Change boats at Pratunam pier

### Cross-River Ferries
- ฿4-5 per crossing
- Useful for: Wat Arun, Thonburi side
- Very frequent

---

## Airport Rail Link (ARL)

Connects Suvarnabhumi airport to city.

### Route
Suvarnabhumi → Makkasan (connect to MRT) → Phaya Thai (connect to BTS)

### Pricing
- **City Line**: ฿15-45 (all stops)
- All trains are same now (Express discontinued)

### Duration
- Airport to Phaya Thai: 30 minutes
- Airport to Makkasan: 25 minutes

### Connections
- **Makkasan**: Connect to MRT Phetchaburi
- **Phaya Thai**: Connect to BTS

### Tips
- First train: 5:30 AM
- Last train: midnight
- Gets crowded with luggage
- Alternative: Grab (฿300-400, 45-90 min)

---

## Buses

Cheap but complex.

### Types
- **Non-A/C (red)**: ฿8-10
- **A/C (blue)**: ฿12-25
- **Private buses**: Varies

### Using Buses
- Difficult without Thai language
- No English announcements
- Apps help: Via Bus, BMTA
- Pay conductor on board

### When Useful
- Very budget-conscious
- Time doesn't matter
- Going somewhere BTS/MRT doesn't reach

### Reality
Most expats never take buses. BTS/MRT + Grab covers 95% of needs.

---

## Google Maps

Your best friend for transport.

### Features
- Real-time traffic
- Public transit directions (BTS/MRT/Bus)
- Walking times
- Accurate for Bangkok

### Tips
- Check traffic before Grab
- Use for BTS/MRT route planning
- Walking times accurate
- Traffic predictions decent

---

## Traffic Reality

### Rush Hours
- **Morning**: 7-10 AM
- **Evening**: 4-8 PM
- **Friday evening**: Apocalyptic

### What 10 km Feels Like
- No traffic: 15-20 min
- Rush hour: 60-120 min
- Rainy rush hour: 2-3 hours

### Rain Impact
- Any rain = traffic collapse
- Flash floods common
- Some underpasses flood
- Plan extra time

---

## Cost Comparison

| Journey | BTS/MRT | Taxi | Grab | Motorbike |
|---------|---------|------|------|-----------|
| Asok to Siam | ฿33 | ฿80 | ฿70-100 | N/A |
| Thonglor to Silom | ฿51 | ฿120-200 | ฿100-180 | ฿60-100 |
| Asok to Airport | ฿45 ARL | ฿250-350 | ฿300-450 | N/A |
| Siam to Chinatown | ฿33 | ฿100-200 | ฿80-150 | ฿50-80 |

---

## Monthly Costs (Regular Commuter)

| Usage Pattern | Monthly Cost |
|---------------|--------------|
| BTS/MRT only | ฿1,500-2,500 |
| BTS + occasional Grab | ฿2,500-4,000 |
| Heavy Grab user | ฿4,000-8,000 |
| Car ownership | ฿15,000-25,000+ |
