# Bangkok Tech Industry

## Overview

Bangkok's tech scene is growing but still developing compared to Singapore or established Asian hubs. It's a mix of Thai startups, regional offices, and a growing remote work community.

## Tech Employment Landscape

### Salary Ranges (Monthly, THB)

| Role | Junior | Mid | Senior | Lead/Manager |
|------|--------|-----|--------|--------------|
| Software Developer | ฿40,000-60,000 | ฿60,000-90,000 | ฿90,000-150,000 | ฿150,000-250,000 |
| Data Scientist | ฿50,000-70,000 | ฿80,000-120,000 | ฿120,000-180,000 | ฿180,000-300,000 |
| Product Manager | ฿50,000-70,000 | ฿80,000-120,000 | ฿120,000-200,000 | ฿200,000-350,000 |
| UX/UI Designer | ฿35,000-50,000 | ฿50,000-80,000 | ฿80,000-120,000 | ฿120,000-180,000 |
| DevOps/SRE | ฿50,000-70,000 | ฿80,000-120,000 | ฿120,000-180,000 | ฿180,000-280,000 |

### Compared to Singapore
Bangkok salaries are 40-60% of Singapore but cost of living is 50-70% lower. Net quality of life can be similar.

### Compared to Western Remote
If earning Western remote salary ($8,000+/month) while living in Bangkok, you're in top 1% of income.

---

## Types of Tech Companies

### Thai Startups

**The Scene**:
- Growing but still small
- E-commerce, fintech, food delivery dominant
- Funding improving (Series A-C deals)
- More Thai-language products

**Examples**:
- Grab (regional)
- LINE MAN
- Bitkub (crypto)
- Finnomena (fintech)
- Pomelo Fashion

**Working There**:
- Mix of Thai and English
- Startup culture (long hours possible)
- Stock options sometimes offered
- Visa sponsorship for foreigners possible

### Regional Offices

**Companies with Bangkok Presence**:
- Agoda (Booking.com subsidiary) — Major employer
- LINE
- Lazada (Alibaba)
- Shopee
- Grab
- True Digital
- SCB (bank digital units)

**Working There**:
- More corporate environment
- Better benefits than startups
- English common
- Clearer career paths

### Multinationals

- Google (small office)
- Microsoft
- AWS
- IBM
- Accenture
- Thoughtworks

Smaller offices, often regional support roles.

---

## Finding Tech Jobs

### Job Boards

**Thailand-Specific**:
- **JobsDB.com**: Largest Thai job board
- **JobThai.com**: Local, Thai-language
- **LinkedIn**: Growing for tech roles

**Tech-Specific**:
- **WeWorkRemotely**: Remote (work from Bangkok)
- **AngelList**: Startups
- **Stack Overflow Jobs**

### Notable Employers (Hiring Foreigners)

**Most likely to sponsor**:
- Agoda (huge tech team, actively recruits globally)
- Grab
- LINE
- Banks (digital transformation teams)
- Consulting firms

### Networking

**Events**:
- Techsauce Summit (annual, major)
- BKK.js, Python Bangkok meetups
- Startup Grind Bangkok

**Communities**:
- Facebook: Bangkok Startups, Thai Tech Community
- Meetup.com: Various tech meetups
- Slack: Thai Tech Workers

---

## Work Permit for Tech

### Standard Route
1. Company sponsors you
2. Non-B visa → Work permit
3. Requirements: Bachelor's degree (any field), 4:1 Thai:foreign ratio at company

### Challenges
- Some startups can't/won't sponsor (ratio requirement)
- Process takes 1-2 months
- Degree must be apostilled

### Alternatives
- **LTR Visa**: If earning $80K+ remotely, work legally
- **Smart Visa**: For highly-skilled, specific sectors
- **Thailand Elite + remote work**: Gray area but common

---

## Remote Work Scene

### The Reality

Bangkok is popular for remote workers because:
- Excellent internet
- Coworking options
- Low cost of living
- Good quality of life

**Legal Status**: Working remotely on tourist/ED visa is technically illegal but enforcement on laptop workers is minimal. LTR visa solves this for high earners.

### Remote Work Numbers

If earning USD/EUR remotely:
- $3,000/month = comfortable
- $5,000/month = very comfortable
- $8,000/month = excellent lifestyle
- $10,000+/month = luxury

Most remote workers report ฿50,000-100,000 monthly spending.

---

## Tech Hubs & Neighborhoods

### Where Tech People Live/Work

**Sukhumvit (Asok-Ekkamai)**:
- Agoda HQ area
- Coworking spaces
- Good mix of work and life

**Silom/Sathorn**:
- Financial district
- Banks' digital units
- Corporate tech

**Thonglor**:
- Startup scene
- Cafés for working
- Networking events

**Ari**:
- Budget option
- Growing café scene
- Less corporate

### Coworking Spaces

| Space | Location | Monthly | Vibe |
|-------|----------|---------|------|
| True Digital Park | Punnawithi | ฿3,000-6,000 | Tech campus |
| Hubba | Multiple | ฿4,500 | Startup |
| The Hive | Multiple | ฿6,000 | Professional |
| Glowfish | Sathorn | ฿5,000 | Corporate |

**True Digital Park**: Largest tech campus, tech events, incubators, companies clustered.

---

## Tech Events

### Major Events
- **Techsauce Global Summit**: Annual, largest in SEA
- **Thailand Startup Summit**
- **FinTech Festival Asia**

### Regular Meetups
- **BKK.js**: JavaScript community
- **Python Bangkok**
- **AWS User Group Thailand**
- **Google Developer Groups**
- **Agile Thailand**

---

## Freelancing & Consulting

### Platforms
- Upwork, Toptal (global clients)
- Local: Direct outreach to Thai companies

### Rates (USD/hour)
- Junior: $20-40
- Mid: $40-70
- Senior: $70-120
- Specialist: $120-200+

### Legal Considerations
- Technically need work permit
- Many do it on tourist visa (gray area)
- LTR visa if income qualifies

---

## Pros & Cons for Tech Workers

### Pros
- Low cost of living
- Growing scene with opportunities
- Good base for regional work (SEA travel cheap)
- Quality of life
- Interesting markets to build for

### Cons
- Lower salaries than Singapore/US
- Limited senior opportunities in local market
- Visa complexity
- Thai language helpful for local companies
- Tech talent pool smaller than major hubs

---

## Career Advice

### If Working Locally
1. Target Agoda or regional companies (best pay)
2. Build network at meetups
3. Consider startup equity as compensation
4. Learn some Thai for local companies

### If Working Remotely
1. Get LTR visa if income qualifies
2. Use coworking for stability/networking
3. Join remote communities
4. Build local relationships anyway

### If Entrepreneur
1. Check BOI incentives
2. Consider True Digital Park resources
3. Thai co-founder helps but not required
4. SMART visa for founders possible
